/*
 This file is part of the BlueJ program. 
 Copyright (C) 2014,2015,2016 Michael Kölling and John Rosenberg 
 
 This program is free software; you can redistribute it and/or 
 modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation; either version 2 
 of the License, or (at your option) any later version. 
 
 This program is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of 
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details. 
 
 You should have received a copy of the GNU General Public License 
 along with this program; if not, write to the Free Software 
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
 
 This file is subject to the Classpath exception as provided in the  
 LICENSE.txt file that accompanied this code.
 */
package bluej.stride.operations;

import java.util.Arrays;
import java.util.List;

import bluej.stride.slots.EditableSlot.MenuItemOrder;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class CopyFrameAsStrideOperation extends FrameOperation
{

    public CopyFrameAsStrideOperation(InteractionManager editor)
    {
        super(editor, "COPY-STRIDE", Combine.ALL, new KeyCodeCombination(KeyCode.C, KeyCombination.SHORTCUT_DOWN));
    }
    
    @Override
    protected void execute(List<Frame> frames)
    {
        GreenfootFrameUtil.doCopyAsStride(frames);
    }

    @Override
    public List<ItemLabel> getLabels()
    {
        return Arrays.asList(l("Copy", MenuItemOrder.COPY));
    }
}