/*
 This file is part of the BlueJ program. 
 Copyright (C) 2014,2015 Michael Kölling and John Rosenberg 
 
 This program is free software; you can redistribute it and/or 
 modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation; either version 2 
 of the License, or (at your option) any later version. 
 
 This program is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of 
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details. 
 
 You should have received a copy of the GNU General Public License 
 along with this program; if not, write to the Free Software 
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
 
 This file is subject to the Classpath exception as provided in the  
 LICENSE.txt file that accompanied this code.
 */
package bluej.stride.framedjava.ast;

import java.util.List;

import bluej.stride.framedjava.slots.UnderlineContainer;
import threadchecker.OnThread;
import threadchecker.Tag;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.slots.EditableSlot;

@OnThread(Tag.FX)
public interface LinkFinder
{
    public void tryType(String typeName, int startPosition, int endPosition,
                        UnderlineContainer slot);

    public void tryVar(String varName, CodeElement el, int startPosition, int endPosition,
                       UnderlineContainer slot);
    
    public void tryMethod(String qualClassName, String methodName, List<String> paramTypes,
            int startPosition, int endPosition, UnderlineContainer slot);
}
