/*
 This file is part of the BlueJ program. 
 Copyright (C) 2010,2014,2016  Michael Kolling and John Rosenberg 
 
 This program is free software; you can redistribute it and/or 
 modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation; either version 2 
 of the License, or (at your option) any later version. 
 
 This program is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of 
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details. 
 
 You should have received a copy of the GNU General Public License 
 along with this program; if not, write to the Free Software 
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
 
 This file is subject to the Classpath exception as provided in the  
 LICENSE.txt file that accompanied this code.
 */
package bluej.editor.moe;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

import bluej.utility.javafx.SwingNodeDialog;
import threadchecker.OnThread;
import threadchecker.Tag;
import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.DialogManager;

/**
 * A print dialog with options specific to the editor.
 */
public class PrintDialog extends SwingNodeDialog
{
    private boolean ok = false; // result: which button?
    private JCheckBox printLineNumbers;
    private JCheckBox printHighlighting;
    private boolean printLineNumbersSelected;
    private boolean printHighlightingSelected;

    /**
     * Creates a new PrintDialog object.
     */
    public PrintDialog()
    {
        setTitle(Config.getString("editor.printDialog.title"));
        setModal(true);


        JPanel mainPanel = new JPanel();

        mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        mainPanel.add(Box.createVerticalStrut(
                              BlueJTheme.dialogCommandButtonsVertical));

        printLineNumbers = new JCheckBox(Config.getString("editor.printDialog.printLineNumbers"));
        printLineNumbers.setSelected(true);
        mainPanel.add(printLineNumbers);
                
        printHighlighting = new JCheckBox(Config.getString("editor.printDialog.printHighlighting"));
        mainPanel.add(printHighlighting);
                
        mainPanel.add(Box.createVerticalStrut(BlueJTheme.generalSpacingWidth));

        JPanel buttonPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        buttonPanel.setAlignmentX(Component.LEFT_ALIGNMENT);

        JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent evt) { doOK(); }
        });
        
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt)
            {
                doCancel();
            }
        });

        DialogManager.addOKCancelButtons(buttonPanel, okButton, cancelButton);

        setDefaultButton(okButton);

        mainPanel.add(buttonPanel);

        getContentPane().add(mainPanel);
        pack();

        DialogManager.centreDialog(this);
    }

    /**
     * Show this dialog and return true if "OK" was pressed, false if
     * cancelled.
     * 
     * @return the status of the print job, proceed if true, cancel if false
     */
    public boolean display()
    {
        ok = false;
        setVisible(true);

        return ok;
    }

    /**
     * Close action called when OK button is pressed.  It only sets ok boolean
     * flag to true as long as one of the check boxes is selected
     */
    public void doOK()
    {
        ok = true;
        storeValues();
        setVisible(false);
    }

    /**
     * Close action when Cancel is pressed.
     */
    public void doCancel()
    {
        ok = false;
        setVisible(false);
    }

    /**
     * Print line numbers selection status
     * 
     * @return true if radio button is selected meaning line numbers should be
     *         printed
     */
    public boolean printLineNumbers()
    {
        return printLineNumbersSelected;
    }

    /**
     * Print with syntax highlighting selection status
     * 
     * @return true if radio button is selected meaning source code should be
     *         printed with syntax highlighting
     */
    public boolean printHighlighting()
    {
        return printHighlightingSelected;
    }
    
    // While on Swing thread, store selections ready for later retrieval from another thread:
    private void storeValues()
    {
        printLineNumbersSelected = printLineNumbers.isSelected();
        printHighlightingSelected = printHighlighting.isSelected();
    }
}
