/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.system.service;

import com.pi4j.system.SystemInfo;
import java.io.IOException;
import java.text.ParseException;

public interface SystemInformationService {
    public String getProcessor() throws IOException, InterruptedException;

    @Deprecated
    public String getBogoMIPS() throws IOException, InterruptedException;

    public String[] getCpuFeatures() throws IOException, InterruptedException;

    public String getCpuImplementer() throws IOException, InterruptedException;

    public String getCpuArchitecture() throws IOException, InterruptedException;

    public String getCpuVariant() throws IOException, InterruptedException;

    public String getCpuPart() throws IOException, InterruptedException;

    public String getCpuRevision() throws IOException, InterruptedException;

    public String getHardware() throws IOException, InterruptedException;

    public String getRevision() throws IOException, InterruptedException;

    public String getSerial() throws IOException, InterruptedException;

    public String getModelName() throws IOException, InterruptedException;

    public String getOsName() throws IOException, InterruptedException;

    public String getOsVersion() throws IOException, InterruptedException;

    public String getOsArch() throws IOException, InterruptedException;

    public String getOsFirmwareBuild() throws IOException, InterruptedException;

    public String getOsFirmwareDate() throws IOException, InterruptedException, ParseException;

    public String getJavaVendor();

    public String getJavaVendorUrl();

    public String getJavaVersion();

    public String getJavaVirtualMachine();

    public String getJavaRuntime();

    public boolean isHardFloatAbi();

    public long getMemoryTotal() throws IOException, InterruptedException;

    public long getMemoryUsed() throws IOException, InterruptedException;

    public long getMemoryFree() throws IOException, InterruptedException;

    public long getMemoryShared() throws IOException, InterruptedException;

    public long getMemoryBuffers() throws IOException, InterruptedException;

    public long getMemoryCached() throws IOException, InterruptedException;

    public SystemInfo.BoardType getBoardType() throws IOException, InterruptedException;

    public float getCpuTemperature() throws IOException, InterruptedException, NumberFormatException;

    public float getCpuVoltage() throws IOException, InterruptedException, NumberFormatException;

    public float getMemoryVoltageSDRam_C() throws IOException, InterruptedException, NumberFormatException;

    public float getMemoryVoltageSDRam_I() throws IOException, InterruptedException, NumberFormatException;

    public float getMemoryVoltageSDRam_P() throws IOException, InterruptedException, NumberFormatException;

    public boolean getCodecH264Enabled() throws IOException, InterruptedException;

    public boolean getCodecMPG2Enabled() throws IOException, InterruptedException;

    public boolean getCodecWVC1Enabled() throws IOException, InterruptedException;

    public long getClockFrequencyArm() throws IOException, InterruptedException;

    public long getClockFrequencyCore() throws IOException, InterruptedException;

    public long getClockFrequencyH264() throws IOException, InterruptedException;

    public long getClockFrequencyISP() throws IOException, InterruptedException;

    public long getClockFrequencyV3D() throws IOException, InterruptedException;

    public long getClockFrequencyUART() throws IOException, InterruptedException;

    public long getClockFrequencyPWM() throws IOException, InterruptedException;

    public long getClockFrequencyEMMC() throws IOException, InterruptedException;

    public long getClockFrequencyPixel() throws IOException, InterruptedException;

    public long getClockFrequencyVEC() throws IOException, InterruptedException;

    public long getClockFrequencyHDMI() throws IOException, InterruptedException;

    public long getClockFrequencyDPI() throws IOException, InterruptedException;
}

