/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.sensor.impl;

import com.pi4j.component.sensor.DistanceSensorBase;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;

public class SRF02DistanceSensorI2C
extends DistanceSensorBase {
    private static final byte COMMAND_REGISTER = 0;
    private static final byte COMMAND_RANGE_INCHES = 80;
    private static final byte COMMAND_RANGE_CENTIMETERS = 81;
    private byte[] buffer;
    public static final int DEFAULT_ADDRESS = 112;
    private int address = 112;
    I2CDevice device = null;
    I2CBus bus = null;

    public SRF02DistanceSensorI2C(int i2c_bus_number, int device_address) throws I2CFactory.UnsupportedBusNumberException, IOException {
        this.address = device_address;
        this.bus = I2CFactory.getInstance((int)i2c_bus_number);
        this.device = this.bus.getDevice(device_address);
        this.buffer = new byte[10];
    }

    @Override
    public double getValue() {
        int result = -1;
        boolean bSuccess = false;
        try {
            this.device.write(0, (byte)81);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (!bSuccess) {
            try {
                Thread.sleep(80L);
                try {
                    this.device.read(0, this.buffer, 0, 4);
                }
                catch (IOException ioe) {
                    continue;
                }
                if (this.buffer[0] != 255) {
                    bSuccess = true;
                    result = (short)((this.buffer[2] >> 8) + (this.buffer[3] & 0xFF));
                    continue;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void setNewAddress(int newAddress) throws IOException {
        this.device.write(0, (byte)-96);
        this.device.write(0, (byte)-86);
        this.device.write(0, (byte)-91);
        this.device.write(0, (byte)newAddress);
        this.address = newAddress;
        this.device = this.bus.getDevice(this.address);
    }
}

