/*
 This file is part of the BlueJ program. 
 Copyright (C) 1999-2009,2011  Michael Kolling and John Rosenberg 
 
 This program is free software; you can redistribute it and/or 
 modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation; either version 2 
 of the License, or (at your option) any later version. 
 
 This program is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of 
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details. 
 
 You should have received a copy of the GNU General Public License 
 along with this program; if not, write to the Free Software 
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
 
 This file is subject to the Classpath exception as provided in the  
 LICENSE.txt file that accompanied this code.
 */
package bluej.debugger.jdi;

import bluej.debugger.SourceLocation;

/**
 * Represents the result of running a single test method.
 */
public class JdiTestResultFailure extends JdiTestResult
{
    SourceLocation failPoint;
    
    /**
     * Construct a new test failure result.
     */
    JdiTestResultFailure(String className, String methodName, String exceptionMsg, String traceMsg,
            SourceLocation failPoint, int runTimeMs)
    {
        super(className, methodName, runTimeMs);

        this.exceptionMsg = exceptionMsg;

        if (traceMsg != null) {
            this.traceMsg = getFilteredTrace(traceMsg);
        }
        else {
            this.traceMsg = null;
        }

        this.failPoint = failPoint;
    }
    
    @Override
    public String getExceptionMessage()
    {
        return exceptionMsg;
    }

    @Override
    public String getTrace()
    {
        return traceMsg;
    }
    
    @Override
    public SourceLocation getExceptionLocation()
    {
        return failPoint;
    }

    @Override
    public boolean isError()
    {
        return false;
    }

    @Override
    public boolean isFailure()
    {
        return true;
    }

    @Override
    public boolean isSuccess()
    {
        return false;
    }
}
