/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.Config;
import bluej.collect.StrideEditReason;
import bluej.editor.stride.FrameCatalogue;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.StrideCategory;
import bluej.stride.framedjava.frames.StrideDictionary;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameDictionary;
import bluej.stride.generic.FrameTypeCheck;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.MultiCanvasFrame;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.operations.PasteFrameOperation;
import bluej.stride.slots.EditableSlot;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import threadchecker.OnThread;
import threadchecker.Tag;

public class FrameCursor
implements RecallableFocus {
    public static final int FULL_HEIGHT = 5;
    public static final int HIDE_HEIGHT = 0;
    final int ERROR_COUNT_TRIGGER = 2;
    int consecutiveErrors = 0;
    private ContextMenu menu;
    private final FrameCanvas parentCanvas;
    private final Button node = new Button(){

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public @OnThread(value=Tag.FXPlatform, ignoreParent=true) Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objects) {
            switch (accessibleAttribute) {
                case TEXT: {
                    return FrameCursor.this.normalText;
                }
                case HELP: {
                    return FrameCursor.this.helpText;
                }
                case ROLE: {
                    return AccessibleRole.BUTTON;
                }
                case ROLE_DESCRIPTION: {
                    return "";
                }
            }
            return super.queryAccessibleAttribute(accessibleAttribute, objects);
        }
    };
    private String normalText;
    private String helpText;
    private final InteractionManager editor;
    private Canvas redCross;
    private Canvas copyingPlus;
    private ImageView dragTargetOverlayFake;

    /*
     * Enabled aggressive block sorting
     */
    @OnThread(value=Tag.FXPlatform)
    public boolean keyTyped(InteractionManager editor, FrameCanvas parentCanvas, char key, boolean ctrlDown) {
        block17: {
            if (!editor.isEditable() || !this.canInsert()) {
                return false;
            }
            if ((key = Character.toLowerCase(key)) == '?') {
                boolean show = !editor.cheatSheetShowingProperty().get();
                editor.cheatSheetShowingProperty().set(show);
                editor.recordShowHideFrameCatalogue(show, FrameCatalogue.ShowReason.MENU_OR_SHORTCUT);
                return true;
            }
            if (Character.isLetter(key) || Arrays.asList(Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('*'), Character.valueOf('='), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('\n'), Character.valueOf(' ')).contains(Character.valueOf(key))) {
                boolean selection;
                List available = editor.getDictionary().getFramesForShortcutKey(key).stream().filter(t -> parentCanvas.getParent().check(parentCanvas).canInsert((StrideCategory)((Object)((Object)t.getCategory())))).collect(Collectors.toList());
                boolean bl = selection = !editor.getSelection().getSelected().isEmpty();
                if (selection && editor.getSelection().executeKey(this, key)) {
                    return true;
                }
                if (!selection) {
                    Frame before = this.getFrameBefore();
                    if (CanvasParent.processInnerExtensionKey(this.getParentCanvas().getParent(), this.getParentCanvas(), this, key, this, before == null)) {
                        return true;
                    }
                    if (this.getFrameAfter() != null && this.getFrameAfter().notifyKeyBefore(key, this)) {
                        return true;
                    }
                    if (before != null && before.notifyKeyAfter(key, this)) {
                        return true;
                    }
                }
                if (available.size() > 1) {
                    throw new IllegalStateException("Ambigious keypress: " + key + " in frame: " + String.valueOf(parentCanvas.getParent()) + " [" + available.stream().map(e -> e.getName()).collect(Collectors.joining(", ")) + "]");
                }
                if (available.size() == 1) {
                    FrameDictionary.Entry frameType = (FrameDictionary.Entry)available.get(0);
                    if (!selection || frameType.isValidOnSelection()) {
                        Frame newFrame;
                        editor.beginRecordingState(this);
                        editor.recordEdits(StrideEditReason.FLUSH);
                        this.showHide(false);
                        if (selection) {
                            List<Frame> selected = editor.getSelection().getSelected();
                            List<Frame> selectedCopy = Utility.mapList(selected, f -> Loader.loadElement(((CodeElement)((CodeFrame)((Object)f)).getCode()).toXML()).createFrame(editor));
                            newFrame = frameType.getFactory().createBlock(editor, selectedCopy);
                            this.insertBlockBefore(newFrame);
                            selected.forEach(f -> f.getParentCanvas().removeBlock((Frame)f));
                            editor.getSelection().clear();
                        } else {
                            newFrame = frameType.getFactory().createBlock(editor);
                            this.insertBlockBefore(newFrame);
                        }
                        editor.recordEdits(selection ? StrideEditReason.SELECTION_WRAP_KEY : StrideEditReason.SINGLE_FRAME_INSERTION_KEY);
                        editor.modifiedFrame(newFrame, false);
                        newFrame.markFresh();
                        if (!newFrame.focusWhenJustAdded()) {
                            this.showHide(true);
                            editor.updateCatalog(this);
                        }
                        if (ctrlDown) {
                            newFrame.insertedWithCtrl();
                        }
                        editor.endRecordingState(null);
                        this.consecutiveErrors = 0;
                        return true;
                    }
                    break block17;
                } else {
                    BooleanProperty cheatSheetShowingProperty;
                    ++this.consecutiveErrors;
                    if (this.consecutiveErrors >= 2 && !(cheatSheetShowingProperty = editor.cheatSheetShowingProperty()).get()) {
                        cheatSheetShowingProperty.set(true);
                        editor.recordShowHideFrameCatalogue(true, FrameCatalogue.ShowReason.UNKNOWN_FRAME_COMMAND);
                    }
                    editor.recordUnknownCommandKey(this.getEnclosingFrame(), this.getCursorIndex(), key);
                    return true;
                }
            }
            editor.recordUnknownCommandKey(this.getEnclosingFrame(), this.getCursorIndex(), key);
        }
        editor.getSelection().clear();
        return false;
    }

    public int getCursorIndex() {
        return this.parentCanvas.getCursors().indexOf(this);
    }

    public FrameCursor(InteractionManager editor, FrameCanvas parentCanvas) {
        this.node.getStyleClass().add((Object)"frame-cursor");
        this.node.setMaxWidth(100.0);
        this.node.setMaxHeight(0.0);
        this.node.setOpacity(0.0);
        this.parentCanvas = parentCanvas;
        if (parentCanvas == null) {
            throw new IllegalArgumentException("BlockCursor: parentCanvas cannot be null");
        }
        this.editor = editor;
        this.node.minWidthProperty().bind((ObservableValue)this.node.maxWidthProperty());
        this.node.prefWidthProperty().bind((ObservableValue)this.node.maxWidthProperty());
        this.node.minHeightProperty().bind((ObservableValue)this.node.maxHeightProperty());
        this.node.prefHeightProperty().bind((ObservableValue)this.node.maxHeightProperty());
        JavaFXUtil.addChangeListener(this.node.focusedProperty(), nowFocused -> {
            if (this.node.getScene() != null) {
                this.showHide((boolean)nowFocused);
            }
            if (nowFocused.booleanValue()) {
                this.normalText = "frame cursor normal text";
                this.helpText = "frame cursor help text";
                if (this.getFrameAfter() != null) {
                    this.normalText = this.getFrameAfter().getScreenReaderText((Frame.View)((Object)((Object)this.getEditor().viewProperty().get())));
                    this.helpText = "you are before a" + this.getFrameAfter().getFrameName() + "," + parentCanvas.getParentLocationDescription();
                } else {
                    this.normalText = "no frame selected";
                    CanvasParent.CanvasKind area = parentCanvas.getParent().getChildKind(parentCanvas);
                    switch (area) {
                        case STATEMENTS: {
                            this.helpText = "you are " + parentCanvas.getParentLocationDescription();
                            break;
                        }
                        default: {
                            this.helpText = "you are in the " + String.valueOf((Object)area) + " area, " + parentCanvas.getParentLocationDescription();
                        }
                    }
                }
            }
        });
        JavaFXUtil.addChangeListener(this.node.localToSceneTransformProperty(), t -> JavaFXUtil.runNowOrLater(() -> this.adjustDragTargetPosition()));
        if (editor != null) {
            editor.setupFrameCursor(this);
        }
        this.node.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
            if (e.getButton() == MouseButton.PRIMARY && editor != null && !this.isFocused()) {
                editor.clickNearestCursor(e.getSceneX(), e.getSceneY(), e.isShiftDown());
                e.consume();
            }
        });
        JavaFXUtil.listenForContextMenu((Node)this.node, this::showContextMenu, new KeyCode[0]);
        this.getNode().focusedProperty().addListener((observable, oldValue, nowFocused) -> {
            if (!nowFocused.booleanValue()) {
                this.consecutiveErrors = 0;
            }
        });
        this.getNode().setOnKeyTyped(event -> {
            try {
                String character = event.getCharacter();
                if (!character.isEmpty()) {
                    boolean ignore;
                    char key = character.toCharArray()[0];
                    boolean bl = ignore = Config.isMacOS() && event.isShortcutDown();
                    if (!ignore && this.keyTyped(editor, parentCanvas, key, event.isControlDown())) {
                        event.consume();
                    }
                }
            }
            catch (Exception ex) {
                Debug.reportError("CURSOR KEY PRESS: ", ex);
            }
        });
        this.getNode().setOnKeyPressed(event -> {
            if (!editor.isEditable()) {
                return;
            }
            if (!(event.getCode() != KeyCode.BACK_SPACE && event.getCode() != KeyCode.DELETE || editor.getSelection().getSelected().isEmpty())) {
                List<Frame> toDelete = editor.getSelection().getSelected();
                FrameCursor focusAfter = toDelete.get(0).getCursorBefore();
                editor.beginRecordingState(this);
                if (toDelete.stream().allMatch(f -> f.getParentCanvas() == this.getParentCanvas())) {
                    editor.recordEdits(StrideEditReason.FLUSH);
                    int effort = toDelete.stream().mapToInt(Frame::calculateEffort).sum();
                    editor.showUndoDeleteBanner(effort);
                    FrameCanvas c = this.getParentCanvas();
                    toDelete.forEach(f -> c.removeBlock((Frame)f));
                    editor.recordEdits(event.getCode() == KeyCode.BACK_SPACE ? StrideEditReason.DELETE_FRAMES_KEY_BKSP : StrideEditReason.DELETE_FRAMES_KEY_DELETE);
                } else {
                    Debug.message("Warning: trying to delete selection from remote cursor");
                }
                editor.getSelection().clear();
                focusAfter.requestFocus();
                editor.endRecordingState(focusAfter);
                editor.updateCatalog(focusAfter);
                event.consume();
                return;
            }
            if (event.getCode() == KeyCode.BACK_SPACE) {
                Frame target = parentCanvas.getFrameBefore(this);
                if (target != null) {
                    int deleteEffort;
                    boolean isDeletingJointFrame = target instanceof MultiCanvasFrame && target.getCanvases().count() > 1L;
                    editor.beginRecordingState(this);
                    FrameCursor cursorBeforeTarget = isDeletingJointFrame ? this : parentCanvas.getCursorBefore(target);
                    editor.recordEdits(StrideEditReason.FLUSH);
                    if (isDeletingJointFrame) {
                        FrameCanvas lastJointCanvas = ((MultiCanvasFrame)target).getLastCanvas();
                        deleteEffort = lastJointCanvas.getBlockContents().stream().mapToInt(frame -> frame.calculateEffort()).sum();
                        ((MultiCanvasFrame)target).removeCanvas(lastJointCanvas);
                    } else {
                        deleteEffort = target.calculateEffort();
                        parentCanvas.removeBlock(target);
                    }
                    editor.showUndoDeleteBanner(deleteEffort);
                    editor.recordEdits(StrideEditReason.DELETE_FRAMES_KEY_BKSP);
                    editor.modifiedFrame(target, false);
                    cursorBeforeTarget.requestFocus();
                    editor.endRecordingState(cursorBeforeTarget);
                } else {
                    editor.beginRecordingState(this);
                    FrameCursor cursorBeforeTarget = parentCanvas.getParent().getCursorBefore(parentCanvas);
                    CanvasParent.processInnerExtensionKey(parentCanvas.getParent(), parentCanvas, this, '\b', this, true);
                    editor.endRecordingState(cursorBeforeTarget);
                }
            } else if (event.getCode() == KeyCode.ESCAPE) {
                Frame target = parentCanvas.getFrameBefore(this);
                if (target != null) {
                    target.escape(null, null);
                } else {
                    Frame BeforeTarget = parentCanvas.getParent().getCursorBefore(parentCanvas).getFrameAfter();
                    if (BeforeTarget != null) {
                        BeforeTarget.escape(null, null);
                    }
                }
            } else if (event.getCode() == KeyCode.DELETE) {
                Frame target = parentCanvas.getFrameAfter(this);
                if (target != null) {
                    editor.beginRecordingState(this);
                    editor.recordEdits(StrideEditReason.FLUSH);
                    editor.showUndoDeleteBanner(target.calculateEffort());
                    parentCanvas.removeBlock(target);
                    editor.recordEdits(StrideEditReason.DELETE_FRAMES_KEY_DELETE);
                    editor.modifiedFrame(target, false);
                    editor.endRecordingState(this);
                }
            } else if (event.getCode() == KeyCode.ENTER) {
                this.keyTyped(editor, parentCanvas, '\n', false);
            } else if (event.getCode() == KeyCode.SPACE && event.isControlDown()) {
                this.keyTyped(editor, parentCanvas, ' ', event.isControlDown());
            }
        });
    }

    private void showHide(boolean show) {
        this.node.setOpacity(show ? 1.0 : 0.0);
        this.node.setMaxHeight(show ? 5.0 : 0.0);
    }

    @OnThread(value=Tag.FXPlatform)
    public void showAsDropTarget(boolean showAsSource, boolean dragPossible, boolean copying) {
        int chosen = dragPossible ? (showAsSource ? 1 : 0) : 2;
        this.showHide(true);
        this.setDragClass(chosen);
        this.updateDragCopyState(copying);
    }

    @OnThread(value=Tag.FXPlatform)
    private void setDragClass(int classIndex) {
        JavaFXUtil.selectPseudoClass((Node)this.node, classIndex, "bj-drag-possible", "bj-drag-source", "bj-drag-impossible");
        this.setDragTargetOverlayVisible(classIndex != -1, classIndex == 2);
    }

    @OnThread(value=Tag.FXPlatform)
    private void adjustDragTargetPosition() {
        if (this.dragTargetOverlayFake != null) {
            Pane dragTargetCursorPane = this.editor.getDragTargetCursorPane();
            Bounds scenePos = this.getNode().localToScene(this.getNode().getBoundsInLocal());
            Bounds panePos = dragTargetCursorPane.sceneToLocal(scenePos);
            this.dragTargetOverlayFake.setLayoutX(panePos.getMinX());
            this.dragTargetOverlayFake.setLayoutY(panePos.getMinY());
            if (this.redCross != null) {
                this.redCross.setLayoutX(this.dragTargetOverlayFake.getLayoutX() + this.node.widthProperty().divide(2.0).subtract(this.redCross.getWidth() / 2.0).get());
                this.redCross.setLayoutY(this.dragTargetOverlayFake.getLayoutY() + this.node.heightProperty().divide(2.0).subtract(this.redCross.getHeight() / 2.0).get());
            }
            if (this.copyingPlus != null) {
                this.copyingPlus.setLayoutX(this.dragTargetOverlayFake.getLayoutX() + this.node.getWidth());
                this.copyingPlus.setLayoutY(this.dragTargetOverlayFake.getLayoutY() - this.copyingPlus.getWidth());
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void setDragTargetOverlayVisible(boolean visible, boolean showCross) {
        Pane dragTargetCursorPane = this.editor.getDragTargetCursorPane();
        if (visible) {
            WritableImage snapshot = this.getNode().snapshot(null, null);
            this.dragTargetOverlayFake = new ImageView((Image)snapshot);
            dragTargetCursorPane.getChildren().add((Object)this.dragTargetOverlayFake);
            if (showCross && this.redCross == null) {
                this.redCross = new Canvas(15.0, 15.0);
                GraphicsContext gc = this.redCross.getGraphicsContext2D();
                gc.setStroke((Paint)Color.RED);
                gc.setLineWidth(2.0);
                gc.strokeLine(1.0, 1.0, this.redCross.getWidth() - 2.0, this.redCross.getHeight() - 2.0);
                gc.strokeLine(this.redCross.getWidth() - 2.0, 1.0, 1.0, this.redCross.getHeight() - 2.0);
                dragTargetCursorPane.getChildren().add((Object)this.redCross);
            }
            this.adjustDragTargetPosition();
        } else {
            if (this.dragTargetOverlayFake != null) {
                dragTargetCursorPane.getChildren().remove((Object)this.dragTargetOverlayFake);
                this.dragTargetOverlayFake = null;
            }
            if (this.redCross != null) {
                dragTargetCursorPane.getChildren().remove((Object)this.redCross);
                this.redCross = null;
            }
            if (this.copyingPlus != null) {
                dragTargetCursorPane.getChildren().remove((Object)this.copyingPlus);
                this.copyingPlus = null;
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void stopShowAsDropTarget() {
        this.showHide(false);
        this.setDragClass(-1);
    }

    public void insertBlockAfter(Frame b) {
        this.getParentCanvas().insertBlockAfter(b, this);
    }

    public void insertBlockBefore(Frame b) {
        this.getParentCanvas().insertBlockBefore(b, this);
    }

    public FrameTypeCheck check() {
        return this.getParentCanvas().getParent().check(this.getParentCanvas());
    }

    public void insertFramesAfter(List<Frame> frames) {
        ArrayList<Frame> rev = new ArrayList<Frame>(frames);
        Collections.reverse(rev);
        rev.forEach(f -> this.getParentCanvas().insertBlockAfter((Frame)f, this));
    }

    public FrameCursor getNextSkip() {
        return this.parentCanvas.getNextCursor(this, false);
    }

    public FrameCursor getPrevSkip() {
        return this.parentCanvas.getPrevCursor(this, false);
    }

    public FrameCursor getUp() {
        Frame frameBefore = this.getFrameBefore();
        if (frameBefore != null) {
            return frameBefore.getCursorBefore();
        }
        return this.parentCanvas.getParent().getCursorBefore(this.parentCanvas);
    }

    public FrameCursor getDown() {
        Frame frameAfter = this.getFrameAfter();
        if (frameAfter != null) {
            return frameAfter.getCursorAfter();
        }
        return this.parentCanvas.getParent().getCursorAfter(this.parentCanvas);
    }

    public Frame getFrameBefore() {
        return this.parentCanvas.getFrameBefore(this);
    }

    public Frame getFrameAfter() {
        return this.parentCanvas.getFrameAfter(this);
    }

    public FrameCanvas getParentCanvas() {
        return this.parentCanvas;
    }

    public Frame getEnclosingFrame() {
        FrameCanvas parentCanvas = this.getParentCanvas();
        if (parentCanvas == null) {
            return null;
        }
        CanvasParent canvasParent = parentCanvas.getParent();
        if (canvasParent == null) {
            return null;
        }
        return canvasParent.getFrame();
    }

    public Region getNode() {
        return this.node;
    }

    public void requestFocus() {
        this.node.requestFocus();
    }

    public Bounds getSceneBounds() {
        return this.node.localToScene(this.node.getBoundsInLocal());
    }

    public InteractionManager getEditor() {
        return this.editor;
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean showContextMenu(double screenX, double screenY) {
        if (JavaFXUtil.hasPseudoclass((Styleable)this.node, "bj-java-preview")) {
            return false;
        }
        if (this.menu != null) {
            this.menu.hide();
        }
        this.menu = AbstractOperation.MenuItems.makeContextMenu(Collections.singletonMap(EditableSlot.TopLevelMenu.EDIT, this.getMenuItems(true)));
        if (this.menu.getItems().size() > 0) {
            this.menu.show((Node)this.node, screenX, screenY);
            return true;
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    public AbstractOperation.MenuItems getMenuItems(boolean contextMenu) {
        boolean selection = !this.editor.getSelection().isEmpty();
        AbstractOperation.MenuItems menuItems = new AbstractOperation.MenuItems((ObservableList<AbstractOperation.SortedMenuItem>)FXCollections.observableArrayList((Object[])new AbstractOperation.SortedMenuItem[]{new PasteFrameOperation(this.editor).getMenuItem(contextMenu, () -> this.editor.getSelection().getSelected())}));
        if (!this.editor.getSelection().isEmpty()) {
            menuItems = AbstractOperation.MenuItems.concat(AbstractOperation.getMenuItems(this.editor.getSelection().getSelected(), contextMenu), menuItems);
        }
        if (this.canInsert() && contextMenu && !selection) {
            Menu insertMenu = new Menu("Insert");
            insertMenu.getItems().addAll(this.getAcceptedFramesMenuItems());
            menuItems = AbstractOperation.MenuItems.concat(new AbstractOperation.MenuItems((ObservableList<AbstractOperation.SortedMenuItem>)FXCollections.observableArrayList((Object[])new AbstractOperation.SortedMenuItem[]{AbstractOperation.MenuItemOrder.INSERT_FRAME.item((MenuItem)insertMenu)})), menuItems);
        }
        return menuItems;
    }

    private List<MenuItem> getAcceptedFramesMenuItems() {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        List entries = StrideDictionary.getDictionary().getAllBlocks();
        for (FrameDictionary.Entry<StrideCategory> entry : entries) {
            if (!this.check().canInsert((StrideCategory)((Object)entry.getCategory()))) continue;
            items.add(this.createMenuItem(entry, this));
        }
        return items;
    }

    private MenuItem createMenuItem(FrameDictionary.Entry<StrideCategory> entry, FrameCursor cursor) {
        Label d = new Label();
        d.setText(entry.getShortcuts() + "\t  " + entry.getName());
        d.setPrefWidth(250.0);
        MenuItem item = new MenuItem(entry.getName());
        item.setOnAction(e -> {
            this.editor.beginRecordingState(this);
            this.editor.recordEdits(StrideEditReason.FLUSH);
            Frame newFrame = entry.getFactory().createBlock(this.editor);
            cursor.insertBlockAfter(newFrame);
            this.editor.recordEdits(StrideEditReason.SINGLE_FRAME_INSERTION_CONTEXT_MENU);
            newFrame.markFresh();
            newFrame.focusWhenJustAdded();
            this.editor.endRecordingState(null);
            this.editor.getSelection().clear();
            e.consume();
        });
        return item;
    }

    @Override
    public boolean isFocused() {
        return this.node.isFocused();
    }

    @Override
    public int getFocusInfo() {
        return -1;
    }

    @Override
    public Node recallFocus(int info) {
        this.requestFocus();
        return this.node;
    }

    @OnThread(value=Tag.FXPlatform)
    public void updateDragCopyState(boolean copying) {
        if (this.dragTargetOverlayFake == null) {
            return;
        }
        Pane dragTargetCursorPane = this.editor.getDragTargetCursorPane();
        if (copying && this.copyingPlus == null) {
            this.copyingPlus = new Canvas(12.0, 12.0);
            GraphicsContext gc = this.copyingPlus.getGraphicsContext2D();
            double middle = this.copyingPlus.getHeight() / 2.0;
            gc.setStroke((Paint)Color.BLACK);
            gc.setLineWidth(4.0);
            gc.strokeLine(middle, 0.0, middle, this.copyingPlus.getHeight());
            gc.strokeLine(0.0, middle, this.copyingPlus.getWidth(), middle);
            gc.setStroke((Paint)Color.WHITE);
            gc.setLineWidth(2.0);
            gc.strokeLine(middle, 2.0, middle, this.copyingPlus.getHeight() - 2.0);
            gc.strokeLine(2.0, middle, this.copyingPlus.getWidth() - 2.0, middle);
            dragTargetCursorPane.getChildren().add((Object)this.copyingPlus);
        } else if (!copying && this.copyingPlus != null) {
            dragTargetCursorPane.getChildren().remove((Object)this.copyingPlus);
            this.copyingPlus = null;
        }
        this.adjustDragTargetPosition();
    }

    public void setView(Frame.View view, SharedTransition animateProgress) {
        JavaFXUtil.setPseudoclass("bj-java-preview", view == Frame.View.JAVA_PREVIEW, new Node[]{this.node});
    }

    public boolean canInsert() {
        Frame f;
        CanvasParent cp = this.getParentCanvas().getParent();
        if (cp != null && (f = cp.getFrame()) != null) {
            return f.isFrameEnabled();
        }
        return true;
    }
}

