/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.generic.Frame;
import bluej.stride.operations.FrameOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class ExtensionsDictionary {
    private final List<Entry> entries;

    protected ExtensionsDictionary(List<Entry> entries) {
        this.entries = entries;
    }

    public List<Entry> getAllExtensions() {
        return this.entries;
    }

    public List<Entry> getExtyensionsForShortcutKey(char k) {
        return this.entries.stream().filter(e -> e.hasShortcut(k)).collect(Collectors.toList());
    }

    public static class Entry {
        private final FrameOperation operation;
        private final List<Character> shortcutKeys;
        private final String name;
        private final String description;
        private final boolean validOnSelection;

        public Entry(List<Character> shortcutKeys, FrameOperation operation, boolean validOnSelection, String name, String description) {
            this.shortcutKeys = new ArrayList<Character>(shortcutKeys);
            this.operation = operation;
            this.name = name;
            this.description = description;
            this.validOnSelection = validOnSelection;
        }

        public Entry(char shortcutKey, FrameOperation operation, boolean validOnSelection, String name, String description) {
            this(Arrays.asList(Character.valueOf(shortcutKey)), operation, validOnSelection, name, description);
        }

        public boolean hasShortcut(char k) {
            return this.shortcutKeys.contains(Character.valueOf(k));
        }

        public List<Character> getReadOnlyShortcuts() {
            return Collections.unmodifiableList(this.shortcutKeys);
        }

        public FrameOperation getOperation() {
            return this.operation;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        @OnThread(value=Tag.FXPlatform)
        public void activate(Frame frame) {
            this.operation.activate(frame);
        }

        public boolean validOnSelection() {
            return this.validOnSelection;
        }

        public String getShortcuts() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.shortcutKeys.get(0));
            for (int i = 1; i < this.shortcutKeys.size(); ++i) {
                builder.append(", ").append(this.shortcutKeys.get(i));
            }
            return builder.toString();
        }
    }
}

