/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.editor.fixes.Correction;
import bluej.editor.stride.FrameEditor;
import bluej.parser.JavaParser;
import bluej.parser.lexer.LocatableToken;
import bluej.stride.framedjava.ast.ASTUtility;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.StructuredSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.errors.MissingDoubleEqualsError;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.errors.UndeclaredMethodInExpressionError;
import bluej.stride.framedjava.errors.UndeclaredVariableInExpressionError;
import bluej.stride.framedjava.errors.UndeclaredVariableLvalueError;
import bluej.stride.framedjava.errors.UnknownTypeError;
import bluej.stride.framedjava.errors.UnneededSemiColonError;
import bluej.stride.framedjava.errors.UnreportedExceptionError;
import bluej.stride.framedjava.frames.AssignFrame;
import bluej.stride.framedjava.frames.MethodFrameWithBody;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class ExpressionSlotFragment
extends StructuredSlotFragment {
    private ExpressionSlot slot;
    private final List<LocatableToken> plainsVar = new ArrayList<LocatableToken>();
    private final List<LocatableToken> plainsMeth = new ArrayList<LocatableToken>();
    private List<LocatableToken> curCompound = null;
    private final List<List<LocatableToken>> compounds = new ArrayList<List<LocatableToken>>();
    private final List<List<LocatableToken>> types = new ArrayList<List<LocatableToken>>();
    private Map<String, CodeElement> vars;
    private AssignFrame assignmentLHSParent;

    @OnThread(value=Tag.FXPlatform)
    public ExpressionSlotFragment(String content, String javaCode, ExpressionSlot slot) {
        super(content, javaCode);
        this.slot = slot;
        Parser.parseAsExpression(new JavaParser(new StringReader(this.wrapForParse(this.getJavaCode())), false){
            boolean ignoreNext;
            {
                this.ignoreNext = false;
            }

            @Override
            protected void gotIdentifier(LocatableToken token) {
                if (!this.ignoreNext) {
                    ExpressionSlotFragment.this.plainsVar.add(ExpressionSlotFragment.this.unwrapForParse(token));
                }
                this.ignoreNext = false;
            }

            @Override
            protected void gotMethodCall(LocatableToken token) {
                if (!this.ignoreNext) {
                    ExpressionSlotFragment.this.plainsMeth.add(ExpressionSlotFragment.this.unwrapForParse(token));
                }
                this.ignoreNext = false;
            }

            @Override
            protected void gotIdentifierEOF(LocatableToken token) {
                this.gotIdentifier(token);
            }

            @Override
            protected void gotArrayTypeIdentifier(LocatableToken token) {
            }

            @Override
            protected void gotParentIdentifier(LocatableToken token) {
            }

            @Override
            protected void gotBinaryOperator(LocatableToken token) {
                if (token.getType() == 173) {
                    this.ignoreNext = true;
                }
            }

            @Override
            protected void gotCompoundIdent(LocatableToken token) {
                if (ExpressionSlotFragment.this.curCompound != null) {
                    throw new IllegalStateException();
                }
                ExpressionSlotFragment.this.curCompound = new ArrayList<LocatableToken>();
                ExpressionSlotFragment.this.curCompound.add(token);
            }

            @Override
            protected void gotCompoundComponent(LocatableToken token) {
                if (ExpressionSlotFragment.this.curCompound == null || ExpressionSlotFragment.this.curCompound.isEmpty()) {
                    throw new IllegalStateException();
                }
                ExpressionSlotFragment.this.curCompound.add(token);
            }

            @Override
            protected void gotMemberAccess(LocatableToken token) {
            }

            @Override
            protected void completeCompoundValue(LocatableToken token) {
                ExpressionSlotFragment.this.compounds.add(this.finishCompound(token));
            }

            private List<LocatableToken> finishCompound(LocatableToken token) {
                if (ExpressionSlotFragment.this.curCompound == null || ExpressionSlotFragment.this.curCompound.isEmpty()) {
                    throw new IllegalStateException();
                }
                ExpressionSlotFragment.this.curCompound.add(token);
                List<LocatableToken> r = Utility.mapList(ExpressionSlotFragment.this.curCompound, ExpressionSlotFragment.this::unwrapForParse);
                ExpressionSlotFragment.this.curCompound = null;
                return r;
            }

            @Override
            protected void completeCompoundClass(LocatableToken token) {
                ExpressionSlotFragment.this.types.add(this.finishCompound(token));
            }

            @Override
            protected void gotTypeSpec(List<LocatableToken> tokens) {
                ExpressionSlotFragment.this.types.add(Utility.mapList(tokens, ExpressionSlotFragment.this::unwrapForParse));
            }
        });
    }

    public ExpressionSlotFragment(String content, String javaCode) {
        this(content, javaCode, null);
    }

    public ExpressionSlotFragment(ExpressionSlotFragment f) {
        this(f.content, f.getJavaCode());
    }

    @Override
    public String getJavaCode(JavaFragment.Destination dest, ExpressionSlot<?> completing, Parser.DummyNameGenerator dummyNameGenerator) {
        if (!dest.substitute() || this.slot == completing || this.getJavaCode() != null && Parser.parseableAsExpression(this.wrapForParse(this.getJavaCode()))) {
            return this.getJavaCode();
        }
        return "0!=true";
    }

    @Override
    public ExpressionSlot getSlot() {
        return this.slot;
    }

    public void registerSlot(ExpressionSlot slot) {
        if (this.slot == null) {
            this.slot = slot;
        }
    }

    protected abstract boolean isRequired();

    protected String wrapForParse(String orig) {
        return orig;
    }

    protected LocatableToken unwrapForParse(LocatableToken token) {
        return token;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Stream<SyntaxCodeError> findEarlyErrors() {
        if (this.content != null && this.content.endsWith(";")) {
            return Stream.of(new UnneededSemiColonError(this, () -> this.getSlot().setText(this.content.substring(0, this.content.length() - 1))));
        }
        if (this.content != null && this.content.isEmpty() && this.isRequired()) {
            return Stream.of(new SyntaxCodeError((SlotFragment)this, "Expression cannot be empty"));
        }
        if (this.content == null || !Parser.parseableAsExpression(this.wrapForParse(this.getJavaCode()))) {
            return Stream.of(new SyntaxCodeError((SlotFragment)this, "Invalid expression"));
        }
        return Stream.empty();
    }

    @Override
    public Future<List<DirectSlotError>> findLateErrors(InteractionManager editor, CodeElement parent, LocatableElement.LocationMap rootPathMap) {
        CompletableFuture<List<DirectSlotError>> f = new CompletableFuture<List<DirectSlotError>>();
        Platform.runLater(() -> ASTUtility.withLocalsParamsAndFields(parent, editor, this.getPosInSourceDoc(), this.includeDirectDecl(), vars -> {
            this.vars = vars;
            FrameEditor frameEditor = editor.getFrameEditor();
            List undeclaredVarErrors = this.plainsVar.stream().map(identToken -> {
                if (!vars.containsKey(identToken.getText())) {
                    if (this.assignmentLHSParent != null && identToken.getText().equals(this.getJavaCode())) {
                        return new UndeclaredVariableLvalueError(this, this.assignmentLHSParent, vars.keySet());
                    }
                    return new UndeclaredVariableInExpressionError(this, identToken.getText(), identToken.getColumn() - 1, identToken.getColumn() - 1 + identToken.getLength(), this.slot, vars.keySet());
                }
                return null;
            }).filter(x -> x != null).collect(Collectors.toList());
            ASTUtility.withMethods(parent, editor, this.getPosInSourceDoc(), this.includeDirectDecl(), methods -> {
                List undeclaredMethodErrors = this.plainsMeth.stream().map(identToken -> {
                    if (!methods.contains(identToken.getText())) {
                        return new UndeclaredMethodInExpressionError(this, identToken.getText(), identToken.getColumn() - 1, identToken.getColumn() - 1 + identToken.getLength(), this.slot, (List<String>)methods);
                    }
                    return null;
                }).filter(x -> x != null).collect(Collectors.toList());
                editor.withTypes(availableTypes -> {
                    Stream<DirectSlotError> unknownTypeErrors = this.types.stream().filter(t -> t.size() == 1).map(t -> (LocatableToken)t.get(0)).map(token -> {
                        String typeName = token.getText();
                        if (availableTypes.containsKey(typeName)) {
                            return null;
                        }
                        final int startPosInSlot = token.getColumn() - 1;
                        final int endPosInSlot = token.getColumn() - 1 + token.getLength();
                        FXPlatformConsumer<Correction.CorrectionElements> replace = correctionElements -> this.slot.replace(startPosInSlot, endPosInSlot, true, correctionElements.getPrimaryElement());
                        return new UnknownTypeError(this, this, typeName, replace, editor, availableTypes.values().stream(), frameEditor.getEditorFixesManager().getImportSuggestions().values().stream().flatMap(Collection::stream)){

                            @Override
                            public int getStartPosition() {
                                return startPosInSlot;
                            }

                            @Override
                            public int getEndPosition() {
                                return endPosInSlot;
                            }
                        };
                    }).filter(x -> x != null);
                    ArrayList<MissingDoubleEqualsError> missingDoubleEqualsErrors = new ArrayList<MissingDoubleEqualsError>();
                    ArrayList unreportedExceptionErrors = new ArrayList();
                    String errorMessage = this.getErrorMessage();
                    if (errorMessage != null) {
                        if (errorMessage.startsWith("incompatible types:") && errorMessage.endsWith("cannot be converted to boolean") && this.getJavaCode().charAt(this.getErrorStartPos()) == '=') {
                            missingDoubleEqualsErrors.add(new MissingDoubleEqualsError(this, this.getErrorStartPos(), frameEditor));
                        }
                        if (errorMessage.startsWith("unreported exception ") && errorMessage.contains(";")) {
                            String exceptionType = errorMessage.substring("unreported exception ".length(), errorMessage.indexOf(59));
                            Platform.runLater(() -> {
                                boolean hasAlreadyThrowsForType = false;
                                FrameCanvas c = this.getSlot().getParentFrame().getParentCanvas();
                                while (c != null && c.getParent() != null && c.getParent().getFrame() != null) {
                                    MethodFrameWithBody methodFrame;
                                    if (c.getParent().getFrame() instanceof MethodFrameWithBody && (methodFrame = (MethodFrameWithBody)c.getParent().getFrame()).hasThrowsForType(exceptionType)) {
                                        hasAlreadyThrowsForType = true;
                                    }
                                    c = c.getParent().getFrame().getParentCanvas();
                                }
                                if (errorMessage.startsWith("unreported exception ") && !hasAlreadyThrowsForType) {
                                    unreportedExceptionErrors.add(new UnreportedExceptionError(this, this.getErrorStartPos(), frameEditor, exceptionType, vars.keySet()));
                                }
                            });
                        }
                    }
                    f.complete(Stream.concat(undeclaredVarErrors.stream(), Stream.concat(undeclaredMethodErrors.stream(), Stream.concat(unknownTypeErrors, Stream.concat(missingDoubleEqualsErrors.stream(), unreportedExceptionErrors.stream())))).peek(e -> e.recordPath(rootPathMap.locationFor(this))).collect(Collectors.toList()));
                });
            });
        }));
        return f;
    }

    protected boolean includeDirectDecl() {
        return false;
    }

    public void markAssignmentLHS(AssignFrame parent) {
        this.assignmentLHSParent = parent;
    }

    @Override
    public Map<String, CodeElement> getVars() {
        return this.vars;
    }
}

