/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.parser.AssistContent;
import java.util.Arrays;
import java.util.List;

public enum AccessPermission {
    PRIVATE("private"),
    PROTECTED("protected"),
    PUBLIC("public"),
    EMPTY("");

    private String displayName;

    private AccessPermission(String displayName) {
        this.displayName = displayName;
    }

    public String toString() {
        return this.displayName;
    }

    public String getJavaCode() {
        return this.displayName;
    }

    public AssistContent.Access asAccess() {
        switch (this.ordinal()) {
            case 0: {
                return AssistContent.Access.PRIVATE;
            }
            case 1: {
                return AssistContent.Access.PROTECTED;
            }
            case 2: {
                return AssistContent.Access.PUBLIC;
            }
        }
        return null;
    }

    public static List<AccessPermission> all() {
        return Arrays.asList(PRIVATE, PROTECTED, PUBLIC);
    }

    public static AccessPermission fromString(String s) {
        for (AccessPermission a : AccessPermission.all()) {
            if (!a.toString().equals(s)) continue;
            return a;
        }
        return EMPTY;
    }

    public static boolean isValid(AccessPermission ap) {
        return ap == PRIVATE || ap == PROTECTED || ap == PUBLIC;
    }

    public static AccessPermission fromAccess(AssistContent.Access access) {
        switch (access) {
            case PRIVATE: {
                return PRIVATE;
            }
            case PROTECTED: 
            case PACKAGE: {
                return PROTECTED;
            }
            case PUBLIC: {
                return PUBLIC;
            }
        }
        return EMPTY;
    }
}

