/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.Config;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.collections.FXCollections;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class InterfacePanel
extends VBox
implements PrefPanelListener {
    private ArrayList<String> allLangsInternal;
    private ComboBox langDropdown;
    private CheckBox terminalScopes;
    private CheckBox accessibility;
    private CheckBox toggleTestNewsMode;

    public InterfacePanel() {
        String langString;
        JavaFXUtil.addStyleClass((Styleable)this, "prefmgr-pref-panel");
        ArrayList<Node> langPanel = new ArrayList<Node>();
        this.allLangsInternal = new ArrayList();
        ArrayList<String> allLangsReadable = new ArrayList<String>();
        int i = 1;
        while ((langString = Config.getPropString("bluej.language" + i, null)) != null) {
            int colonIndex = langString.indexOf(58);
            if (colonIndex != -1) {
                int secondColon = langString.indexOf(58, colonIndex + 1);
                if (secondColon == -1) {
                    secondColon = langString.length();
                }
                this.allLangsInternal.add(langString.substring(0, colonIndex));
                allLangsReadable.add(langString.substring(colonIndex + 1, secondColon));
            }
            ++i;
        }
        if (this.allLangsInternal.isEmpty()) {
            this.allLangsInternal.add(Config.language);
            allLangsReadable.add(Config.language);
        }
        Object[] langs = new String[allLangsReadable.size()];
        allLangsReadable.toArray(langs);
        this.langDropdown = new ComboBox(FXCollections.observableArrayList((Object[])langs));
        langPanel.add(PrefMgrDialog.labelledItem("prefmgr.interface.language", (Node)this.langDropdown));
        Label t = new Label(Config.getString("prefmgr.interface.language.restart"));
        langPanel.add((Node)t);
        this.getChildren().add((Object)PrefMgrDialog.headedVBox("prefmgr.interface.language.title", langPanel));
        this.terminalScopes = new CheckBox(Config.getString("prefmgr.terminal.scopes"));
        this.getChildren().add((Object)PrefMgrDialog.headedVBox("prefmgr.terminal.title", Arrays.asList(this.terminalScopes)));
        this.accessibility = new CheckBox(Config.getString("prefmgr.accessibility.support"));
        this.getChildren().add((Object)PrefMgrDialog.headedVBox("prefmgr.accessibility.title", Arrays.asList(this.accessibility)));
        this.toggleTestNewsMode = new CheckBox("Switch to testing mode for news display (after restart)");
        this.toggleTestNewsMode.setOpacity(0.0);
        this.toggleTestNewsMode.setOnMouseMoved(e -> {
            if (e.isShiftDown()) {
                this.toggleTestNewsMode.setOpacity(1.0);
            }
        });
        this.getChildren().add((Object)this.toggleTestNewsMode);
    }

    @Override
    public void beginEditing(Project project) {
        String currentLang = Config.getPropString("bluej.language", "english");
        int curLangIndex = this.allLangsInternal.indexOf(currentLang);
        if (curLangIndex == -1) {
            curLangIndex = 0;
        }
        this.langDropdown.getSelectionModel().select(curLangIndex);
        this.terminalScopes.setSelected(PrefMgr.getFlag("bluej.terminal.showScopes"));
        this.accessibility.setSelected(PrefMgr.getFlag("bluej.accessibility.support"));
        this.toggleTestNewsMode.setSelected(PrefMgr.getFlag("bluej.news.testing"));
        if (this.toggleTestNewsMode.isSelected()) {
            this.toggleTestNewsMode.setOpacity(1.0);
        }
    }

    @Override
    public void commitEditing(Project project) {
        boolean testNewsMode;
        Config.putPropString("bluej.language", this.allLangsInternal.get(this.langDropdown.getSelectionModel().getSelectedIndex()));
        PrefMgr.setFlag("bluej.terminal.showScopes", this.terminalScopes.isSelected());
        project.getTerminal().rerenderStdout();
        PrefMgr.setFlag("bluej.accessibility.support", this.accessibility.isSelected());
        boolean bl = testNewsMode = this.toggleTestNewsMode.isSelected() && this.toggleTestNewsMode.getOpacity() == 1.0;
        if (testNewsMode && !PrefMgr.getFlag("bluej.news.testing")) {
            Config.putPropString("bluej.latest.msg", "");
        }
        PrefMgr.setFlag("bluej.news.testing", testNewsMode);
    }

    @Override
    public void revertEditing(Project project) {
    }
}

