/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.Config;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerField;
import bluej.debugmgr.inspector.FieldInfo;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.pkgmgr.Package;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.JavaNames;
import bluej.utility.javafx.JavaFXUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ClassInspector
extends Inspector {
    protected static final String CLASS_INSPECT_TITLE = Config.getString("debugger.inspector.class.title");
    protected static final String CLASS_NAME_LABEL = Config.getString("debugger.inspector.class.nameLabel");
    protected static final String ENUM_INSPECT_TITLE = Config.getString("debugger.inspector.enum.title");
    protected static final String ENUM_NAME_LABEL = Config.getString("debugger.inspector.enum.nameLabel");
    protected static final String INTERFACE_INSPECT_TITLE = Config.getString("debugger.inspector.interface.title");
    protected static final String INTERFACE_NAME_LABEL = Config.getString("debugger.inspector.interface.nameLabel");
    protected static final String noFieldsMsg = Config.getString("debugger.inspector.class.noFields");
    protected static final String numFields = Config.getString("debugger.inspector.numFields");
    protected DebuggerClass myClass;
    private VBox contentPane;

    public ClassInspector(DebuggerClass clss, InspectorManager inspectorManager, Package pkg, InvokerRecord ir, Window parent) {
        super(inspectorManager, pkg, ir, StageStyle.TRANSPARENT);
        this.myClass = clss;
        this.makeFrame();
        this.update();
        this.setMinWidth(500.0);
        this.setMinHeight(260.0);
        this.installListenersForMoveDrag(8.0);
    }

    protected void makeFrame() {
        String className = JavaNames.stripPrefix(this.myClass.getName());
        String headerString = null;
        String suffix = " " + numFields + " " + this.getListData().size();
        if (this.myClass.isEnum()) {
            this.setTitle(ENUM_INSPECT_TITLE + " " + className + suffix);
            headerString = ENUM_NAME_LABEL + " " + className;
        } else if (this.myClass.isInterface()) {
            this.setTitle(INTERFACE_INSPECT_TITLE + " " + className + suffix);
            headerString = INTERFACE_NAME_LABEL + " " + className;
        } else {
            this.setTitle(CLASS_INSPECT_TITLE + " " + className + suffix);
            headerString = CLASS_NAME_LABEL + " " + className;
        }
        VBox header = new VBox();
        Label headerLabel = new Label(headerString);
        header.getChildren().add((Object)headerLabel);
        JavaFXUtil.addStyleClass((Styleable)header, "inspector-header", "inspector-class-header");
        BorderPane mainPanel = new BorderPane();
        mainPanel.setCenter((Node)this.fieldList);
        this.fieldList.setPlaceHolderText("  " + noFieldsMsg);
        mainPanel.setRight(this.createInspectAndGetButtons());
        BorderPane buttonPanel = new BorderPane();
        Button button = this.createCloseButton();
        buttonPanel.setRight((Node)button);
        this.contentPane = new VBox();
        this.contentPane.getChildren().addAll((Object[])new Node[]{header, mainPanel, buttonPanel});
        VBox.setVgrow((Node)mainPanel, (Priority)Priority.ALWAYS);
        JavaFXUtil.addStyleClass((Styleable)this.contentPane, "inspector", "inspector-class");
        button.setDefaultButton(true);
        BorderPane root = new BorderPane((Node)this.contentPane);
        root.setBackground(null);
        Scene scene = new Scene((Parent)root);
        scene.setFill(null);
        this.setScene(scene);
    }

    protected boolean showingResult() {
        return false;
    }

    @Override
    protected boolean shouldAutoUpdate() {
        return Config.isGreenfoot();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    protected List<FieldInfo> getListData() {
        List<DebuggerField> fields = this.myClass.getStaticFields();
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>(fields.size());
        for (DebuggerField field : fields) {
            String desc = Inspector.fieldToString(field);
            String value = field.getValueString();
            fieldInfos.add(new FieldInfo(desc, value));
        }
        return fieldInfos;
    }

    @Override
    protected void listElementSelected(int slot) {
        DebuggerField field;
        DebuggerField debuggerField = field = slot == -1 ? null : this.myClass.getStaticField(slot);
        if (field != null && field.isReferenceType() && !field.isNull()) {
            this.setCurrentObj(field.getValueObject(null), field.getName(), field.getType().toString());
            if (Modifier.isPublic(field.getModifiers())) {
                this.setButtonsEnabled(true, true);
            } else {
                this.setButtonsEnabled(true, false);
            }
        } else {
            this.setCurrentObj(null, null, null);
            this.setButtonsEnabled(false, false);
        }
    }

    protected void showClass() {
    }

    protected void prepareInspection() {
    }

    @Override
    protected void remove() {
        if (this.inspectorManager != null) {
            this.inspectorManager.removeInspector(this.myClass);
        }
    }

    @Override
    protected int getPreferredRows() {
        return 8;
    }

    @Override
    public Region getContent() {
        return this.contentPane;
    }
}

