/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import bluej.debugger.SourceLocation;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public abstract class DebuggerTestResult {
    public String getQualifiedMethodName() {
        String methodName = this.getMethodName();
        String rawMethodName = methodName.contains("(") ? methodName.substring(0, methodName.indexOf("(")) : methodName;
        return this.getQualifiedClassName() + "." + rawMethodName;
    }

    public abstract String getMethodName();

    public abstract String getQualifiedClassName();

    public abstract String getDisplayName();

    public abstract int getRunTimeMs();

    public abstract boolean isSuccess();

    public abstract boolean isFailure();

    public abstract boolean isError();

    public abstract String getTrace();

    public abstract String getExceptionMessage();

    public abstract SourceLocation getExceptionLocation();
}

