/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.compiler.CompileInputFile;
import bluej.compiler.CompileObserver;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.Diagnostic;
import bluej.compiler.FXCompileObserver;
import bluej.utility.javafx.FXPlatformRunnable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;

public final class EventqueueCompileObserverAdapter
implements CompileObserver {
    private FXCompileObserver link;

    public EventqueueCompileObserverAdapter(FXCompileObserver link) {
        this.link = link;
    }

    private void runOnEventQueue(FXPlatformRunnable action) {
        CompletableFuture f = new CompletableFuture();
        Platform.runLater(() -> {
            try {
                action.run();
            }
            catch (Throwable t) {
                f.complete(Optional.of(t));
            }
            finally {
                if (!f.isDone()) {
                    f.complete(Optional.empty());
                }
            }
        });
        try {
            Optional optThrow = (Optional)f.get();
            if (optThrow.isPresent()) {
                throw new RuntimeException((Throwable)optThrow.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void compilerMessage(Diagnostic diagnostic, CompileType type) {
        this.runOnEventQueue(() -> this.link.compilerMessage(diagnostic, type));
    }

    @Override
    public synchronized void startCompile(CompileInputFile[] csources, CompileReason reason, CompileType type, int compilationSequence) {
        this.runOnEventQueue(() -> this.link.startCompile(csources, reason, type, compilationSequence));
    }

    @Override
    public synchronized void endCompile(CompileInputFile[] sources, boolean successful, CompileType type, int compilationSequence) {
        this.runOnEventQueue(() -> this.link.endCompile(sources, successful, type, compilationSequence));
    }
}

