/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Dictionary;
import java.util.StringTokenizer;

public class BlueJFileReader {
    private static final int tabSize = Config.getPropInteger("bluej.editor.tabsize", 4);
    private static final String spaces = "                                        ";
    private static final char TAB_CHAR = '\t';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readHelpText(File file, String textID, boolean exactMatch) {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "8859_1"));
            Object helptext = "";
            block14: while (true) {
                String msg;
                if ((msg = in.readLine()) != null) {
                    String line;
                    msg = msg.trim();
                    boolean match = exactMatch ? msg.equals(textID) : BlueJFileReader.helpTextMatch(textID, msg);
                    if (match) {
                        line = in.readLine();
                        if (line != null && line.length() > 0) {
                            helptext = line;
                            line = in.readLine();
                        }
                        while (line != null && line.length() > 0) {
                            helptext = (String)helptext + "\n" + line;
                            line = in.readLine();
                        }
                        String string = BlueJFileReader.convert((String)helptext);
                        return string;
                    }
                    line = in.readLine();
                    while (true) {
                        if (line == null || line.length() <= 0) continue block14;
                        line = in.readLine();
                    }
                }
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private static boolean helpTextMatch(String message, String pattern) {
        if (pattern.length() == 0) {
            return false;
        }
        if (pattern.charAt(pattern.length() - 1) == '*') {
            if (pattern.charAt(0) == '*') {
                return message.indexOf(pattern = pattern.substring(1, pattern.length() - 3)) > -1;
            }
            return message.startsWith(pattern.substring(0, pattern.length() - 2));
        }
        if (pattern.charAt(0) == '*') {
            return message.endsWith(pattern.substring(1));
        }
        return pattern.equals(message);
    }

    public static void translateFile(File template, File dest, Dictionary<String, String> translations, Charset templateCharset, Charset outputCharset) throws IOException {
        BlueJFileReader.translateFile(template, dest, translations, true, templateCharset, outputCharset);
    }

    private static void translateFile(File template, File dest, Dictionary<String, String> translations, boolean replaceTabs, Charset templateCharset, Charset outputCharset) throws IOException {
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        String newline = System.getProperty("line.separator");
        try {
            int c;
            in = new InputStreamReader((InputStream)new FileInputStream(template), templateCharset);
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(dest), outputCharset);
            while ((c = in.read()) != -1) {
                if (c == 36) {
                    StringBuffer buf = new StringBuffer();
                    while ((c = in.read()) != -1 && Character.isLetter((char)c)) {
                        buf.append((char)c);
                    }
                    String key = buf.toString();
                    if (key.length() != 0) {
                        String value = translations.get(key);
                        if (value == null) {
                            out.write(36);
                            value = key;
                        }
                        if (replaceTabs && value.indexOf(9) != -1) {
                            value = BlueJFileReader.convertTabsToSpaces(value);
                        }
                        out.write(value);
                    } else if (c != 36) {
                        out.write(36);
                    }
                    if (c == -1) continue;
                    out.write(c);
                    continue;
                }
                if (replaceTabs && c == 9) {
                    out.write(BlueJFileReader.tabAsSpace());
                    continue;
                }
                if (c == 13) {
                    int nc = in.read();
                    if (nc == 10) {
                        out.write(newline);
                        continue;
                    }
                    out.write(c);
                    if (nc == -1) continue;
                    out.write(nc);
                    continue;
                }
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            throw e;
        }
    }

    public static void duplicateFile(File original, File destination, Dictionary<String, String> translations) throws IOException {
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(original));
            out = new BufferedWriter(new FileWriter(destination));
            while ((line = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, " (){}.,\"><", true);
                while (st.hasMoreTokens()) {
                    String key = st.nextToken();
                    String value = translations.get(key);
                    if (value == null) {
                        value = key;
                    }
                    out.write(value);
                }
                out.newLine();
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            throw e;
        }
    }

    private static String convertTabsToSpaces(String tabString) {
        return tabString.replaceAll("\t", BlueJFileReader.tabAsSpace());
    }

    private static String tabAsSpace() {
        return spaces.substring(0, tabSize);
    }

    private static String convert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            char aChar;
            if ((aChar = theString.charAt(x++)) == '\\') {
                if ((aChar = theString.charAt(x++)) == 'u') {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                outBuffer.append('\\');
                outBuffer.append(aChar);
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }
}

