/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.Config;
import bluej.editor.base.BackgroundItem;
import bluej.editor.base.BaseEditorPane;
import bluej.editor.base.EditorPosition;
import bluej.editor.base.TextLine;
import bluej.prefmgr.PrefMgr;
import bluej.terminal.ContentLine;
import bluej.terminal.ExceptionSourceLocation;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;

public abstract class TerminalTextPane
extends BaseEditorPane {
    private final ArrayList<ContentLine> content = new ArrayList();
    private final ArrayList<FXPlatformRunnable> contentListeners = new ArrayList();
    private Pos caretPos = new Pos(0, 0, 0);
    private Pos anchorPos = new Pos(0, 0, 0);
    private final ArrayList<Section> currentSections = new ArrayList();

    private TerminalPos getCurStart() {
        if (this.content.isEmpty()) {
            return new TerminalPos(0, 0);
        }
        return new TerminalPos(this.content.size() - 1, this.content.get(this.content.size() - 1).getText().length());
    }

    private TerminalPos getCurEnd() {
        if (this.content.isEmpty()) {
            return new TerminalPos(0, 0);
        }
        String lastLine = this.content.get(this.content.size() - 1).getText();
        if (lastLine.isEmpty()) {
            return new TerminalPos(this.content.size() - 2, Integer.MAX_VALUE);
        }
        return new TerminalPos(this.content.size() - 1, lastLine.length());
    }

    public void markNewSection(String sectionTitle) {
        if (!this.currentSections.isEmpty()) {
            int lastLineIndex = this.currentSections.size() - 1;
            Section last = this.currentSections.get(lastLineIndex);
            if (last.end.line < 0) {
                this.currentSections.set(lastLineIndex, new Section(last.start, this.getCurEnd()));
            }
        }
        this.currentSections.add(new Section(this.getCurStart(), new TerminalPos(-1, 0)));
    }

    public void endSection() {
        if (!this.currentSections.isEmpty()) {
            if (this.content.isEmpty()) {
                this.currentSections.clear();
            } else {
                int lastSection = this.currentSections.size() - 1;
                Section last = this.currentSections.get(lastSection);
                this.currentSections.set(lastSection, new Section(last.start, this.getCurEnd()));
                this.updateRender(false);
            }
        }
    }

    public TerminalTextPane(Stage terminalWindow) {
        super(false, new BaseEditorPane.BaseEditorPaneListener(){

            public boolean marginClickedForLine(int lineIndex) {
                return false;
            }

            public ContextMenu getContextMenuToShow(BaseEditorPane editorPane) {
                return new ContextMenu(new MenuItem[]{JavaFXUtil.makeMenuItem(Config.getString("editor.copyLabel"), () -> ((TerminalTextPane)editorPane).copy(), null)});
            }

            public void scrollEventOnTextLine(ScrollEvent e, BaseEditorPane editorPane) {
                editorPane.scrollEventOnTextLine(e);
            }
        });
        this.clear();
        Nodes.addInputMap((Node)this, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.EQUALS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), e -> Utility.increaseFontSize(PrefMgr.getEditorFontSize())), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), e -> Utility.decreaseFontSize(PrefMgr.getEditorFontSize())), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), e -> PrefMgr.getEditorFontSize().set(10))}));
        JavaFXUtil.addChangeListenerPlatform(PrefMgr.getEditorFontSize(), s -> this.lineDisplay.fontSizeChanged());
    }

    protected void keyPressed(KeyEvent event) {
        int caretLine = this.caretPos.getLine();
        switch (event.getCode()) {
            case CONTEXT_MENU: {
                this.showContextMenuAtCaret();
                event.consume();
                return;
            }
            case ENTER: 
            case SPACE: {
                Object customData = this.content.get(this.caretPos.getLine()).getCustomStyleDataAtColumn(this.caretPos.getColumn());
                if (customData != null && customData instanceof ExceptionSourceLocation) {
                    ((ExceptionSourceLocation)customData).showInEditor();
                    event.consume();
                }
                return;
            }
            case C: {
                if (event.isShortcutDown()) {
                    this.copy();
                }
                return;
            }
            case TAB: {
                if (event.isShiftDown()) {
                    this.focusPrevious();
                } else {
                    this.focusNext();
                }
                event.consume();
                return;
            }
            case UP: {
                int destLine = Math.max(0, caretLine - 1);
                this.caretPos = this.makePosition(destLine, Math.min(this.caretPos.getColumn(), this.getLineLength(destLine)));
                break;
            }
            case DOWN: {
                int destLine = Math.min(this.getLineCount() - 1, caretLine + 1);
                this.caretPos = this.makePosition(destLine, Math.min(this.caretPos.getColumn(), this.getLineLength(destLine)));
                break;
            }
            case LEFT: {
                int destColumn;
                int prevColumn = this.caretPos.getColumn() - 1;
                int destLine = caretLine;
                if (prevColumn < 0) {
                    if (caretLine > 0) {
                        destLine = caretLine - 1;
                        destColumn = this.getLineLength(destLine);
                    } else {
                        destColumn = 0;
                    }
                } else {
                    destColumn = prevColumn;
                }
                this.caretPos = this.makePosition(destLine, destColumn);
                break;
            }
            case RIGHT: {
                int destColumn;
                int destLine = caretLine;
                int lineEnd = this.getLineLength(caretLine);
                int nextColumn = this.caretPos.getColumn() + 1;
                if (nextColumn > lineEnd) {
                    if (caretLine < this.getLineCount() - 1) {
                        destLine = caretLine + 1;
                        destColumn = 0;
                    } else {
                        destColumn = lineEnd;
                    }
                } else {
                    destColumn = nextColumn;
                }
                this.caretPos = this.makePosition(destLine, destColumn);
                break;
            }
            default: {
                return;
            }
        }
        if (!event.isShiftDown()) {
            this.anchorPos = new Pos(this.caretPos.getPosition(), this.caretPos.getLine(), this.caretPos.getColumn());
        }
        this.updateRender(true);
        event.consume();
    }

    public abstract void focusPrevious();

    public abstract void focusNext();

    protected void updateRender(boolean ensureCaretVisible) {
        super.updateRender(ensureCaretVisible);
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        boolean reschedule = false;
        if (PrefMgr.getFlag("bluej.terminal.showScopes")) {
            for (int i = 0; i < this.content.size(); ++i) {
                if (!this.lineDisplay.isLineVisible(i)) continue;
                for (Section s : this.currentSections) {
                    double singleRadius = 5.0;
                    double topRadius = 0.0;
                    double bottomRadius = 0.0;
                    double topInset = 0.0;
                    double bottomInset = 0.0;
                    double leftInset = 0.0;
                    double rightInset = this.getTextDisplayWidth() - 1.0;
                    if (s.start.line == i) {
                        topRadius = 5.0;
                        topInset = 1.0;
                        if (s.start.column >= 0 && s.start.column < this.content.get(i).getText().length()) {
                            edge = this.lineDisplay.calculateLeftEdgeX(i, s.start.column);
                            reschedule |= edge.isEmpty();
                            leftInset = edge.orElse(leftInset);
                        }
                        if (s.end.line == i) {
                            bottomRadius = 5.0;
                            bottomInset = 1.0;
                            if (s.end.column >= 0 && s.end.column <= this.content.get(i).getText().length()) {
                                edge = this.lineDisplay.calculateLeftEdgeX(i, s.end.column);
                                reschedule |= edge.isEmpty();
                                rightInset = edge.orElse(rightInset);
                            }
                        }
                    } else if (s.end.line == i) {
                        bottomRadius = 5.0;
                        bottomInset = 1.0;
                        if (s.end.column >= 0 && s.end.column <= this.content.get(i).getText().length()) {
                            edge = this.lineDisplay.calculateLeftEdgeX(i, s.end.column);
                            reschedule |= edge.isEmpty();
                            rightInset = edge.orElse(rightInset);
                        }
                    } else if (s.start.line >= i || s.end.line != -1 && s.end.line <= i) continue;
                    CornerRadii radii = new CornerRadii(topRadius, topRadius, bottomRadius, bottomRadius, false);
                    Insets bodyInsets = new Insets(topInset, 1.0, bottomInset, 1.0);
                    map.computeIfAbsent(i, _i -> new ArrayList()).add(new BackgroundItem(leftInset, rightInset - leftInset, new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGRAY, radii, null), new BackgroundFill((Paint)Color.WHITE, radii, bodyInsets)}));
                }
            }
        }
        this.lineDisplay.applyScopeBackgrounds(map);
        if (reschedule) {
            JavaFXUtil.runAfterNextLayout(this.getScene(), () -> this.updateRender(false));
        }
    }

    public final void requestFocusAndShowCaret() {
        this.requestFocus();
        this.updateRender(true);
    }

    protected void keyTyped(KeyEvent event) {
    }

    protected void mouseMoved(MouseEvent e) {
        this.getCaretPositionForMouseEvent(e).ifPresent(p -> {
            Object styleData = this.content.get(p.getLine()).getCustomStyleDataAtColumn(p.getColumn());
            if (styleData != null && styleData instanceof ExceptionSourceLocation) {
                this.setCursor(Cursor.HAND);
            } else {
                this.setCursor(null);
            }
        });
    }

    protected void mousePressed(MouseEvent e) {
        this.requestFocus();
        if (e.getButton() == MouseButton.PRIMARY) {
            boolean setAnchor = !e.isShiftDown();
            this.getCaretPositionForMouseEvent(e).ifPresent(p -> {
                if (setAnchor) {
                    this.caretPos = new Pos(p.getPosition(), p.getLine(), p.getColumn());
                    this.anchorPos = new Pos(p.getPosition(), p.getLine(), p.getColumn());
                } else {
                    this.moveCaret((EditorPosition)p, true);
                }
            });
            this.updateRender(true);
        }
    }

    protected void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (e.isStillSincePress()) {
            this.getCaretPositionForMouseEvent(e).ifPresent(p -> {
                Object styleData = this.content.get(p.getLine()).getCustomStyleDataAtColumn(p.getColumn());
                if (styleData != null && styleData instanceof ExceptionSourceLocation) {
                    ((ExceptionSourceLocation)styleData).showInEditor();
                }
            });
        }
    }

    protected Pos makePosition(int line, int column) {
        return new Pos(this.content.stream().limit(line).mapToInt(l -> l.getText().length()).sum() + column, line, column);
    }

    protected void moveCaret(EditorPosition position, boolean ensureCaretVisible) {
        this.caretPos = new Pos(position.getPosition(), position.getLine(), position.getColumn());
        this.updateRender(ensureCaretVisible);
        this.callSelectionListeners();
    }

    public void trimToMostRecentNLines(int numLines) {
        if (this.content.size() > numLines) {
            int linesToSubtract = this.content.size() - numLines;
            this.setContent(new ArrayList<ContentLine>(this.content.subList(linesToSubtract, this.content.size())));
            int newCaretLine = Math.max(0, this.caretPos.getLine() - linesToSubtract);
            this.caretPos = this.makePosition(newCaretLine, Math.min(this.caretPos.getColumn(), this.getLineLength(newCaretLine)));
            int newAnchorLine = Math.max(0, this.anchorPos.getLine() - linesToSubtract);
            this.anchorPos = this.makePosition(newAnchorLine, Math.min(this.anchorPos.getColumn(), this.getLineLength(newAnchorLine)));
            ListIterator<Section> iterator = this.currentSections.listIterator();
            while (iterator.hasNext()) {
                Section s = iterator.next();
                if (s.end.line > 0 && s.end.line < linesToSubtract) {
                    iterator.remove();
                    continue;
                }
                iterator.set(new Section(s.start.subtractLines(linesToSubtract), s.end.subtractLines(linesToSubtract)));
            }
            this.updateRender(false);
        }
    }

    private void setContent(List<ContentLine> lines) {
        this.content.clear();
        this.content.addAll(lines);
        this.refreshDisplay();
        this.contentChanged();
    }

    private void contentChanged() {
        this.contentListeners.forEach(FXPlatformRunnable::run);
    }

    public void refreshDisplay() {
        this.updateRender(false);
    }

    public void clear() {
        this.caretPos = new Pos(0, 0, 0);
        this.anchorPos = new Pos(0, 0, 0);
        this.setContent(Collections.singletonList(new ContentLine(new ArrayList<TextLine.StyledSegment>())));
        this.currentSections.clear();
        this.lineDisplay.applyScopeBackgrounds(Map.of());
    }

    public List<String> getLines() {
        return this.content.stream().map(line -> line.getText()).collect(Collectors.toList());
    }

    protected int getLineLength(int lineIndex) {
        return this.content.get(lineIndex).getText().length();
    }

    protected String getLineContentAtCaret() {
        return this.content.get(this.caretPos.line).getText();
    }

    protected String getLongestLineInWholeDocument() {
        return this.content.stream().map(l -> l.getText()).max(Comparator.comparing(String::length)).orElse("");
    }

    protected int getLineCount() {
        return this.content.size();
    }

    public List<List<TextLine.StyledSegment>> getStyledLines() {
        return this.content.stream().map(line -> ImmutableList.copyOf((Iterable)line)).collect(Collectors.toList());
    }

    protected EditorPosition getCaretEditorPosition() {
        return this.caretPos;
    }

    protected EditorPosition getAnchorEditorPosition() {
        return this.anchorPos;
    }

    public void append(TextLine.StyledSegment styledSegment) {
        String remainder = styledSegment.getText().replaceAll("\r", "");
        while (!remainder.isEmpty()) {
            int newlineIndex = remainder.indexOf(10);
            if (newlineIndex == -1) {
                this.content.get(this.content.size() - 1).append(new TextLine.StyledSegment(styledSegment.getStyleClasses(), remainder));
                remainder = "";
                continue;
            }
            String beforeNewline = remainder.substring(0, newlineIndex);
            this.content.get(this.content.size() - 1).append(new TextLine.StyledSegment(styledSegment.getStyleClasses(), beforeNewline));
            this.content.add(new ContentLine(new ArrayList<TextLine.StyledSegment>()));
            remainder = remainder.substring(newlineIndex + 1);
        }
        this.refreshDisplay();
        this.contentChanged();
    }

    public void scrollToEnd() {
        this.lineDisplay.ensureLineVisible(this.content.size() - 1, this.getLineContainerHeight(), this.getLineCount());
        this.updateRender(false);
    }

    public void setStyleForLineSegment(int lineIndex, int start, int end, List<String> cssClasses, Object customData) {
        Iterable origLine = this.content.get(lineIndex);
        ArrayList<TextLine.StyledSegment> result = new ArrayList<TextLine.StyledSegment>();
        int charsToSkip = start;
        int charsToConsume = end - start;
        for (TextLine.StyledSegment segment : origLine) {
            int segmentLength = segment.getText().length();
            if (charsToConsume > 0 && charsToSkip < segmentLength) {
                if (charsToSkip > 0) {
                    result.add(new TextLine.StyledSegment(segment.getStyleClasses(), segment.getText().substring(0, charsToSkip), segment.getCustomData()));
                }
                int consumable = Math.min(charsToConsume, segmentLength - charsToSkip);
                result.add(new TextLine.StyledSegment(cssClasses, segment.getText().substring(charsToSkip, charsToSkip + consumable), customData));
                charsToConsume -= consumable;
                if (consumable < segmentLength - charsToSkip) {
                    result.add(new TextLine.StyledSegment(segment.getStyleClasses(), segment.getText().substring(charsToSkip + consumable), segment.getCustomData()));
                }
                charsToSkip = 0;
                continue;
            }
            result.add(segment);
            if (charsToConsume <= 0 || charsToSkip <= 0) continue;
            charsToSkip -= segmentLength;
        }
        this.content.set(lineIndex, new ContentLine(result));
    }

    public void copy() {
        StringBuilder copied = new StringBuilder();
        Pos startPos = this.anchorPos.getPosition() < this.caretPos.getPosition() ? this.anchorPos : this.caretPos;
        Pos endPos = this.anchorPos.getPosition() < this.caretPos.getPosition() ? this.caretPos : this.anchorPos;
        List<String> lines = this.getLines();
        if (startPos.getLine() == endPos.getLine()) {
            copied.append(lines.get(startPos.getLine()).substring(startPos.getColumn(), endPos.getColumn()));
        } else {
            copied.append(lines.get(startPos.getLine()).substring(startPos.getColumn())).append("\n");
            for (int line = startPos.getLine() + 1; line < endPos.getLine(); ++line) {
                copied.append(lines.get(line)).append("\n");
            }
            copied.append(lines.get(endPos.getLine()).substring(0, endPos.getColumn()));
        }
        if (copied.length() > 0) {
            Clipboard.getSystemClipboard().setContent(Map.of(DataFormat.PLAIN_TEXT, copied.toString()));
        }
    }

    public void addTextChangeListener(FXPlatformRunnable listener) {
        this.contentListeners.add(listener);
    }

    public void deselect() {
        this.anchorPos = new Pos(this.caretPos.getPosition(), this.caretPos.getLine(), this.caretPos.getColumn());
        this.updateRender(false);
        this.callSelectionListeners();
    }

    record TerminalPos(int line, int column) {
        public TerminalPos subtractLines(int linesToSubtract) {
            return new TerminalPos(this.line - linesToSubtract, this.column);
        }
    }

    record Section(TerminalPos start, TerminalPos end) {
    }

    private static class Pos
    implements EditorPosition {
        private final int line;
        private final int column;
        private final int position;

        public Pos(int position, int line, int column) {
            this.line = line;
            this.column = column;
            this.position = position;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

