/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.utility.javafx.AbstractOperation;
import java.util.Collections;
import java.util.List;
import javafx.scene.input.KeyCombination;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class FrameOperation
extends AbstractOperation<Frame> {
    protected final InteractionManager editor;

    public FrameOperation(InteractionManager editor, String identifier, AbstractOperation.Combine combine) {
        this(editor, identifier, combine, null);
    }

    public FrameOperation(InteractionManager editor, String identifier, AbstractOperation.Combine combine, KeyCombination shortcut) {
        super(identifier, combine, shortcut);
        this.editor = editor;
    }

    @OnThread(value=Tag.FXPlatform)
    public final void activate(Frame frame) {
        this.activate(Collections.singletonList(frame));
    }

    @OnThread(value=Tag.FXPlatform)
    public final void activate(Frame frame, RecallableFocus focus) {
        this.activate(Collections.singletonList(frame), focus);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public final void activate(List<Frame> frames) {
        Frame first = this.editor.getSelection().getSelected().isEmpty() ? null : (Frame)this.editor.getSelection().getSelected().get(0);
        FrameCursor focus = first == null ? null : first.getCursorBefore();
        this.activate(frames, (RecallableFocus)focus);
    }

    @OnThread(value=Tag.FXPlatform)
    public final void activate(List<Frame> frames, RecallableFocus focus) {
        this.editor.beginRecordingState(focus);
        if (this.getPreview() != null) {
            this.getPreview().disablePreview();
        }
        this.execute(frames);
        this.editor.endRecordingState(focus);
    }

    @OnThread(value=Tag.FXPlatform)
    protected abstract void execute(List<Frame> var1);

    @Override
    public KeyCombination getShortcut() {
        return this.shortcut;
    }
}

