/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.stride.framedjava.ast.links.PossibleTypeLink;
import bluej.stride.framedjava.slots.BracketedStructured;
import bluej.stride.framedjava.slots.CaretPos;
import bluej.stride.framedjava.slots.InfixStructured;
import bluej.stride.framedjava.slots.Operator;
import bluej.stride.framedjava.slots.StructuredSlot;
import bluej.stride.framedjava.slots.StructuredSlotComponent;
import bluej.stride.framedjava.slots.StructuredSlotField;
import bluej.stride.framedjava.slots.TypeSlot;
import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.FXBiConsumer;
import bluej.utility.javafx.FXConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class InfixType
extends InfixStructured<TypeSlot, InfixType> {
    private InfixType(InteractionManager editor, TypeSlot slot, String initialContent, BracketedStructured wrapper, StructuredSlot.ModificationToken token, Character ... closingChars) {
        super(editor, slot, initialContent, wrapper, token, closingChars);
    }

    InfixType(InteractionManager editor, TypeSlot slot, StructuredSlot.ModificationToken token) {
        super(editor, slot, token);
    }

    @Override
    boolean isOperator(String s) {
        switch (s) {
            case ".": 
            case ",": {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean beginsOperator(char c) {
        switch (c) {
            case ',': 
            case '.': {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean canBeUnary(String s) {
        return false;
    }

    @Override
    protected boolean isOpeningBracket(char c) {
        return c == '<' || c == '[';
    }

    @Override
    protected boolean isClosingBracket(char c) {
        return c == '>' || c == ']';
    }

    @Override
    protected boolean isDisallowed(char c) {
        return !Character.isJavaIdentifierStart(c) && !Character.isJavaIdentifierPart(c) && c != ',' && c != '.' && c != '<' && c != '>' && c != '?' && c != '[' && c != ']' && c != '$';
    }

    @Override
    InfixType newInfix(InteractionManager editor, TypeSlot slot, String initialContent, BracketedStructured wrapper, StructuredSlot.ModificationToken token, Character ... closingChars) {
        return new InfixType(editor, slot, initialContent, wrapper, token, closingChars);
    }

    @Override
    public void calculateTooltipFor(StructuredSlotField expressionSlotField, FXConsumer<String> handler) {
    }

    void runIfCommaDirect(FXBiConsumer<String, String> listener) {
        Optional<Integer> optIndex = this.operators.findFirst(op -> op != null && op.get().equals(","));
        optIndex.ifPresent(index -> {
            String before = this.getCopyText(null, new CaretPos((int)index, ((StructuredSlotComponent)this.fields.get((int)index)).getEndPos()));
            String after = this.getCopyText(new CaretPos(index + 1, new CaretPos(0, null)), null);
            listener.accept(before, after);
        });
    }

    public List<PossibleTypeLink> findTypeLinks() {
        ArrayList<PossibleTypeLink> links = new ArrayList<PossibleTypeLink>();
        int startField = 0;
        StringBuilder type = new StringBuilder(((StructuredSlotComponent)this.fields.get(0)).getCopyText(null, null));
        for (int i = 1; i <= this.fields.size(); ++i) {
            if (i - 1 >= this.operators.size() || this.operators.get(i - 1) == null || !((Operator)this.operators.get(i - 1)).get().equals(".")) {
                int end;
                int start = ((TypeSlot)this.slot).getTopLevel().caretPosToStringPos(this.absolutePos(new CaretPos(startField, ((StructuredSlotComponent)this.fields.get(startField)).getStartPos())), false);
                if (start != (end = ((TypeSlot)this.slot).getTopLevel().caretPosToStringPos(this.absolutePos(new CaretPos(i - 1, ((StructuredSlotComponent)this.fields.get(i - 1)).getEndPos())), false)) && type.length() > 0) {
                    links.add(new PossibleTypeLink(type.toString(), start, end, this.slot));
                }
                type = new StringBuilder();
                startField = i;
            } else {
                type.append(((Operator)this.operators.get(i - 1)).get());
            }
            if (i >= this.fields.size()) break;
            if (this.fields.get(i) instanceof BracketedStructured) {
                links.addAll(((InfixType)((BracketedStructured)this.fields.get(i)).getContent()).findTypeLinks());
                continue;
            }
            type.append(((StructuredSlotComponent)this.fields.get(i)).getCopyText(null, null));
        }
        return links;
    }

    @Override
    protected boolean supportsFloatLiterals() {
        return false;
    }
}

