/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.FrameFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.StructuredSlotFragment;
import bluej.stride.framedjava.ast.SuperThisFragment;
import bluej.stride.framedjava.ast.TextSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;

public class LocatableElement
extends Element {
    private final CodeElement origin;
    private final HashMap<String, JavaFragment> attrNames = new HashMap();

    public LocatableElement(CodeElement origin, String name) {
        super(name);
        this.origin = origin;
    }

    public void addAttributeStructured(String name, StructuredSlotFragment code) {
        this.attrNames.put(name, code);
        this.addAttribute(new Attribute(name, code.getContent()));
        this.addAttribute(new Attribute(name + "-java", code.getJavaCode()));
    }

    public void addAttributeAccess(String name, AccessPermissionFragment access) {
        this.attrNames.put(name, access);
        this.addAttribute(new Attribute(name, access.getContent()));
    }

    public void addAttributeSuperThis(String name, SuperThisFragment superThis) {
        this.attrNames.put(name, superThis);
        this.addAttribute(new Attribute(name, superThis.getValue().toString()));
    }

    public void addAttributeCode(String name, TextSlotFragment content) {
        this.attrNames.put(name, content);
        this.addAttribute(new Attribute(name, content.getContent()));
    }

    public LocationMap buildLocationMap() {
        final IdentityHashMap map = new IdentityHashMap();
        final IdentityHashMap elementMap = new IdentityHashMap();
        this.addToLocationMap(new HashMap<String, Integer>(), map::put, elementMap::put);
        return new LocationMap(){

            @Override
            public String locationFor(JavaFragment fragment) {
                if (map.containsKey(fragment)) {
                    return (String)map.get(fragment);
                }
                if (fragment instanceof FrameFragment) {
                    FrameFragment ff = (FrameFragment)fragment;
                    return (String)elementMap.get(ff.getElement());
                }
                return null;
            }

            @Override
            public String locationFor(CodeElement element) {
                return (String)elementMap.get(element);
            }
        };
    }

    private void addToLocationMap(Map<String, Integer> siblingCounts, BiConsumer<JavaFragment, String> map, BiConsumer<CodeElement, String> elementMap) {
        String me = "/" + this.getLocalName() + "[" + String.valueOf(siblingCounts.getOrDefault(this.getLocalName(), 1)) + "]";
        siblingCounts.put(this.getLocalName(), siblingCounts.getOrDefault(this.getLocalName(), 1) + 1);
        if (this.origin != null) {
            elementMap.accept(this.origin, me);
        }
        this.attrNames.forEach((attrName, fragment) -> map.accept((JavaFragment)fragment, me + "/@" + attrName));
        LocatableElement.processChildren(map, elementMap, this.getChildElements(), me);
    }

    private static void processChildren(BiConsumer<JavaFragment, String> map, BiConsumer<CodeElement, String> elementMap, Elements childElements, String me) {
        HashMap<String, Integer> childCounts = new HashMap<String, Integer>();
        for (int i = 0; i < childElements.size(); ++i) {
            Element child = childElements.get(i);
            if (child instanceof LocatableElement) {
                ((LocatableElement)child).addToLocationMap(childCounts, (frag, path) -> map.accept((JavaFragment)frag, me + path), (el, path) -> elementMap.accept((CodeElement)el, me + path));
                continue;
            }
            String them = "/" + child.getLocalName() + "[" + String.valueOf(childCounts.getOrDefault(child.getLocalName(), 1)) + "]";
            childCounts.put(child.getLocalName(), childCounts.getOrDefault(child.getLocalName(), 1) + 1);
            LocatableElement.processChildren(map, elementMap, child.getChildElements(), me + them);
        }
    }

    public static interface LocationMap {
        public String locationFor(JavaFragment var1);

        public String locationFor(CodeElement var1);
    }
}

