/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.editor.fixes.FixSuggestion;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.errors.EmptyError;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.frames.IfFrame;
import bluej.stride.framedjava.frames.ReturnFrame;
import bluej.stride.framedjava.frames.SwitchFrame;
import bluej.stride.framedjava.frames.ThrowFrame;
import bluej.stride.framedjava.frames.WhileFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class CallExpressionSlotFragment
extends FilledExpressionSlotFragment {
    private static final List<String> KEYWORDS = Arrays.asList("if", "while", "switch", "return", "throw");

    public CallExpressionSlotFragment(String content, String javaCode) {
        super(content, javaCode);
    }

    public CallExpressionSlotFragment(String content, String javaCode, ExpressionSlot slot) {
        super(content, javaCode, slot);
    }

    @Override
    public Stream<SyntaxCodeError> findEarlyErrors() {
        Stream<SyntaxCodeError> superErrors = super.findEarlyErrors();
        if (this.content.equals("()")) {
            return Stream.concat(Stream.of(new EmptyError((SlotFragment)this, "Method name cannot be blank")), superErrors);
        }
        if (this.content.endsWith(")") && KEYWORDS.stream().anyMatch(k -> this.content.startsWith(k + "("))) {
            String keyword = this.content.substring(0, this.content.indexOf("("));
            String innerStride = this.content.substring(this.content.indexOf("(") + 1, this.content.length() - 1);
            String javaCode = this.getJavaCode();
            String innerJava = javaCode.substring(javaCode.indexOf("(") + 1, javaCode.length() - 1);
            final ReplaceKeywordCallWithFrame fix = new ReplaceKeywordCallWithFrame(keyword, innerStride, innerJava);
            return Stream.concat(Stream.of(new SyntaxCodeError(this, this, keyword + " is not a valid method name"){

                @Override
                public List<FixSuggestion> getFixSuggestions() {
                    ArrayList<FixSuggestion> fixes = new ArrayList<FixSuggestion>();
                    fixes.addAll(super.getFixSuggestions());
                    fixes.add(fix);
                    return fixes;
                }
            }), superErrors);
        }
        return superErrors;
    }

    private class ReplaceKeywordCallWithFrame
    extends FixSuggestion {
        private final String keyword;
        private final String innerStride;
        private final String innerJava;

        public ReplaceKeywordCallWithFrame(String keyword, String innerStride, String innerJava) {
            this.keyword = keyword;
            this.innerStride = innerStride;
            this.innerJava = innerJava;
        }

        public String getDescription() {
            return "Replace with " + this.keyword + " frame";
        }

        public void execute() {
            Frame frame = CallExpressionSlotFragment.this.getSlot().getParentFrame();
            FilledExpressionSlotFragment inner = new FilledExpressionSlotFragment(this.innerStride, this.innerJava);
            switch (this.keyword) {
                case "if": {
                    frame.getParentCanvas().replaceBlock(frame, new IfFrame(frame.getEditor(), inner, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, true));
                    break;
                }
                case "while": {
                    frame.getParentCanvas().replaceBlock(frame, new WhileFrame(frame.getEditor(), inner, true));
                    break;
                }
                case "switch": {
                    frame.getParentCanvas().replaceBlock(frame, new SwitchFrame(frame.getEditor(), inner, true));
                    break;
                }
                case "return": {
                    frame.getParentCanvas().replaceBlock(frame, new ReturnFrame(frame.getEditor(), inner, true));
                    break;
                }
                case "throw": {
                    frame.getParentCanvas().replaceBlock(frame, new ThrowFrame(frame.getEditor(), inner, true));
                }
            }
        }
    }
}

