/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.editor.Editor;
import bluej.extensions2.ExternalFileLauncher;
import bluej.extensions2.PackageNotFoundException;
import bluej.extensions2.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.target.EditableTarget;
import bluej.pkgmgr.target.NonCodeEditableTarget;
import bluej.pkgmgr.target.Target;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ExternalFileTarget
extends NonCodeEditableTarget {
    private final File extFile;
    private static final String openStr = Config.getString("pkgmgr.extfilemenu.open");

    public ExternalFileTarget(Package aPackage, File extFile) {
        super(aPackage, extFile.getName(), "");
        this.extFile = extFile;
        JavaFXUtil.addStyleClass((Styleable)this.pane, "externalfile-target");
        JavaFXUtil.addStyleClass((Styleable)this.pane, "externalfile-target-id-" + extFile.getName().replace(".", "-"));
        Label name = new Label(extFile.getName());
        BorderPane.setAlignment((Node)name, (Pos)Pos.CENTER);
        this.pane.setTop((Node)name);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void doubleClick(boolean openInNewWindow) {
        OpenExternalFileAction openAction = new OpenExternalFileAction();
        openAction.activate(Arrays.asList(this));
    }

    @Override
    public List<? extends AbstractOperation<Target>> getContextOperations() {
        return List.of(new OpenExternalFileAction(), new RemoveExternalFileAction());
    }

    @Override
    public void remove() {
        this.getPackage().removeTarget(this);
        this.extFile.delete();
    }

    @Override
    protected File getSourceFile() {
        return this.extFile;
    }

    @Override
    public Editor getEditor() {
        return this.editor;
    }

    @Override
    @OnThread(value=Tag.FX)
    public boolean isResizable() {
        return true;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        props.put(prefix + ".type", "ExternalFileTarget");
    }

    private static class OpenExternalFileAction
    extends AbstractOperation<Target> {
        public OpenExternalFileAction() {
            super("openExtFile", AbstractOperation.Combine.ALL, null);
        }

        @Override
        public void activate(List<Target> targets) {
            for (Target target : targets) {
                if (!(target instanceof ExternalFileTarget)) continue;
                String fileName = ((ExternalFileTarget)target).getSourceFile().getName();
                String fileExtension = fileName.substring(fileName.lastIndexOf("."));
                try {
                    ExternalFileLauncher.OpenExternalFileHandler launcher = target.getPackage().getProject().getProjectExternalFileOpenMap().get(fileExtension);
                    launcher.openFile(((ExternalFileTarget)target).getSourceFile().getAbsolutePath());
                }
                catch (Exception e) {
                    Debug.message("A problem occurred while trying to open the external target " + fileName + ": " + e.getMessage());
                    Stage parent = null;
                    try {
                        parent = target.getPackage().getBPackage().getWindow();
                    }
                    catch (PackageNotFoundException | ProjectNotOpenException pe) {
                        Debug.message("A problem occurred while getting the current external target's related package window: " + pe.getMessage());
                    }
                    DialogManager.showErrorFX((Window)parent, "external-file-open-issue");
                }
            }
        }

        @Override
        public List<AbstractOperation.ItemLabel> getLabels() {
            return List.of(new AbstractOperation.ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(openStr), AbstractOperation.MenuItemOrder.EDIT));
        }
    }

    private static class RemoveExternalFileAction
    extends AbstractOperation<Target> {
        public RemoveExternalFileAction() {
            super("removeExtFile", AbstractOperation.Combine.ALL, null);
        }

        @Override
        public void activate(List<Target> targets) {
            PkgMgrFrame pmf;
            List extTargets = targets.stream().flatMap(t -> t instanceof ExternalFileTarget ? Stream.of((ExternalFileTarget)t) : Stream.empty()).collect(Collectors.toList());
            if (!extTargets.isEmpty() && (pmf = PkgMgrFrame.findFrame(((ExternalFileTarget)extTargets.get(0)).getPackage())) != null && pmf.askRemoveFiles()) {
                for (ExternalFileTarget extTarget : extTargets) {
                    extTarget.remove();
                }
            }
        }

        @Override
        public List<AbstractOperation.ItemLabel> getLabels() {
            return List.of(new AbstractOperation.ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(EditableTarget.removeStr), AbstractOperation.MenuItemOrder.REMOVE));
        }
    }
}

