/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.utility;

import bluej.extensions2.BlueJ;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.scene.Node;
import threadchecker.OnThread;
import threadchecker.Tag;

public class Utility {
    public static void inputStreamClose(InputStream iStream) {
        try {
            if (iStream != null) {
                iStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void outputStreamClose(OutputStream oStream) {
        try {
            if (oStream != null) {
                oStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int convStringToInt(String input, int defVal) {
        try {
            Integer risul = Integer.decode(input);
            return risul;
        }
        catch (Exception eee) {
            return defVal;
        }
    }

    @OnThread(value=Tag.Worker)
    public static boolean openWebBrowser(BlueJ bluej, URL url) {
        String urlString = Utility.encodeURLSpaces(url.toString());
        String osname = System.getProperty("os.name", "");
        if (osname.startsWith("Mac")) {
            try {
                Class<?> macClass = System.getProperty("java.vm.version").startsWith("1.3") ? Class.forName("MRJFileUtils") : Class.forName("com.apple.eio.FileManager");
                Method m = macClass.getMethod("openURL", Class.forName("java.lang.String"));
                m.invoke(null, (Object[])new String[]{urlString});
            }
            catch (Exception e) {
                return false;
            }
        }
        if (osname.startsWith("Windows")) {
            String cmd = osname.startsWith("Windows 9") || osname.equals("Windows Me") ? "command.com" : "cmd.exe";
            try {
                if (osname.startsWith("Windows 98")) {
                    Process m = Runtime.getRuntime().exec(new String[]{cmd, "/c", "start", "\"" + urlString + "\""});
                }
                Process m = Runtime.getRuntime().exec(new String[]{cmd, "/c", "start", "\"\"", "\"" + urlString + "\""});
            }
            catch (Exception e) {
                return false;
            }
        } else {
            CompletableFuture cmd1Future = new CompletableFuture();
            CompletableFuture cmd2Future = new CompletableFuture();
            Platform.runLater(() -> {
                cmd1Future.complete(bluej.getBlueJPropertyString("browserCmd1", ""));
                cmd2Future.complete(bluej.getBlueJPropertyString("browserCmd2", ""));
            });
            try {
                String cmd = (String)cmd1Future.get();
                if (cmd == null || cmd.length() == 0) {
                    return false;
                }
                cmd = Utility.mergeStrings(cmd, urlString);
                try {
                    Process p = Runtime.getRuntime().exec(cmd);
                    if (p.waitFor() == 0) {
                        return true;
                    }
                    cmd = (String)cmd2Future.get();
                    if (cmd == null || cmd.length() == 0) {
                        return false;
                    }
                    cmd = Utility.mergeStrings(cmd, urlString);
                    p = Runtime.getRuntime().exec(cmd);
                }
                catch (Exception e) {
                    return false;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private static String mergeStrings(String s1, String s2) {
        int pos = s1.indexOf(36);
        if (pos == -1) {
            return s1;
        }
        return s1.substring(0, pos) + s2 + s1.substring(pos + 1);
    }

    private static String encodeURLSpaces(String url) {
        if (url.indexOf(32) != -1) {
            StringBuffer buffer = new StringBuffer(url);
            for (int i = 0; i < buffer.length(); ++i) {
                if (buffer.charAt(i) != ' ') continue;
                buffer.deleteCharAt(i);
                buffer.insert(i, "%20");
            }
            return buffer.toString();
        }
        return url;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public static void applyStyle(Node node, String styleClass) {
        if (!node.getStyleClass().contains((Object)styleClass)) {
            node.getStyleClass().add((Object)styleClass);
        }
    }
}

