/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.transport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;
import org.bluej.extensions.submitter.transport.TransportSession;

public class FileSession
extends TransportSession {
    private int fileCounter;
    private File path;

    public FileSession(URL url, Properties environment) throws UnsupportedEncodingException {
        super(url, environment, null);
        this.result = "Not sent";
        this.fileCounter = 0;
    }

    @Override
    public void connect() throws IOException {
        this.path = new File("//" + this.url.getHost() + this.url.getFile());
    }

    @Override
    public void send(InputStream is, String name, boolean binary) throws IOException {
        int c;
        if (!this.path.exists()) {
            throw new FileNotFoundException(this.path.getPath());
        }
        File destination = new File(this.path, name);
        destination.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(destination);
        byte[] buffer = new byte[1024];
        while ((c = is.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, c);
        }
        ((OutputStream)out).close();
        ++this.fileCounter;
    }

    @Override
    public void disconnect() throws IOException {
        this.reportEvent("Connection closed.");
        this.result = null;
    }
}

