/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.bluej.extensions.submitter.MessageHandler;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.SubmitDialog;
import org.bluej.extensions.submitter.UserPasswordDialog;
import org.bluej.utility.Utility;
import threadchecker.OnThread;
import threadchecker.Tag;

class UrlRewrite {
    private Stat stat;
    private @OnThread(value=Tag.Any) URL url;
    private @OnThread(value=Tag.Any) boolean isMessage;

    @OnThread(value=Tag.Any)
    UrlRewrite(Stat i_stat) {
        this.stat = i_stat;
    }

    @OnThread(value=Tag.FXPlatform)
    boolean process(SubmitDialog parent) throws UnsupportedEncodingException {
        Collection<String> urlStrings = this.stat.schemeData.getProps(".transport");
        if (urlStrings.isEmpty()) {
            this.stat.submitDialog.statusWriteln(this.stat.bluej.getLabel("message.notransport"));
            return false;
        }
        Object urlString = urlStrings.iterator().next();
        this.isMessage = ((String)urlString).startsWith("message:");
        ArrayList<TextField> userInfo = new ArrayList<TextField>();
        GridPane gridPane = new GridPane();
        Utility.applyStyle((Node)gridPane, "url-grid");
        gridPane.setHgap(10.0);
        ColumnConstraints rightCol = new ColumnConstraints();
        rightCol.setFillWidth(true);
        rightCol.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), rightCol});
        DecimalFormat digits = new DecimalFormat("00");
        if (!this.isMessage) {
            int rowIndex = 0;
            while (true) {
                int start = ((String)urlString).indexOf(60);
                int end = ((String)urlString).indexOf(62);
                if (start == -1 && end == -1) break;
                if (start == -1 || start > end) {
                    this.stat.submitDialog.statusWriteln(this.stat.bluej.getLabel("message.badurlrequest") + " " + (String)urlString);
                    return false;
                }
                String sub = ((String)urlString).substring(start + 1, end);
                int n = sub.indexOf(61);
                int colon = sub.indexOf(58);
                if (n != -1 && colon > n) {
                    this.stat.submitDialog.statusWriteln(this.stat.bluej.getLabel("message.invalidparm") + ": " + sub);
                    return false;
                }
                String param = sub.substring(n + 1);
                Object replace = null;
                if (param.length() > 0) {
                    if (param.equals("username")) {
                        replace = URLEncoder.encode(this.stat.globalProp.getProperty("username", ""), "UTF-8");
                    } else if (param.equals("title")) {
                        replace = URLEncoder.encode(this.stat.globalProp.getProperty("title", ""), "UTF-8");
                    } else if (param.equals("simpletitle")) {
                        replace = URLEncoder.encode(this.stat.globalProp.getProperty("simpletitle", ""), "UTF-8");
                    } else if (param.equals("address")) {
                        replace = URLEncoder.encode(this.stat.globalProp.getProperty("useraddr", ""), "UTF-8");
                    } else if (param.equals("date")) {
                        replace = URLEncoder.encode(this.stat.globalProp.getProperty("date", ""), "UTF-8");
                    } else if (param.equals("isodate")) {
                        replace = URLEncoder.encode(this.stat.globalProp.getProperty("isodate", ""), "UTF-8");
                    } else if (param.length() == 2 && Character.isDigit(param.charAt(0)) && Character.isDigit(param.charAt(1))) {
                        replace = "{" + param + "}";
                    } else if (colon == -1 || n != -1) {
                        this.stat.submitDialog.statusWriteln(this.stat.bluej.getLabel("message.unknownparm") + ": " + param);
                        return false;
                    }
                }
                if (colon != -1) {
                    TextField tic;
                    String message;
                    String action = sub.substring(0, colon);
                    String string = message = n == -1 ? sub.substring(colon + 1) : sub.substring(colon + 1, n);
                    if (action.equals("field")) {
                        tic = new TextField();
                        tic.setPrefColumnCount(20);
                    } else if (action.equals("area")) {
                        tic = new TextArea();
                        ((TextArea)tic).setPrefColumnCount(20);
                        ((TextArea)tic).setPrefRowCount(4);
                    } else if (action.equals("password")) {
                        tic = new PasswordField();
                        ((PasswordField)tic).setPrefColumnCount(20);
                    } else if (action.equals("show")) {
                        tic = new TextField();
                        tic.setPrefColumnCount(20);
                        tic.setDisable(true);
                    } else {
                        this.stat.submitDialog.statusWriteln(this.stat.bluej.getLabel("message.unknownaction") + ": " + action);
                        return false;
                    }
                    if (replace != null) {
                        tic.setText(URLDecoder.decode((String)replace, "UTF-8"));
                    }
                    gridPane.add((Node)new Label(message), 0, rowIndex);
                    gridPane.add((Node)tic, 1, rowIndex);
                    replace = "{" + digits.format(userInfo.size()) + "}";
                    userInfo.add(tic);
                }
                if (replace == null) {
                    this.stat.submitDialog.statusWriteln(this.stat.bluej.getLabel(this.stat.bluej.getLabel("message.unknwonparm") + ": " + sub));
                    return false;
                }
                urlString = ((String)urlString).substring(0, start) + (String)replace + ((String)urlString).substring(end + 1);
                ++rowIndex;
            }
        }
        if (!userInfo.isEmpty()) {
            UserPasswordDialog dlg = new UserPasswordDialog(this.stat, this.stat.bluej.getLabel("dialog.parameters.title"), (Node)gridPane);
            Optional result = dlg.showAndWait();
            if (((ButtonType)result.get()).getButtonData() == ButtonBar.ButtonData.OK_DONE) {
                int i = 0;
                for (TextInputControl textInputControl : userInfo) {
                    int loc;
                    while ((loc = ((String)urlString).indexOf("{" + digits.format(i) + "}")) != -1) {
                        String value = URLEncoder.encode(textInputControl.getText(), "UTF-8");
                        urlString = ((String)urlString).substring(0, loc) + value + ((String)urlString).substring(loc + 4);
                    }
                    ++i;
                }
            } else {
                return false;
            }
        }
        try {
            this.url = this.isMessage ? new URL(null, (String)urlString, new MessageHandler(((String)urlString).substring(8))) : new URL((String)urlString);
        }
        catch (MalformedURLException ex) {
            this.stat.submitDialog.statusWriteln(ex.toString());
            return false;
        }
        return true;
    }

    @OnThread(value=Tag.Any)
    URL getURL() {
        return this.url;
    }

    @OnThread(value=Tag.Any)
    public boolean isMessage() {
        return this.isMessage;
    }
}

