/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.system;

import com.pi4j.util.ExecUtil;
import com.pi4j.util.StringUtil;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SystemInfo {
    private static Map<String, String> cpuInfo;

    private SystemInfo() {
    }

    private static String getCpuInfo(String target) throws IOException, InterruptedException {
        if (cpuInfo == null) {
            cpuInfo = new HashMap<String, String>();
            String[] result = ExecUtil.execute("cat /proc/cpuinfo");
            if (result != null) {
                for (String line : result) {
                    String[] parts = line.split(":", 2);
                    if (parts.length < 2 || parts[0].trim().isEmpty() || parts[1].trim().isEmpty()) continue;
                    String cpuKey = parts[0].trim().toLowerCase();
                    cpuInfo.put(cpuKey, parts[1].trim());
                }
            }
        }
        if (cpuInfo.containsKey(target = target.toLowerCase())) {
            return cpuInfo.get(target);
        }
        throw new RuntimeException("Invalid target: " + target);
    }

    public static String getProcessor() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("Processor");
    }

    public static String getBogoMIPS() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("BogoMIPS");
    }

    public static String[] getCpuFeatures() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("Features").split(" ");
    }

    public static String getCpuImplementer() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("CPU implementer");
    }

    public static String getCpuArchitecture() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("CPU architecture");
    }

    public static String getCpuVariant() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("CPU variant");
    }

    public static String getCpuPart() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("CPU part");
    }

    public static String getCpuRevision() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("CPU revision");
    }

    public static String getHardware() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("Hardware");
    }

    public static String getRevision() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("Revision");
    }

    public static String getSerial() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("Serial");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static String getOsArch() {
        return System.getProperty("os.arch");
    }

    public static String getOsFirmwareBuild() throws IOException, InterruptedException {
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd version");
        if (result != null) {
            for (String line : result) {
                if (!line.startsWith("version ")) continue;
                return line.substring(8);
            }
        }
        throw new RuntimeException("Invalid command or response.");
    }

    public static String getOsFirmwareDate() throws IOException, InterruptedException, ParseException {
        String[] arr$;
        int len$;
        int i$;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd version");
        if (result != null && (i$ = 0) < (len$ = (arr$ = result).length)) {
            String line = arr$[i$];
            return line;
        }
        throw new RuntimeException("Invalid command or response.");
    }

    public static String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public static String getJavaVendorUrl() {
        return System.getProperty("java.vendor.url");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getJavaVirtualMachine() {
        return System.getProperty("java.vm.name");
    }

    public static String getJavaRuntime() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.runtime.name");
            }
        });
    }

    public static boolean isHardFloatAbi() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            private final String[] gnueabihf = new String[]{"gnueabihf", "armhf"};

            @Override
            public Boolean run() {
                if (StringUtil.contains(System.getProperty("sun.boot.library.path"), this.gnueabihf) || StringUtil.contains(System.getProperty("java.library.path"), this.gnueabihf) || StringUtil.contains(System.getProperty("java.home"), this.gnueabihf) || SystemInfo.getBashVersionInfo().contains("gnueabihf") || SystemInfo.hasReadElfTag("Tag_ABI_HardFP_use")) {
                    return true;
                }
                return false;
            }
        });
    }

    private static List<Long> getMemory() throws IOException, InterruptedException {
        ArrayList<Long> values = new ArrayList<Long>();
        String[] result = ExecUtil.execute("free -b");
        if (result != null) {
            for (String line : result) {
                String[] parts;
                if (!line.startsWith("Mem:")) continue;
                for (String part : parts = line.split(" ")) {
                    if ((part = part.trim()).isEmpty() || part.equalsIgnoreCase("Mem:")) continue;
                    values.add(new Long(part));
                }
            }
        }
        return values;
    }

    public static long getMemoryTotal() throws IOException, InterruptedException {
        List<Long> values = SystemInfo.getMemory();
        if (!values.isEmpty() && values.size() > 0) {
            return values.get(0);
        }
        return -1L;
    }

    public static long getMemoryUsed() throws IOException, InterruptedException {
        List<Long> values = SystemInfo.getMemory();
        if (!values.isEmpty() && values.size() > 1) {
            return values.get(1);
        }
        return -1L;
    }

    public static long getMemoryFree() throws IOException, InterruptedException {
        List<Long> values = SystemInfo.getMemory();
        if (!values.isEmpty() && values.size() > 2) {
            return values.get(2);
        }
        return -1L;
    }

    public static long getMemoryShared() throws IOException, InterruptedException {
        List<Long> values = SystemInfo.getMemory();
        if (!values.isEmpty() && values.size() > 3) {
            return values.get(3);
        }
        return -1L;
    }

    public static long getMemoryBuffers() throws IOException, InterruptedException {
        List<Long> values = SystemInfo.getMemory();
        if (!values.isEmpty() && values.size() > 4) {
            return values.get(4);
        }
        return -1L;
    }

    public static long getMemoryCached() throws IOException, InterruptedException {
        List<Long> values = SystemInfo.getMemory();
        if (!values.isEmpty() && values.size() > 5) {
            return values.get(5);
        }
        return -1L;
    }

    public static BoardType getBoardType() throws IOException, InterruptedException {
        switch (SystemInfo.getRevision()) {
            case "0002": 
            case "0003": {
                return BoardType.ModelB_Rev1;
            }
            case "0004": 
            case "0005": 
            case "0006": {
                return BoardType.ModelB_Rev2;
            }
            case "0007": 
            case "0008": 
            case "0009": {
                return BoardType.ModelA_Rev0;
            }
            case "000d": 
            case "000e": 
            case "000f": {
                return BoardType.ModelB_Rev2;
            }
        }
        return BoardType.UNKNOWN;
    }

    public static float getCpuTemperature() throws IOException, InterruptedException, NumberFormatException {
        String[] arr$;
        int len$;
        int i$;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd measure_temp");
        if (result != null && (i$ = 0) < (len$ = (arr$ = result).length)) {
            String line = arr$[i$];
            String[] parts = line.split("[=']", 3);
            return Float.parseFloat(parts[1]);
        }
        throw new RuntimeException("Invalid command or response.");
    }

    private static float getVoltage(String id) throws IOException, InterruptedException, NumberFormatException {
        String[] arr$;
        int len$;
        int i$;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd measure_volts " + id);
        if (result != null && (i$ = 0) < (len$ = (arr$ = result).length)) {
            String line = arr$[i$];
            String[] parts = line.split("[=V]", 3);
            return Float.parseFloat(parts[1]);
        }
        throw new RuntimeException("Invalid command or response.");
    }

    public static float getCpuVoltage() throws IOException, InterruptedException, NumberFormatException {
        return SystemInfo.getVoltage("core");
    }

    public static float getMemoryVoltageSDRam_C() throws IOException, InterruptedException, NumberFormatException {
        return SystemInfo.getVoltage("sdram_c");
    }

    public static float getMemoryVoltageSDRam_I() throws IOException, InterruptedException, NumberFormatException {
        return SystemInfo.getVoltage("sdram_i");
    }

    public static float getMemoryVoltageSDRam_P() throws IOException, InterruptedException, NumberFormatException {
        return SystemInfo.getVoltage("sdram_p");
    }

    private static boolean getCodecEnabled(String codec) throws IOException, InterruptedException {
        String[] arr$;
        int len$;
        int i$;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd codec_enabled " + codec);
        if (result != null && (i$ = 0) < (len$ = (arr$ = result).length)) {
            String line = arr$[i$];
            String[] parts = line.split("=", 2);
            return parts[1].trim().equalsIgnoreCase("enabled");
        }
        throw new RuntimeException("Invalid command or response.");
    }

    public static boolean getCodecH264Enabled() throws IOException, InterruptedException {
        return SystemInfo.getCodecEnabled("H264");
    }

    public static boolean getCodecMPG2Enabled() throws IOException, InterruptedException {
        return SystemInfo.getCodecEnabled("MPG2");
    }

    public static boolean getCodecWVC1Enabled() throws IOException, InterruptedException {
        return SystemInfo.getCodecEnabled("WVC1");
    }

    private static long getClockFrequency(String target) throws IOException, InterruptedException {
        String[] arr$;
        int len$;
        int i$;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd measure_clock " + target.trim());
        if (result != null && (i$ = 0) < (len$ = (arr$ = result).length)) {
            String line = arr$[i$];
            String[] parts = line.split("=", 2);
            return Long.parseLong(parts[1].trim());
        }
        throw new RuntimeException("Invalid command or response.");
    }

    public static long getClockFrequencyArm() throws IOException, InterruptedException {
        return SystemInfo.getClockFrequency("arm");
    }

    public static long getClockFrequencyCore() throws IOException, InterruptedException {
        return SystemInfo.getClockFrequency("core");
    }

    public static long getClockFrequencyH264() throws IOException, InterruptedException {
        return SystemInfo.getClockFrequency("h264");
    }

    public static long getClockFrequencyISP() throws IOException, InterruptedException {
        return SystemInfo.getClockFrequency("isp");
    }

    public static long getClockFrequencyV3D() throws IOException, InterruptedException {
        return SystemInfo.getClockFrequency("v3d");
    }

    public static long getClockFrequencyUART() throws IOException, InterruptedException {
        return SystemInfo.getClockFrequency("uart");
    }

    public static long getClockFrequencyPWM() throws IOException, InterruptedException {
        return SystemInfo.getClockFrequency("pwm");
    }

    public static long getClockFrequencyEMMC() throws IOException, InterruptedException {
        return SystemInfo.getClockFrequency("emmc");
    }

    public static long getClockFrequencyPixel() throws IOException, InterruptedException {
        return SystemInfo.getClockFrequency("pixel");
    }

    public static long getClockFrequencyVEC() throws IOException, InterruptedException {
        return SystemInfo.getClockFrequency("vec");
    }

    public static long getClockFrequencyHDMI() throws IOException, InterruptedException {
        return SystemInfo.getClockFrequency("hdmi");
    }

    public static long getClockFrequencyDPI() throws IOException, InterruptedException {
        return SystemInfo.getClockFrequency("dpi");
    }

    private static String getBashVersionInfo() {
        String versionInfo = "";
        try {
            String[] result;
            for (String line : result = ExecUtil.execute("bash --version")) {
                if (line.isEmpty()) continue;
                versionInfo = line;
                break;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return versionInfo;
    }

    private static boolean hasReadElfTag(String tag) {
        String tagValue = SystemInfo.getReadElfTag(tag);
        return tagValue != null && !tagValue.isEmpty();
    }

    private static String getReadElfTag(String tag) {
        String tagValue;
        block5: {
            tagValue = null;
            try {
                String[] result = ExecUtil.execute("/usr/bin/readelf -A /proc/self/exe");
                if (result == null) break block5;
                for (String line : result) {
                    if (!(line = line.trim()).startsWith(tag) || !line.contains(":")) continue;
                    String[] lineParts = line.split(":", 2);
                    if (lineParts.length > 1) {
                        tagValue = lineParts[1].trim();
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        return tagValue;
    }

    public static enum BoardType {
        UNKNOWN,
        ModelA_Rev0,
        ModelB_Rev1,
        ModelB_Rev2;

    }
}

