/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.debugger.gentype.FieldReflective;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.JavaPrimitiveType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.MethodReflective;
import bluej.debugger.gentype.Reflective;
import bluej.utility.JavaUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaReflective
extends Reflective {
    private Class<?> c;

    public int hashCode() {
        return this.c.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof JavaReflective) {
            JavaReflective jrOther = (JavaReflective)other;
            return jrOther.c == this.c;
        }
        return false;
    }

    public JavaReflective(Class<?> c) {
        this.c = c;
    }

    @Override
    public String getName() {
        return this.c.getName();
    }

    @Override
    public String getSimpleName() {
        if (this.c.isArray()) {
            return this.c.getComponentType().getName().replace('$', '.') + "[]";
        }
        return this.c.getName().replace('$', '.');
    }

    @Override
    public boolean isInterface() {
        return this.c.isInterface();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.c.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.c.getModifiers());
    }

    @Override
    public List<GenTypeDeclTpar> getTypeParams() {
        return JavaUtils.getJavaUtils().getTypeParams(this.c);
    }

    @Override
    public Reflective getArrayOf() {
        String rname = this.c.isArray() ? "[" + this.c.getName() : "[L" + this.c.getName() + ";";
        try {
            ClassLoader cloader = this.c.getClassLoader();
            Class<?> arrClass = Class.forName(rname, false, cloader);
            return new JavaReflective(arrClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public Reflective getRelativeClass(String name) {
        try {
            ClassLoader cloader = this.c.getClassLoader();
            if (cloader == null) {
                cloader = ClassLoader.getSystemClassLoader();
            }
            Class<?> cr = cloader.loadClass(name);
            return new JavaReflective(cr);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (LinkageError le) {
            return null;
        }
    }

    @Override
    public List<Reflective> getSuperTypesR() {
        Class<?> superclass;
        ArrayList<Reflective> l = new ArrayList<Reflective>();
        if (this.c.isArray()) {
            Class<?> ct = this.c.getComponentType();
            JavaReflective ctR = new JavaReflective(ct);
            List<Reflective> componentSuperTypes = ctR.getSuperTypesR();
            for (JavaReflective javaReflective : componentSuperTypes) {
                l.add(javaReflective.getArrayOf());
            }
        }
        if ((superclass = this.c.getSuperclass()) != null) {
            l.add(new JavaReflective(superclass));
        }
        Class<?>[] interfaces = this.c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            l.add(new JavaReflective(interfaces[i]));
        }
        if (superclass == null && interfaces.length == 0 && this.c.isInterface()) {
            l.add(new JavaReflective(Object.class));
        }
        return l;
    }

    @Override
    public List<GenTypeClass> getSuperTypes() {
        GenTypeClass[] interfaces;
        ArrayList<GenTypeClass> l = new ArrayList<GenTypeClass>();
        if (this.c.isArray()) {
            Class<?> ct = this.c.getComponentType();
            JavaReflective ctR = new JavaReflective(ct);
            List<GenTypeClass> componentSuperTypes = ctR.getSuperTypes();
            for (GenTypeClass componentSuperType : componentSuperTypes) {
                l.add(componentSuperType.getArray());
            }
        }
        GenTypeClass superclass = null;
        try {
            superclass = JavaUtils.getJavaUtils().getSuperclass(this.c);
            if (superclass != null) {
                l.add(superclass);
            }
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            interfaces = JavaUtils.getJavaUtils().getInterfaces(this.c);
            for (int i = 0; i < interfaces.length; ++i) {
                l.add(interfaces[i]);
            }
        }
        catch (ClassNotFoundException cnfe) {
            interfaces = new GenTypeClass[]{};
        }
        if (superclass == null && interfaces.length == 0 && this.c.isInterface()) {
            l.add(new GenTypeClass(new JavaReflective(Object.class)));
        }
        return l;
    }

    public Class<?> getUnderlyingClass() {
        return this.c;
    }

    @Override
    public boolean isAssignableFrom(Reflective r) {
        if (r instanceof JavaReflective) {
            return this.c.isAssignableFrom(((JavaReflective)r).getUnderlyingClass());
        }
        return false;
    }

    @Override
    public Map<String, FieldReflective> getDeclaredFields() {
        try {
            Field[] fields = this.c.getDeclaredFields();
            HashMap<String, FieldReflective> rmap = new HashMap<String, FieldReflective>();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    JavaType fieldType = JavaUtils.getJavaUtils().getFieldType(fields[i]);
                    FieldReflective fref = new FieldReflective(fields[i].getName(), fieldType, fields[i].getModifiers());
                    rmap.put(fields[i].getName(), fref);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
            if (this.c.isArray()) {
                rmap.put("length", new FieldReflective("length", JavaPrimitiveType.getInt(), 17));
            }
            return rmap;
        }
        catch (LinkageError le) {
            return Collections.emptyMap();
        }
    }

    @Override
    public Map<String, Set<MethodReflective>> getDeclaredMethods() {
        try {
            Method[] methods = this.c.getDeclaredMethods();
            HashMap<String, Set<MethodReflective>> rmap = new HashMap<String, Set<MethodReflective>>();
            for (Method method : methods) {
                JavaType rtype;
                if (method.isSynthetic()) continue;
                try {
                    rtype = JavaUtils.getJavaUtils().getReturnType(method);
                }
                catch (ClassNotFoundException cnfe) {
                    rtype = JavaUtils.getJavaUtils().getRawReturnType(method);
                }
                List<GenTypeDeclTpar> tpars = JavaUtils.getJavaUtils().getTypeParams(method);
                HashMap<String, GenTypeDeclTpar> tparMap = new HashMap<String, GenTypeDeclTpar>();
                this.storeTparMappings(tpars, tparMap);
                if (!Modifier.isStatic(method.getModifiers())) {
                    this.getTparMapping(method.getDeclaringClass(), tparMap);
                }
                try {
                    JavaType[] paramTypes = JavaUtils.getJavaUtils().getParamGenTypes(method, false);
                    ArrayList<JavaType> paramTypesList = new ArrayList<JavaType>(paramTypes.length);
                    for (JavaType paramType : paramTypes) {
                        paramTypesList.add(paramType.mapTparsToTypes(tparMap).getUpperBound());
                    }
                    rtype = rtype.mapTparsToTypes(tparMap).getUpperBound();
                    String name = method.getName();
                    MethodReflective mr = new MethodReflective(name, rtype, tpars, paramTypesList, this, JavaUtils.getJavaUtils().isVarArgs(method), method.getModifiers());
                    HashSet<MethodReflective> rset = (HashSet<MethodReflective>)rmap.get(method.getName());
                    if (rset == null) {
                        rset = new HashSet<MethodReflective>();
                        rmap.put(method.getName(), rset);
                    }
                    rset.add(mr);
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
            if (this.c.isArray()) {
                rmap.put("clone", Collections.singleton(new MethodReflective("clone", new GenTypeClass(new JavaReflective(Object.class)), new ArrayList<GenTypeDeclTpar>(), new ArrayList<JavaType>(), this, false, 1)));
            }
            return rmap;
        }
        catch (LinkageError le) {
            return Collections.emptyMap();
        }
    }

    private void getTparMapping(Class<?> c, Map<String, GenTypeDeclTpar> tparMap) {
        JavaUtils ju = JavaUtils.getJavaUtils();
        List<GenTypeDeclTpar> tpars = ju.getTypeParams(c);
        this.storeTparMappings(tpars, tparMap);
        Method m = c.getEnclosingMethod();
        Constructor<?> cc = c.getEnclosingConstructor();
        c = c.getEnclosingClass();
        while (c != null) {
            if (m != null) {
                tpars = ju.getTypeParams(m);
                this.storeTparMappings(tpars, tparMap);
                if (!Modifier.isStatic(m.getModifiers())) {
                    c = m.getDeclaringClass();
                }
                m = null;
            } else if (cc != null) {
                tpars = ju.getTypeParams(cc);
                this.storeTparMappings(tpars, tparMap);
                c = cc.getDeclaringClass();
                cc = null;
            }
            if (c == null) continue;
            tpars = ju.getTypeParams(c);
            this.storeTparMappings(tpars, tparMap);
            if ((c = c.getEnclosingClass()) == null) continue;
            m = c.getEnclosingMethod();
            cc = c.getEnclosingConstructor();
        }
    }

    private void storeTparMappings(List<GenTypeDeclTpar> tpars, Map<String, ? super GenTypeDeclTpar> map) {
        for (GenTypeDeclTpar tpar : tpars) {
            if (map.containsKey(tpar.getTparName())) continue;
            map.put(tpar.getTparName(), tpar);
        }
    }

    @Override
    public Reflective getOuterClass() {
        Class<?> declaring = this.c.getDeclaringClass();
        if (declaring != null) {
            return new JavaReflective(declaring);
        }
        return null;
    }

    @Override
    public Reflective getInnerClass(String name) {
        try {
            Class<?>[] declared;
            for (Class<?> inner : declared = this.c.getDeclaredClasses()) {
                String baseName;
                String innerName = inner.getName();
                int lastDollar = innerName.lastIndexOf(36);
                if (lastDollar == -1 || !(baseName = innerName.substring(lastDollar + 1)).equals(name)) continue;
                return new JavaReflective(inner);
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return null;
    }
}

