/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.graph.Edge;
import bluej.graph.GraphElement;
import bluej.graph.Moveable;
import bluej.graph.SelectableGraphElement;
import bluej.graph.Vertex;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;

public final class SelectionSet {
    private Set<SelectableGraphElement> elements = new HashSet<SelectableGraphElement>();

    public void add(SelectableGraphElement element) {
        if (!element.isSelected()) {
            element.setSelected(true);
            this.elements.add(element);
        }
    }

    public void addExisting(SelectableGraphElement element) {
        this.elements.add(element);
    }

    public void addAll(SelectionSet newSet) {
        this.elements.addAll(newSet.elements);
    }

    public void remove(SelectableGraphElement element) {
        if (element != null) {
            element.setSelected(false);
            this.elements.remove(element);
        }
    }

    public void clear() {
        for (SelectableGraphElement element : this.elements) {
            element.setSelected(false);
        }
        this.elements.clear();
    }

    public void doubleClick(MouseEvent evt) {
        MouseEvent event = evt;
        for (SelectableGraphElement element : this.elements) {
            element.doubleClick(event);
        }
    }

    public void move(int deltaX, int deltaY) {
        for (GraphElement graphElement : this.elements) {
            Moveable target;
            if (!(graphElement instanceof Moveable) || !(target = (Moveable)((Object)graphElement)).isMoveable()) continue;
            target.setDragging(true);
            Point delta = this.restrictDelta(deltaX, deltaY);
            target.setGhostPosition(delta.x, delta.y);
        }
    }

    private Point restrictDelta(int deltaX, int deltaY) {
        for (GraphElement graphElement : this.elements) {
            if (!(graphElement instanceof Moveable)) continue;
            Moveable target = (Moveable)((Object)graphElement);
            if (target.getX() + deltaX < 0) {
                deltaX = -target.getX();
            }
            if (target.getY() + deltaY >= 0) continue;
            deltaY = -target.getY();
        }
        return new Point(deltaX, deltaY);
    }

    public void moveStopped() {
        for (GraphElement graphElement : this.elements) {
            if (!(graphElement instanceof Moveable)) continue;
            Moveable moveable = (Moveable)((Object)graphElement);
            moveable.setPositionToGhost();
        }
    }

    public void resize(int deltaX, int deltaY) {
        for (GraphElement graphElement : this.elements) {
            Moveable target;
            if (!(graphElement instanceof Moveable) || !(target = (Moveable)((Object)graphElement)).isResizable()) continue;
            target.setDragging(true);
            target.setGhostSize(deltaX, deltaY);
        }
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public void selectOnly(SelectableGraphElement element) {
        this.clear();
        this.add(element);
        element.singleSelected();
    }

    public Vertex getAnyVertex() {
        for (GraphElement graphElement : this.elements) {
            if (!(graphElement instanceof Vertex)) continue;
            return (Vertex)graphElement;
        }
        return null;
    }

    public Edge getAnyEdge() {
        for (GraphElement graphElement : this.elements) {
            if (!(graphElement instanceof Edge)) continue;
            return (Edge)graphElement;
        }
        return null;
    }
}

