/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugmgr.inspector.FieldInfo;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.prefmgr.PrefMgr;
import bluej.testmgr.record.ArrayElementGetRecord;
import bluej.testmgr.record.ArrayElementInspectorRecord;
import bluej.testmgr.record.GetInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.ObjectInspectInvokerRecord;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class ObjectInspector
extends Inspector {
    protected static final String inspectTitle = Config.getString("debugger.inspector.object.title");
    protected static final String noFieldsMsg = Config.getString("debugger.inspector.object.noFields");
    protected static final String numFields = Config.getString("debugger.inspector.numFields");
    protected DebuggerObject obj;
    protected String objName;
    protected boolean queryArrayElementSelected = false;
    private int selectedIndex;
    protected List<Integer> indexToSlotList = null;
    private static final int VISIBLE_ARRAY_START = 40;
    private static final int VISIBLE_ARRAY_TAIL = 5;
    private static final int ARRAY_QUERY_SLOT_VALUE = -2;
    private static final int ARRAY_LENGTH_SLOT_VALUE = -1;

    public ObjectInspector(DebuggerObject obj, InspectorManager inspectorManager, String name, Package pkg, InvokerRecord ir, JFrame parent) {
        super(inspectorManager, pkg, ir, new Color(244, 158, 158));
        this.obj = obj;
        this.objName = name;
        ObjectInspector thisInspector = this;
        this.makeFrame();
        this.update();
        this.updateLayout();
        this.pack();
        if (parent instanceof Inspector) {
            DialogManager.tileWindow(thisInspector, parent);
        } else {
            DialogManager.centreWindow(thisInspector, parent);
        }
        if (Config.isMacOS() || Config.isWinOS()) {
            thisInspector.setWindowOpaque(false);
        }
        if (!Config.isMacOS() || Config.isJava17()) {
            thisInspector.installListenersForMoveDrag();
        }
    }

    protected void makeFrame() {
        this.setUndecorated(true);
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(232, 230, 218));
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        header.setOpaque(false);
        header.setDoubleBuffered(false);
        GenTypeClass objType = this.obj.getGenType();
        String className = objType != null ? objType.toString(true) : "";
        String fullTitle = null;
        if (this.objName != null) {
            fullTitle = this.objName + " : " + className;
            this.setTitle(inspectTitle + " - " + this.objName + ", " + className + " " + numFields + " " + this.getListData().size());
        } else {
            fullTitle = " : " + className;
            this.setTitle(inspectTitle);
        }
        JLabel headerLabel = new JLabel(fullTitle, 0);
        Font font = headerLabel.getFont();
        headerLabel.setFont(font.deriveFont(1));
        headerLabel.setOpaque(false);
        headerLabel.setAlignmentX(0.5f);
        headerLabel.setForeground(Color.white);
        header.add(headerLabel);
        header.add(Box.createVerticalStrut(5));
        JSeparator sep = new JSeparator();
        sep.setForeground(new Color(214, 92, 92));
        if (!Config.isRaspberryPi()) {
            sep.setBackground(new Color(0, 0, 0, 0));
        } else {
            sep.setBackground(new Color(0, 0, 0));
        }
        header.add(sep);
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setOpaque(false);
        mainPanel.setDoubleBuffered(false);
        if (!this.getListData().isEmpty()) {
            JScrollPane scrollPane = this.createFieldListScrollPane();
            mainPanel.add((Component)scrollPane, "Center");
        } else {
            JLabel lab = new JLabel("  " + noFieldsMsg);
            lab.setPreferredSize(new Dimension(200, 30));
            lab.setFont(PrefMgr.getStandardFont().deriveFont(20.0f));
            lab.setForeground(new Color(250, 160, 160));
            mainPanel.add(lab);
        }
        JPanel inspectAndGetButtons = this.createInspectAndGetButtons();
        mainPanel.add((Component)inspectAndGetButtons, "East");
        Insets insets = BlueJTheme.generalBorderWithStatusBar.getBorderInsets(mainPanel);
        mainPanel.setBorder(new EmptyBorder(insets));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setOpaque(false);
        JButton button = this.createCloseButton();
        buttonPanel.add((Component)button, "East");
        JButton classButton = new JButton(showClassLabel);
        classButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectInspector.this.showClass();
            }
        });
        buttonPanel.add((Component)classButton, "West");
        if (!Config.isRaspberryPi()) {
            buttonPanel.setDoubleBuffered(false);
        }
        bottomPanel.add(buttonPanel);
        if (!Config.isRaspberryPi()) {
            bottomPanel.setDoubleBuffered(false);
        }
        JPanel contentPane = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                GraphicsConfiguration gc = g2d.getDeviceConfiguration();
                BufferedImage img = !Config.isRaspberryPi() ? gc.createCompatibleImage(this.getWidth(), this.getHeight(), 3) : gc.createCompatibleImage(this.getWidth(), this.getHeight());
                Graphics2D imgG = img.createGraphics();
                if (!Config.isRaspberryPi()) {
                    imgG.setComposite(AlphaComposite.Clear);
                }
                imgG.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (!Config.isRaspberryPi()) {
                    imgG.setComposite(AlphaComposite.Src);
                }
                if (!Config.isRaspberryPi()) {
                    imgG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                imgG.setColor(Color.WHITE);
                imgG.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 30, 30);
                if (!Config.isRaspberryPi()) {
                    imgG.setComposite(AlphaComposite.SrcAtop);
                    imgG.setPaint(new GradientPaint(this.getWidth() / 2, this.getHeight() / 2, new Color(227, 71, 71), this.getWidth() / 2, this.getHeight(), new Color(205, 39, 39)));
                    imgG.fillRect(0, 0, this.getWidth(), this.getHeight());
                    imgG.setPaint(new GradientPaint(this.getWidth() / 2, 0.0f, new Color(248, 120, 120), this.getWidth() / 2, this.getHeight() / 2, new Color(231, 96, 96)));
                } else {
                    imgG.setPaint(new Color(216, 95, 83));
                    imgG.fillRect(0, 0, this.getWidth(), this.getHeight());
                    imgG.setPaint(new Color(239, 108, 67));
                }
                imgG.fill(new Ellipse2D.Float(-2 * this.getWidth(), -5 * this.getHeight() / 2, 5 * this.getWidth(), 3 * this.getHeight()));
                imgG.setColor(Color.BLACK);
                imgG.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 30, 30);
                imgG.dispose();
                g2d.drawImage((Image)img, 0, 0, this);
                g2d.dispose();
            }
        };
        this.add(contentPane);
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.setOpaque(false);
        contentPane.setDoubleBuffered(false);
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)header, "North");
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)bottomPanel, "South");
        this.getRootPane().setDefaultButton(button);
    }

    @Override
    protected List<FieldInfo> getListData() {
        if (this.obj.isArray()) {
            return this.compressArrayList(this.obj);
        }
        List<DebuggerField> fields = this.obj.getFields();
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>(fields.size());
        for (DebuggerField field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            String desc = Inspector.fieldToString(field);
            String value = field.getValueString();
            fieldInfos.add(new FieldInfo(desc, value));
        }
        return fieldInfos;
    }

    @Override
    protected void listElementSelected(int slot) {
        if (this.obj.isArray()) {
            if ((slot = this.indexToSlot(slot)) >= 0) {
                this.selectedIndex = slot;
            }
            if (slot == -1) {
                this.setCurrentObj(null, null, null);
                this.setButtonsEnabled(false, false);
                return;
            }
            boolean bl = this.queryArrayElementSelected = slot == -2;
            if (this.queryArrayElementSelected) {
                this.setCurrentObj(null, null, null);
                if (!this.obj.getElementType().isPrimitive()) {
                    this.setButtonsEnabled(true, false);
                } else {
                    this.setButtonsEnabled(false, false);
                }
            } else {
                DebuggerObject elementObj;
                if (!this.obj.getElementType().isPrimitive() && !(elementObj = this.obj.getElementObject(slot)).isNullObject()) {
                    this.setCurrentObj(elementObj, "[" + slot + "]", this.obj.getElementType().toString());
                    this.setButtonsEnabled(true, true);
                    return;
                }
                this.setCurrentObj(null, null, null);
                this.setButtonsEnabled(false, false);
            }
            return;
        }
        DebuggerField field = this.obj.getInstanceField(slot);
        if (field.isReferenceType() && !field.isNull()) {
            this.setCurrentObj(field.getValueObject(null), field.getName(), field.getType().toString());
            if (Modifier.isPublic(field.getModifiers())) {
                this.setButtonsEnabled(true, true);
            } else {
                boolean canGet = false;
                if (!Modifier.isPrivate(field.getModifiers())) {
                    String fieldPkg = JavaNames.getPrefix(field.getDeclaringClassName());
                    String pkgName = this.pkg == null ? "" : this.pkg.getQualifiedName();
                    canGet = fieldPkg.equals(pkgName);
                }
                this.setButtonsEnabled(true, canGet);
            }
        } else {
            this.setCurrentObj(null, null, null);
            this.setButtonsEnabled(false, false);
        }
    }

    protected void showClass() {
        this.inspectorManager.getClassInspectorInstance(this.obj.getClassRef(), this.pkg, this);
    }

    @Override
    protected void doInspect() {
        if (this.queryArrayElementSelected) {
            this.selectArrayElement();
        } else if (this.selectedField != null) {
            boolean isPublic = this.getButton.isEnabled();
            if (!this.obj.isArray()) {
                ObjectInspectInvokerRecord newIr = new ObjectInspectInvokerRecord(this.selectedFieldName, this.ir);
                this.inspectorManager.getInspectorInstance(this.selectedField, this.selectedFieldName, this.pkg, isPublic ? newIr : null, this);
            } else {
                ArrayElementInspectorRecord newIr = new ArrayElementInspectorRecord(this.ir, this.selectedIndex);
                this.inspectorManager.getInspectorInstance(this.selectedField, this.selectedFieldName, this.pkg, isPublic ? newIr : null, this);
            }
        }
    }

    @Override
    protected void doGet() {
        if (this.selectedField != null) {
            InvokerRecord getIr = !this.obj.isArray() ? new GetInvokerRecord(this.selectedFieldType, this.selectedFieldName, this.ir) : new ArrayElementGetRecord(this.selectedFieldType, this.selectedIndex, this.ir);
            PackageEditor pkgEd = this.pkg.getEditor();
            pkgEd.recordInteraction(getIr);
            pkgEd.raisePutOnBenchEvent(this, this.selectedField, this.selectedField.getGenType(), getIr);
        }
    }

    @Override
    protected void remove() {
        if (this.inspectorManager != null) {
            this.inspectorManager.removeInspector(this.obj);
        }
    }

    private void selectArrayElement() {
        block7: {
            String response = DialogManager.askString(this, "ask-index");
            if (response != null) {
                try {
                    int slot = Integer.parseInt(response);
                    if (slot >= 0 && slot < this.obj.getElementCount()) {
                        if (!this.obj.getElementType().isPrimitive() && !this.obj.getElementObject(slot).isNullObject()) {
                            boolean isPublic = this.getButton.isEnabled();
                            ArrayElementInspectorRecord newIr = new ArrayElementInspectorRecord(this.ir, slot);
                            this.setCurrentObj(this.obj.getElementObject(slot), "[" + slot + "]", this.obj.getElementType().toString());
                            this.inspectorManager.getInspectorInstance(this.selectedField, this.selectedFieldName, this.pkg, isPublic ? newIr : null, this);
                        } else {
                            this.setButtonsEnabled(false, false);
                            this.update();
                        }
                        break block7;
                    }
                    DialogManager.showError(this, "out-of-bounds");
                }
                catch (NumberFormatException e) {
                    this.setCurrentObj(null, null, null);
                    DialogManager.showError(this, "cannot-access-element");
                }
            } else {
                this.setCurrentObj(null, null, null);
            }
        }
    }

    private List<FieldInfo> compressArrayList(DebuggerObject arrayObject) {
        this.indexToSlotList = new LinkedList<Integer>();
        this.indexToSlotList.add(0, new Integer(-1));
        if (arrayObject.getElementCount() > 47) {
            int i;
            ArrayList<FieldInfo> newArray = new ArrayList<FieldInfo>(47);
            newArray.add(0, new FieldInfo("int length", "" + arrayObject.getElementCount()));
            for (i = 0; i <= 40; ++i) {
                newArray.add(new FieldInfo("[" + i + "]", arrayObject.getElementValueString(i)));
                this.indexToSlotList.add(i);
            }
            newArray.add(new FieldInfo("[...]", ""));
            this.indexToSlotList.add(new Integer(-2));
            for (i = 5; i > 0; --i) {
                int elNum = arrayObject.getElementCount() - i;
                newArray.add(new FieldInfo("[" + elNum + "]", arrayObject.getElementValueString(elNum)));
                this.indexToSlotList.add(arrayObject.getElementCount() - i);
            }
            return newArray;
        }
        ArrayList<FieldInfo> fullArrayFieldList = new ArrayList<FieldInfo>(arrayObject.getElementCount() + 1);
        fullArrayFieldList.add(0, new FieldInfo("int length", "" + arrayObject.getElementCount()));
        for (int i = 0; i < arrayObject.getElementCount(); ++i) {
            fullArrayFieldList.add(new FieldInfo("[" + i + "]", arrayObject.getElementValueString(i)));
            this.indexToSlotList.add(i);
        }
        return fullArrayFieldList;
    }

    private int indexToSlot(int listIndexPosition) {
        Integer slot = this.indexToSlotList.get(listIndexPosition);
        return slot;
    }

    @Override
    protected int getPreferredRows() {
        return 8;
    }
}

