/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import bluej.debugger.Debugger;
import bluej.debugger.DebuggerThread;
import java.util.EventObject;

public class DebuggerEvent
extends EventObject {
    public static final int DEBUGGER_STATECHANGED = 1;
    public static final int THREAD_HALT_UNKNOWN = 2;
    public static final int THREAD_HALT_STEP_OVER = 3;
    public static final int THREAD_HALT_STEP_INTO = 4;
    public static final int THREAD_BREAKPOINT = 5;
    public static final int THREAD_CONTINUE = 6;
    private int id;
    private DebuggerThread thr;
    private int oldState;
    private int newState;
    private BreakpointProperties props;

    public DebuggerEvent(Object source, int id) {
        super(source);
        this.id = id;
    }

    public DebuggerEvent(Debugger source, int id, DebuggerThread thr, BreakpointProperties props) {
        this(source, id);
        this.thr = thr;
        this.props = props;
    }

    public DebuggerEvent(Object source, int id, int oldState, int newState) {
        this(source, id);
        this.oldState = oldState;
        this.newState = newState;
    }

    public int getID() {
        return this.id;
    }

    public boolean isHalt() {
        return this.id == 5 || this.id == 4 || this.id == 3 || this.id == 2;
    }

    public DebuggerThread getThread() {
        return this.thr;
    }

    public int getOldState() {
        return this.oldState;
    }

    public int getNewState() {
        return this.newState;
    }

    public BreakpointProperties getBreakpointProperties() {
        return this.props;
    }

    @Override
    public String toString() {
        return super.toString() + "[id=" + this.id + ",thr=" + this.thr + "]";
    }

    public static interface BreakpointProperties {
        public Object get(Object var1);
    }
}

