/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.properties;

import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.tree.DefaultTreeModel;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.properties.CompilationException;
import org.bluej.extensions.submitter.properties.Tokenizer;
import org.bluej.extensions.submitter.properties.TreeNode;

public class ConfParser {
    private Tokenizer token;
    private DefaultTreeModel treeModel;
    private Stat stat;

    public ConfParser(Stat i_stat, DefaultTreeModel treeModel2) {
        this.stat = i_stat;
        this.treeModel = treeModel2;
    }

    public void parse(TreeNode current, InputStream is) throws CompilationException {
        this.stat.aDbg.debug(4, "Parser.parse: current=" + current.toString());
        this.token = new Tokenizer(new InputStreamReader(is));
        if (this.parseStatements(current) != Tokenizer.END) {
            throw new CompilationException("} without {", this.token);
        }
    }

    private Tokenizer.Type parseStatements(TreeNode current) throws CompilationException {
        Tokenizer.Type type;
        while ((type = this.token.next()) != Tokenizer.END && type != Tokenizer.BLOCK_END) {
            TreeNode newNode;
            if (type == Tokenizer.BLOCK_START) {
                this.stat.aDbg.debug(4, "parseStatements: new Node, title=" + this.token.getTitle());
                newNode = new TreeNode(this.stat, this.token.getTitle());
                if (!this.token.getTitle().startsWith("#")) {
                    this.treeModel.insertNodeInto(newNode, current, 0);
                }
                if ((type = this.parseStatements(newNode)) == Tokenizer.BLOCK_END) continue;
                throw new CompilationException("} expected", this.token);
            }
            if (type == Tokenizer.EMPTY_SCHEME) {
                newNode = new TreeNode(this.stat, this.token.getTitle());
                if (this.token.getTitle().startsWith("#")) continue;
                this.treeModel.insertNodeInto(newNode, current, 0);
                continue;
            }
            if (type == Tokenizer.CONFIG) {
                try {
                    current.addConfig(this.token.getKey(), this.token.getValue());
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    throw new CompilationException(ex.getMessage(), this.token);
                }
            }
            throw new CompilationException("Syntax error", this.token);
        }
        return type;
    }
}

