/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.internal.toolkit.util;

import bluej.doclet.doclets.internal.toolkit.util.ClassTree;
import bluej.doclet.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;

public class ClassUseMapper {
    private final ClassTree classtree;
    public Map classToPackage = new HashMap();
    public Map classToPackageAnnotations = new HashMap();
    public Map classToClass = new HashMap();
    public Map classToSubclass = new HashMap();
    public Map classToSubinterface = new HashMap();
    public Map classToImplementingClass = new HashMap();
    public Map classToField = new HashMap();
    public Map classToMethodReturn = new HashMap();
    public Map classToMethodArgs = new HashMap();
    public Map classToMethodThrows = new HashMap();
    public Map classToConstructorArgs = new HashMap();
    public Map classToConstructorThrows = new HashMap();
    public Map classToConstructorAnnotations = new HashMap();
    public Map classToConstructorParamAnnotation = new HashMap();
    public Map classToConstructorDocArgTypeParam = new HashMap();
    public Map classToClassTypeParam = new HashMap();
    public Map classToClassAnnotations = new HashMap();
    public Map classToExecMemberDocTypeParam = new HashMap();
    public Map classToExecMemberDocArgTypeParam = new HashMap();
    public Map classToExecMemberDocAnnotations = new HashMap();
    public Map classToExecMemberDocReturnTypeParam = new HashMap();
    public Map classToExecMemberDocParamAnnotation = new HashMap();
    public Map classToFieldDocTypeParam = new HashMap();
    public Map annotationToFieldDoc = new HashMap();

    public ClassUseMapper(RootDoc root, ClassTree classtree) {
        this.classtree = classtree;
        Iterator it = classtree.baseclasses().iterator();
        while (it.hasNext()) {
            this.subclasses((ClassDoc)it.next());
        }
        it = classtree.baseinterfaces().iterator();
        while (it.hasNext()) {
            this.implementingClasses((ClassDoc)it.next());
        }
        ClassDoc[] classes = root.classes();
        for (int i = 0; i < classes.length; ++i) {
            PackageDoc pkg = classes[i].containingPackage();
            this.mapAnnotations(this.classToPackageAnnotations, pkg, pkg);
            ClassDoc cd = classes[i];
            this.mapTypeParameters(this.classToClassTypeParam, cd, (ProgramElementDoc)cd);
            this.mapAnnotations(this.classToClassAnnotations, cd, cd);
            FieldDoc[] fields = cd.fields();
            for (int j = 0; j < fields.length; ++j) {
                FieldDoc fd = fields[j];
                this.mapTypeParameters(this.classToFieldDocTypeParam, fd, (ProgramElementDoc)fd);
                this.mapAnnotations(this.annotationToFieldDoc, fd, fd);
                if (fd.type().isPrimitive()) continue;
                this.add(this.classToField, fd.type().asClassDoc(), (ProgramElementDoc)fd);
            }
            ConstructorDoc[] cons = cd.constructors();
            for (int j = 0; j < cons.length; ++j) {
                this.mapAnnotations(this.classToConstructorAnnotations, cons[j], cons[j]);
                this.mapExecutable((ExecutableMemberDoc)cons[j]);
            }
            MethodDoc[] meths = cd.methods();
            for (int j = 0; j < meths.length; ++j) {
                MethodDoc md = meths[j];
                this.mapExecutable((ExecutableMemberDoc)md);
                this.mapTypeParameters(this.classToExecMemberDocTypeParam, md, (ProgramElementDoc)md);
                this.mapAnnotations(this.classToExecMemberDocAnnotations, md, md);
                if (md.returnType().isPrimitive() || md.returnType() instanceof TypeVariable) continue;
                this.mapTypeParameters(this.classToExecMemberDocReturnTypeParam, md.returnType(), (ProgramElementDoc)md);
                this.add(this.classToMethodReturn, md.returnType().asClassDoc(), (ProgramElementDoc)md);
            }
        }
    }

    private Collection subclasses(ClassDoc cd) {
        TreeSet ret = (TreeSet)this.classToSubclass.get(cd.qualifiedName());
        if (ret == null) {
            ret = new TreeSet();
            List subs = this.classtree.subclasses(cd);
            if (subs != null) {
                ret.addAll(subs);
                Iterator it = subs.iterator();
                while (it.hasNext()) {
                    ret.addAll(this.subclasses((ClassDoc)it.next()));
                }
            }
            this.addAll(this.classToSubclass, cd, ret);
        }
        return ret;
    }

    private Collection subinterfaces(ClassDoc cd) {
        TreeSet ret = (TreeSet)this.classToSubinterface.get(cd.qualifiedName());
        if (ret == null) {
            ret = new TreeSet();
            List subs = this.classtree.subinterfaces(cd);
            if (subs != null) {
                ret.addAll(subs);
                Iterator it = subs.iterator();
                while (it.hasNext()) {
                    ret.addAll(this.subinterfaces((ClassDoc)it.next()));
                }
            }
            this.addAll(this.classToSubinterface, cd, ret);
        }
        return ret;
    }

    private Collection implementingClasses(ClassDoc cd) {
        SequencedCollection ret = (List)this.classToImplementingClass.get(cd.qualifiedName());
        if (ret == null) {
            Iterator it;
            ret = new TreeSet();
            List impl = this.classtree.implementingclasses(cd);
            if (impl != null) {
                ret.addAll(impl);
                it = impl.iterator();
                while (it.hasNext()) {
                    ret.addAll(this.subclasses((ClassDoc)it.next()));
                }
            }
            it = this.subinterfaces(cd).iterator();
            while (it.hasNext()) {
                ret.addAll(this.implementingClasses((ClassDoc)it.next()));
            }
            this.addAll(this.classToImplementingClass, cd, ret);
        }
        return ret;
    }

    private void mapExecutable(ExecutableMemberDoc em) {
        Parameter[] params = em.parameters();
        boolean isConstructor = em.isConstructor();
        ArrayList<Type> classArgs = new ArrayList<Type>();
        for (int k = 0; k < params.length; ++k) {
            Type pcd = params[k].type();
            if (!(params[k].type().isPrimitive() || classArgs.contains(pcd) || pcd instanceof TypeVariable)) {
                this.add(isConstructor ? this.classToConstructorArgs : this.classToMethodArgs, pcd.asClassDoc(), (ProgramElementDoc)em);
                classArgs.add(pcd);
                this.mapTypeParameters(isConstructor ? this.classToConstructorDocArgTypeParam : this.classToExecMemberDocArgTypeParam, pcd, (ProgramElementDoc)em);
            }
            this.mapAnnotations(isConstructor ? this.classToConstructorParamAnnotation : this.classToExecMemberDocParamAnnotation, params[k], em);
        }
        ClassDoc[] thr = em.thrownExceptions();
        for (int k = 0; k < thr.length; ++k) {
            this.add(isConstructor ? this.classToConstructorThrows : this.classToMethodThrows, thr[k], (ProgramElementDoc)em);
        }
    }

    private List refList(Map map, ClassDoc cd) {
        ArrayList list = (ArrayList)map.get(cd.qualifiedName());
        if (list == null) {
            list = new ArrayList();
            map.put(cd.qualifiedName(), list);
        }
        return list;
    }

    private Set packageSet(ClassDoc cd) {
        TreeSet pkgSet = (TreeSet)this.classToPackage.get(cd.qualifiedName());
        if (pkgSet == null) {
            pkgSet = new TreeSet();
            this.classToPackage.put(cd.qualifiedName(), pkgSet);
        }
        return pkgSet;
    }

    private Set classSet(ClassDoc cd) {
        TreeSet clsSet = (TreeSet)this.classToClass.get(cd.qualifiedName());
        if (clsSet == null) {
            clsSet = new TreeSet();
            this.classToClass.put(cd.qualifiedName(), clsSet);
        }
        return clsSet;
    }

    private void add(Map map, ClassDoc cd, ProgramElementDoc ref) {
        this.refList(map, cd).add(ref);
        this.packageSet(cd).add(ref.containingPackage());
        this.classSet(cd).add(ref instanceof MemberDoc ? ((MemberDoc)ref).containingClass() : ref);
    }

    private void addAll(Map map, ClassDoc cd, Collection refs) {
        if (refs == null) {
            return;
        }
        this.refList(map, cd).addAll(refs);
        Set pkgSet = this.packageSet(cd);
        Set clsSet = this.classSet(cd);
        for (ProgramElementDoc pedoc : refs) {
            pkgSet.add(pedoc.containingPackage());
            clsSet.add(pedoc instanceof MemberDoc ? ((MemberDoc)pedoc).containingClass() : pedoc);
        }
    }

    private void mapTypeParameters(Map map, Object doc, ProgramElementDoc holder) {
        TypeVariable[] typeVariables;
        if (doc instanceof ClassDoc) {
            typeVariables = ((ClassDoc)doc).typeParameters();
        } else {
            if (doc instanceof WildcardType) {
                Type[] extendsBounds = ((WildcardType)doc).extendsBounds();
                for (int k = 0; k < extendsBounds.length; ++k) {
                    this.addTypeParameterToMap(map, extendsBounds[k], holder);
                }
                Type[] superBounds = ((WildcardType)doc).superBounds();
                for (int k = 0; k < superBounds.length; ++k) {
                    this.addTypeParameterToMap(map, superBounds[k], holder);
                }
                return;
            }
            if (doc instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)doc).typeArguments();
                for (int k = 0; k < typeArguments.length; ++k) {
                    this.addTypeParameterToMap(map, typeArguments[k], holder);
                }
                return;
            }
            if (doc instanceof ExecutableMemberDoc) {
                typeVariables = ((ExecutableMemberDoc)doc).typeParameters();
            } else {
                if (doc instanceof FieldDoc) {
                    Type fieldType = ((FieldDoc)doc).type();
                    this.mapTypeParameters(map, fieldType, holder);
                    return;
                }
                return;
            }
        }
        for (int i = 0; i < typeVariables.length; ++i) {
            Type[] bounds = typeVariables[i].bounds();
            for (int j = 0; j < bounds.length; ++j) {
                this.addTypeParameterToMap(map, bounds[j], holder);
            }
        }
    }

    private void mapAnnotations(Map map, Object doc, Object holder) {
        AnnotationDesc[] annotations;
        boolean isPackage = false;
        if (doc instanceof ProgramElementDoc) {
            annotations = ((ProgramElementDoc)doc).annotations();
        } else if (doc instanceof PackageDoc) {
            annotations = ((PackageDoc)doc).annotations();
            isPackage = true;
        } else if (doc instanceof Parameter) {
            annotations = ((Parameter)doc).annotations();
        } else {
            throw new DocletAbortException();
        }
        for (int i = 0; i < annotations.length; ++i) {
            AnnotationTypeDoc annotationDoc = annotations[i].annotationType();
            if (isPackage) {
                this.refList(map, (ClassDoc)annotationDoc).add(holder);
                continue;
            }
            this.add(map, (ClassDoc)annotationDoc, (ProgramElementDoc)holder);
        }
    }

    private void addTypeParameterToMap(Map map, Type type, ProgramElementDoc holder) {
        if (type instanceof ClassDoc) {
            this.add(map, (ClassDoc)type, holder);
        } else if (type instanceof ParameterizedType) {
            this.add(map, ((ParameterizedType)type).asClassDoc(), holder);
        }
        this.mapTypeParameters(map, type, holder);
    }
}

