/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.device.access;

import com.pi4j.device.DeviceListener;
import com.pi4j.device.ObserveableDeviceBase;
import com.pi4j.device.access.Opener;
import com.pi4j.device.access.OpenerListener;
import com.pi4j.device.access.OpenerLockChangeEvent;
import com.pi4j.device.access.OpenerLockedException;
import com.pi4j.device.access.OpenerState;
import com.pi4j.device.access.OpenerStateChangeEvent;

public abstract class OpenerBase
extends ObserveableDeviceBase
implements Opener {
    @Override
    public abstract void open() throws OpenerLockedException;

    @Override
    public abstract void close() throws OpenerLockedException;

    @Override
    public abstract OpenerState getState();

    @Override
    public abstract boolean isLocked();

    @Override
    public boolean isOpen() {
        return this.getState() == OpenerState.OPEN;
    }

    @Override
    public boolean isOpening() {
        return this.getState() == OpenerState.OPENING;
    }

    @Override
    public boolean isClosed() {
        return this.getState() == OpenerState.CLOSED;
    }

    @Override
    public boolean isClosing() {
        return this.getState() == OpenerState.CLOSING;
    }

    @Override
    public void addListener(OpenerListener ... listener) {
        super.addListener(listener);
    }

    @Override
    public synchronized void removeListener(OpenerListener ... listener) {
        super.removeListener(listener);
    }

    protected synchronized void notifyListeners(OpenerStateChangeEvent event) {
        for (DeviceListener listener : this.listeners) {
            ((OpenerListener)listener).onStateChange(event);
        }
    }

    protected synchronized void notifyListeners(OpenerLockChangeEvent event) {
        for (DeviceListener listener : this.listeners) {
            ((OpenerListener)listener).onLockChange(event);
        }
    }
}

