/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.device;

import com.pi4j.device.DeviceBase;
import com.pi4j.device.DeviceListener;
import com.pi4j.device.ObserveableDevice;
import java.util.ArrayList;
import java.util.List;

public class ObserveableDeviceBase
extends DeviceBase
implements ObserveableDevice {
    protected final List<DeviceListener> listeners = new ArrayList<DeviceListener>();

    protected synchronized void addListener(DeviceListener ... listener) {
        if (listener == null || listener.length == 0) {
            throw new IllegalArgumentException("Missing listener argument.");
        }
        for (DeviceListener lsnr : listener) {
            this.listeners.add(lsnr);
        }
    }

    protected synchronized void removeListener(DeviceListener ... listener) {
        if (listener == null || listener.length == 0) {
            throw new IllegalArgumentException("Missing listener argument.");
        }
        for (DeviceListener lsnr : listener) {
            this.listeners.remove(lsnr);
        }
    }

    @Override
    public synchronized void removeAllListeners() {
        for (int index = this.listeners.size() - 1; index >= 0; --index) {
            DeviceListener listener = this.listeners.get(index);
            this.removeListener(listener);
        }
    }
}

