/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx.dialog;

import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import javafx.animation.RotateTransition;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform, ignoreParent=true)
public class DialogPaneAnimateError
extends DialogPane {
    private final FXPlatformRunnable extraMouseEnter;
    private RotateTransition animation = null;
    private Node errorLabel;
    private SimpleBooleanProperty errorLabelEmpty = new SimpleBooleanProperty(true);
    private Button okButton;

    public DialogPaneAnimateError(Label errorLabel, FXPlatformRunnable extraMouseEnter) {
        this.errorLabel = errorLabel;
        this.errorLabelEmpty.bind((ObservableValue)errorLabel.textProperty().isEmpty());
        this.extraMouseEnter = extraMouseEnter;
    }

    protected Node createButton(ButtonType buttonType) {
        Node normal = super.createButton(buttonType);
        if (buttonType == ButtonType.OK) {
            this.okButton = (Button)normal;
            AnchorPane okWrapper = new AnchorPane(new Node[]{normal});
            AnchorPane.setTopAnchor((Node)this.okButton, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.okButton, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)this.okButton, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.okButton, (Double)0.0);
            ButtonBar.setButtonData((Node)okWrapper, (ButtonBar.ButtonData)buttonType.getButtonData());
            ButtonBar.setButtonUniformSize((Node)okWrapper, (boolean)true);
            okWrapper.setOnMouseEntered(e -> {
                this.extraMouseEnter.run();
                if (this.okButton.isDisable()) {
                    this.animate();
                }
            });
            this.okButton.addEventFilter(ActionEvent.ACTION, event -> JavaFXUtil.runAfterCurrent(() -> {
                if (!this.errorLabelEmpty.get()) {
                    this.animate();
                }
            }));
            return okWrapper;
        }
        return normal;
    }

    private void animate() {
        if (this.animation == null) {
            this.animation = new RotateTransition(Duration.millis((double)70.0), this.errorLabel);
            this.animation.setByAngle(5.0);
            this.animation.setAutoReverse(true);
            this.animation.setCycleCount(4);
            this.animation.setOnFinished(ev -> {
                this.animation = null;
            });
            this.animation.play();
        }
    }

    public Button getOKButton() {
        return this.okButton;
    }
}

