/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.Utility;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.binding.ConcatListBinding;
import bluej.utility.javafx.binding.DeepListBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCombination;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public abstract class AbstractOperation<ITEM extends ContextualItem<ITEM>> {
    protected final KeyCombination shortcut;
    protected final String identifier;
    protected final Combine combine;
    protected boolean enabled = true;
    private @OnThread(value=Tag.FX) boolean wideCustomItem = false;

    private static <ITEM extends ContextualItem<ITEM>> MenuItems asMenuItems(Supplier<List<ITEM>> getSelected, List<? extends AbstractOperation<ITEM>> originalOps, int depth, boolean contextMenu) {
        List ops = originalOps.stream().filter(op -> contextMenu || !op.onlyOnContextMenu()).collect(Collectors.toList());
        ArrayList<SortedMenuItem> r = new ArrayList<SortedMenuItem>();
        Set<ItemLabel> subMenuNames = ops.stream().filter(op -> op.getLabels().size() > depth + 1).map(op -> op.getLabels().get(depth)).collect(Collectors.toSet());
        subMenuNames.forEach(subMenuName -> {
            MenuItems menuItems = AbstractOperation.asMenuItems(getSelected, ops.stream().filter(op -> op.getLabels().get(depth).equals(subMenuName)).collect(Collectors.toList()), depth + 1, contextMenu);
            Menu subMenu = menuItems.makeSubMenu();
            subMenu.textProperty().bind(subMenuName.getLabel());
            r.add(new SortedMenuItem((MenuItem)subMenu, subMenuName.getOrder()));
        });
        final List opsAtRightLevel = ops.stream().filter(op -> op.getLabels().size() == depth + 1).collect(Collectors.toList());
        final IdentityHashMap<AbstractOperation, SortedMenuItem> opsAtRightLevelItems = new IdentityHashMap<AbstractOperation, SortedMenuItem>();
        for (AbstractOperation op2 : opsAtRightLevel) {
            SortedMenuItem item = op2.getMenuItem(contextMenu, getSelected);
            r.add(item);
            opsAtRightLevelItems.put(op2, item);
        }
        return new MenuItems(FXCollections.observableArrayList(r)){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void onShowing() {
                opsAtRightLevel.forEach(op -> {
                    SortedMenuItem sortedMenuItem = (SortedMenuItem)opsAtRightLevelItems.get(op);
                    MenuItem item = sortedMenuItem.getItem();
                    if (item instanceof CustomMenuItem) {
                        op.onMenuShowing((CustomMenuItem)item);
                    }
                });
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void onHidden() {
                opsAtRightLevel.forEach(op -> {
                    SortedMenuItem sortedMenuItem = (SortedMenuItem)opsAtRightLevelItems.get(op);
                    MenuItem item = sortedMenuItem.getItem();
                    if (item instanceof CustomMenuItem) {
                        op.onMenuHidden((CustomMenuItem)item);
                    }
                });
            }
        };
    }

    @OnThread(value=Tag.FXPlatform)
    public static <ITEM extends ContextualItem<ITEM>> MenuItems getMenuItems(List<ITEM> selection, boolean contextMenu) {
        if (selection.size() == 0) {
            return new MenuItems((ObservableList<SortedMenuItem>)FXCollections.observableArrayList());
        }
        if (selection.size() == 1) {
            return AbstractOperation.asMenuItems(() -> selection, ((ContextualItem)selection.get(0)).getContextOperations(), 0, contextMenu);
        }
        HashMap<String, List> ops = new HashMap<String, List>();
        for (ContextualItem f : selection) {
            for (AbstractOperation op : f.getContextOperations()) {
                ops.computeIfAbsent(op.identifier, k -> new ArrayList()).add(op);
            }
        }
        ArrayList<AbstractOperation> r = new ArrayList<AbstractOperation>();
        for (List opEntry : ops.values()) {
            AbstractOperation frameOperation = (AbstractOperation)opEntry.get(0);
            if ((frameOperation.combine() != Combine.ALL || opEntry.size() != selection.size()) && frameOperation.combine() != Combine.ANY && (frameOperation.combine() != Combine.ONE || selection.size() != 1)) continue;
            r.add(frameOperation);
        }
        return AbstractOperation.asMenuItems(() -> selection, r, 0, contextMenu);
    }

    public SortedMenuItem getMenuItem(boolean contextMenu, Supplier<List<ITEM>> getSelection) {
        MenuItem item;
        if (contextMenu) {
            CustomMenuItem customItem = this.initializeCustomItem();
            customItem.getContent().setOnMouseEntered(e -> this.enablePreview());
            customItem.getContent().setOnMouseExited(e -> this.disablePreview());
            item = customItem;
        } else {
            item = this.initializeNormalItem();
        }
        item.setOnAction(e -> {
            this.activate((List)getSelection.get());
            e.consume();
        });
        if (this.shortcut != null) {
            item.setAccelerator(this.shortcut);
        }
        return new SortedMenuItem(item, this.getLabels().get(0).getOrder());
    }

    @OnThread(value=Tag.FXPlatform)
    public void onMenuShowing(CustomMenuItem item) {
    }

    @OnThread(value=Tag.FXPlatform)
    public void onMenuHidden(CustomMenuItem item) {
    }

    public abstract void activate(List<ITEM> var1);

    @OnThread(value=Tag.FXPlatform)
    protected void enablePreview() {
    }

    @OnThread(value=Tag.FXPlatform)
    protected void disablePreview() {
    }

    public boolean onlyOnContextMenu() {
        return false;
    }

    public AbstractOperation(String identifier, Combine combine, KeyCombination shortcut) {
        this.identifier = identifier;
        this.combine = combine;
        this.shortcut = shortcut;
    }

    public Combine combine() {
        return this.combine;
    }

    public abstract List<ItemLabel> getLabels();

    @OnThread(value=Tag.FX)
    protected ItemLabel l(String s, MenuItemOrder order) {
        return new ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(s){

            public boolean equals(Object obj) {
                if (!(obj instanceof ObservableValue)) {
                    return false;
                }
                return this.getValue().equals(((ObservableValue)obj).getValue());
            }

            public int hashCode() {
                return this.getValue().hashCode();
            }
        }, order);
    }

    protected CustomMenuItem initializeCustomItem() {
        Label d = new Label();
        d.textProperty().bind(this.getLabels().get((int)(this.getLabels().size() - 1)).label);
        if (!this.wideCustomItem) {
            d.setPrefWidth(150.0);
        } else {
            d.setPrefWidth(300.0);
        }
        CustomMenuItem item = new CustomMenuItem((Node)d);
        item.textProperty().bind((ObservableValue)d.textProperty());
        item.getStyleClass().addAll(this.getStyleClasses());
        item.setDisable(!this.isEnabled());
        return item;
    }

    @OnThread(value=Tag.FX)
    public void setWideCustomItem(boolean wide) {
        this.wideCustomItem = wide;
    }

    protected MenuItem initializeNormalItem() {
        MenuItem item = new MenuItem();
        item.textProperty().bind(this.getLabels().get((int)(this.getLabels().size() - 1)).label);
        item.getStyleClass().addAll(this.getStyleClasses());
        item.setDisable(!this.isEnabled());
        return item;
    }

    protected final boolean isEnabled() {
        return this.enabled;
    }

    public KeyCombination getShortcut() {
        return this.shortcut;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<String> getStyleClasses() {
        return List.of();
    }

    public static class MenuItems {
        protected final ObservableList<SortedMenuItem> items;

        public MenuItems(ObservableList<SortedMenuItem> items) {
            this.items = items;
        }

        @OnThread(value=Tag.FXPlatform)
        public void onShowing() {
        }

        @OnThread(value=Tag.FXPlatform)
        public void onHidden() {
        }

        public static MenuItems concat(MenuItems ... src) {
            final List nonNull = Arrays.stream(src).filter(m -> m != null).collect(Collectors.toList());
            ObservableList joinedItems = FXCollections.observableArrayList();
            ConcatListBinding.bind(joinedItems, FXCollections.observableArrayList((Collection)nonNull.stream().map(m -> m.items).collect(Collectors.toList())));
            return new MenuItems(joinedItems){

                @Override
                public void onShowing() {
                    nonNull.forEach(MenuItems::onShowing);
                }

                @Override
                public void onHidden() {
                    nonNull.forEach(MenuItems::onHidden);
                }
            };
        }

        public Menu makeSubMenu() {
            Menu menu = new Menu();
            JavaFXUtil.bindMap(menu.getItems(), this.items, SortedMenuItem::getItem, FXRunnable::run);
            menu.onShowingProperty().set(e -> this.onShowing());
            menu.onHiddenProperty().set(e -> this.onHidden());
            return menu;
        }

        public static <T extends Comparable<T>> ContextMenu makeContextMenu(Map<T, MenuItems> allItems) {
            return MenuItems.makeContextMenu(allItems.entrySet().stream().sorted((a, b) -> ((Comparable)a.getKey()).compareTo((Comparable)b.getKey())).map(e -> (MenuItems)e.getValue()).collect(Collectors.toList()));
        }

        private static ContextMenu makeContextMenu(List<MenuItems> allItems) {
            ContextMenu menu = new ContextMenu();
            ObservableList sorted = FXCollections.observableArrayList();
            ConcatListBinding.bind(sorted, FXCollections.observableArrayList(Utility.mapList(allItems, MenuItems::getItems)));
            JavaFXUtil.bindList(menu.getItems(), SortedMenuItem.sortAndAddDividers((ObservableList<SortedMenuItem>)sorted, Collections.emptyList()));
            menu.onShowingProperty().set(e -> allItems.forEach(MenuItems::onShowing));
            menu.onHiddenProperty().set(e -> allItems.forEach(MenuItems::onHidden));
            return menu;
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        public ObservableList<SortedMenuItem> getItems() {
            return this.items;
        }
    }

    public static class SortedMenuItem {
        private final MenuItem item;
        private MenuItemOrder sortOrder;

        public SortedMenuItem(MenuItem item, MenuItemOrder sortOrder) {
            this.item = item;
            this.sortOrder = sortOrder;
        }

        public MenuItem getItem() {
            return this.item;
        }

        public MenuItemOrder getMenuItemOrder() {
            return this.sortOrder;
        }

        public static ObservableList<MenuItem> sortAndAddDividers(final ObservableList<SortedMenuItem> primaryItems, final List<SortedMenuItem> defaultItems) {
            ObservableList r = FXCollections.observableArrayList();
            new DeepListBinding<MenuItem>(r){

                @Override
                protected Stream<MenuItem> calculateValues() {
                    return SortedMenuItem.calculateList((ObservableList<SortedMenuItem>)primaryItems, defaultItems);
                }

                @Override
                protected Stream<ObservableList<?>> getListenTargets() {
                    return Stream.of(primaryItems);
                }
            }.startListening();
            return r;
        }

        private static Stream<MenuItem> calculateList(ObservableList<SortedMenuItem> primaryItems, List<SortedMenuItem> defaultItems) {
            ArrayList<SortedMenuItem> all = new ArrayList<SortedMenuItem>((Collection<SortedMenuItem>)primaryItems);
            for (SortedMenuItem def : defaultItems) {
                if (all.stream().anyMatch(item -> item.getMenuItemOrder() == def.getMenuItemOrder())) continue;
                all.add(def);
            }
            all.sort(Comparator.comparing(a -> a.sortOrder));
            for (int i = 0; i < all.size() - 1; ++i) {
                if (((SortedMenuItem)all.get(i)).getMenuItemOrder().getBlock() == ((SortedMenuItem)all.get(i + 1)).getMenuItemOrder().getBlock()) continue;
                all.add(i + 1, new SortedMenuItem((MenuItem)new SeparatorMenuItem(), null));
                ++i;
            }
            return all.stream().map(SortedMenuItem::getItem);
        }
    }

    public static class ItemLabel {
        private ObservableValue<String> label;
        private MenuItemOrder order;

        public ItemLabel(ObservableValue<String> label, MenuItemOrder order) {
            this.label = label;
            this.order = order;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemLabel) {
                return ((String)this.label.getValue()).equals(((ItemLabel)obj).label.getValue());
            }
            return false;
        }

        public int hashCode() {
            return ((String)this.label.getValue()).hashCode();
        }

        public ObservableValue<String> getLabel() {
            return this.label;
        }

        public MenuItemOrder getOrder() {
            return this.order;
        }
    }

    public static enum MenuItemOrder {
        CLOSE(0),
        UNDO(10),
        REDO(10),
        RECENT_VALUES(20),
        CUT(30),
        COPY(30),
        PASTE(30),
        DELETE(40),
        ENABLE_FRAME(40),
        DISABLE_FRAME(40),
        INSERT_FRAME(60),
        TRANSFORM(70),
        TOGGLE_BOOLEAN(70),
        TOGGLE_ABSTRACT(70),
        TOGGLE_EXTENDS(70),
        TOGGLE_IMPLEMENTS(70),
        OVERRIDE(70),
        GOTO_DEFINITION(80),
        GOTO_OVERRIDE(80),
        SHOW_HIDE_USES(80),
        TEST_ALL(100),
        RUN_FX(100),
        RUN_CONSTRUCTOR(103),
        RUN_METHOD(105),
        EDIT(110),
        COMPILE(110),
        INSPECT(110),
        REMOVE(110),
        SET_IMAGE(110),
        DUPLICATE(110),
        CONVERT_TO_STRIDE(110),
        CONVERT_TO_JAVA(110),
        MAKE_TEST_CASE(130),
        BENCH_TO_FIXTURE(130),
        FIXTURE_TO_BENCH(130),
        NEW_SUBCLASS(140),
        CREATE_TEST(140);

        private final int block;

        private MenuItemOrder(int block) {
            this.block = block;
        }

        public SortedMenuItem item(MenuItem fxItem) {
            return new SortedMenuItem(fxItem, this);
        }

        public int getBlock() {
            return this.block;
        }
    }

    public static enum Combine {
        ANY,
        ALL,
        ONE;

    }

    @OnThread(value=Tag.FXPlatform)
    public static interface ContextualItem<ITEM extends ContextualItem<ITEM>> {
        public List<? extends AbstractOperation<ITEM>> getContextOperations();
    }
}

