/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.Config;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.FrameOperation;
import bluej.utility.javafx.AbstractOperation;
import java.util.Arrays;
import java.util.List;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCombination;
import threadchecker.OnThread;
import threadchecker.Tag;

public class DisableFrameOperation
extends FrameOperation {
    public DisableFrameOperation(InteractionManager editor) {
        super(editor, "DISABLE", AbstractOperation.Combine.ANY, (KeyCombination)new KeyCharacterCombination("\\", new KeyCombination.Modifier[0]));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void enablePreview() {
        this.editor.getSelection().getSelected().forEach(frame -> frame.setFrameEnablePreview(Frame.FramePreviewEnabled.PREVIEW_DISABLED));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void disablePreview() {
        this.editor.getSelection().getSelected().forEach(frame -> frame.setFrameEnablePreview(Frame.FramePreviewEnabled.PREVIEW_NONE));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    protected void execute(List<Frame> frames) {
        frames.forEach(frame -> frame.setFrameEnabled(false));
    }

    @Override
    public List<AbstractOperation.ItemLabel> getLabels() {
        return Arrays.asList(this.l(Config.getString("frame.operation.disable"), AbstractOperation.MenuItemOrder.DISABLE_FRAME));
    }

    @Override
    public boolean onlyOnContextMenu() {
        return true;
    }
}

