/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.Config;
import bluej.collect.StrideEditReason;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.FrameOperation;
import bluej.utility.javafx.AbstractOperation;
import java.util.Arrays;
import java.util.List;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import threadchecker.OnThread;
import threadchecker.Tag;

public class DeleteFrameOperation
extends FrameOperation {
    public DeleteFrameOperation(InteractionManager editor) {
        super(editor, "DELETE", AbstractOperation.Combine.ALL, (KeyCombination)new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0]));
    }

    @Override
    public List<AbstractOperation.ItemLabel> getLabels() {
        return Arrays.asList(this.l(Config.getString("frame.operation.delete"), AbstractOperation.MenuItemOrder.DELETE));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void enablePreview() {
        this.editor.getSelection().setDeletePreview(true);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void disablePreview() {
        this.editor.getSelection().setDeletePreview(false);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    protected void execute(List<Frame> frames) {
        this.editor.recordEdits(StrideEditReason.FLUSH);
        int effort = frames.stream().mapToInt(Frame::calculateEffort).sum();
        this.editor.showUndoDeleteBanner(effort);
        DeleteFrameOperation.deleteFrames(frames, this.editor);
        this.editor.recordEdits(StrideEditReason.DELETE_FRAMES_MENU);
    }

    @OnThread(value=Tag.FXPlatform)
    public static void deleteFrames(List<Frame> frames, InteractionManager editor) {
        if (!frames.isEmpty()) {
            FrameCursor focusAfter = frames.get(0).getCursorBefore();
            frames.forEach(frame -> frame.getParentCanvas().removeBlock((Frame)frame));
            editor.getSelection().clear();
            focusAfter.requestFocus();
        } else {
            editor.getSelection().clear();
        }
    }

    @Override
    public boolean onlyOnContextMenu() {
        return true;
    }
}

