/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.stride.framedjava.slots.BracketedStructured;
import bluej.stride.framedjava.slots.CaretPos;
import bluej.stride.framedjava.slots.Operator;
import bluej.stride.framedjava.slots.PosAndDist;
import bluej.stride.framedjava.slots.ProtectedList;
import bluej.stride.framedjava.slots.StringLiteralExpression;
import bluej.stride.framedjava.slots.StructuredSlot;
import bluej.stride.framedjava.slots.StructuredSlotComponent;
import bluej.stride.framedjava.slots.StructuredSlotField;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.HeaderItem;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXFunction;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformFunction;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import bluej.utility.javafx.TextFieldDelegate;
import bluej.utility.javafx.binding.DeepListBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class InfixStructured<SLOT extends StructuredSlot<?, INFIX, ?>, INFIX extends InfixStructured<SLOT, INFIX>>
implements TextFieldDelegate<StructuredSlotField> {
    private static final String DIGITS_REGEX = "\\d([0-9_]*\\d)?";
    private static final String HEX_DIGITS_REGEX = "[0-9A-Fa-f]([0-9A-Fa-f_]*[0-9A-Fa-f])?";
    private static final String DEFAULT_RANGE_START = lang.stride.Utility.class.getName() + "(";
    protected final ProtectedList<StructuredSlotComponent> fields = new ProtectedList();
    protected final ProtectedList<Operator> operators = new ProtectedList();
    private final ObservableList<Node> components = FXCollections.observableArrayList();
    protected final BracketedStructured<INFIX, SLOT> parent;
    private final Set<Character> closingChars = new HashSet<Character>();
    private final InteractionManager editor;
    protected final SLOT slot;
    private final StringProperty textProperty = new SimpleStringProperty();
    private final BooleanProperty previewingJavaRange = new SimpleBooleanProperty(false);
    private final StringProperty startRangeText = new SimpleStringProperty(DEFAULT_RANGE_START);
    private final StringProperty endRangeText = new SimpleStringProperty(")");
    private CaretPos anchorPos;

    public InfixStructured(InteractionManager editor, SLOT slot, StructuredSlot.ModificationToken token) {
        this(editor, slot, "", null, token, new Character[0]);
    }

    public InfixStructured(InteractionManager editor, SLOT slot, String initialContent, BracketedStructured wrapper, StructuredSlot.ModificationToken token, Character ... closingChars) {
        this.editor = editor;
        this.parent = wrapper;
        this.closingChars.addAll(Arrays.asList(closingChars));
        this.slot = slot;
        this.textProperty.set((Object)initialContent);
        this.fields.add(this.makeNewField(initialContent, false), token);
        final ObservableList extraPrefix = FXCollections.observableArrayList();
        final ObservableList extraSuffix = FXCollections.observableArrayList();
        JavaFXUtil.addChangeListener(this.previewingJavaRange, previewing -> {
            if (previewing.booleanValue()) {
                Label start = new Label();
                start.textProperty().bind((ObservableValue)this.startRangeText);
                extraPrefix.setAll((Object[])new Node[]{start});
                Label end = new Label();
                end.textProperty().bind((ObservableValue)this.endRangeText);
                extraSuffix.setAll((Object[])new Node[]{end});
            } else {
                extraPrefix.clear();
                extraSuffix.clear();
            }
        });
        new DeepListBinding<Node>(this.components){

            @Override
            protected Stream<ObservableList<?>> getListenTargets() {
                return Stream.concat(Stream.of(InfixStructured.this.fields.observable(), InfixStructured.this.operators.observable(), extraPrefix, extraSuffix), InfixStructured.this.fields.stream().map(StructuredSlotComponent::getComponents));
            }

            @Override
            protected Stream<Node> calculateValues() {
                return Utility.concat(extraPrefix.stream(), Utility.interleave(InfixStructured.this.fields.stream().map(c -> c.getComponents().stream()), InfixStructured.this.operators.stream().map(o -> o == null ? Stream.empty() : Stream.of(o.getNode()))).flatMap(x -> x), extraSuffix.stream());
            }
        }.startListening();
        this.fields.observable().addListener(c -> {
            if (this.fields.size() != 1) {
                this.fields.forEach(comp -> {
                    if (comp instanceof StructuredSlotField) {
                        ((StructuredSlotField)comp).setPromptText("");
                    }
                });
            }
        });
        this.components.addListener(c -> InfixStructured.calculatePrecedences(this.operators.stream().collect(Collectors.toList()), this.fields.stream().map(StructuredSlotComponent::isFieldAndEmpty).limit(this.operators.size()).collect(Collectors.toList())));
        this.updateBreaks();
        JavaFXUtil.addChangeListener(this.textProperty, value -> this.updateBreaks());
    }

    public Stream<? extends Node> makeDisplayClone(InteractionManager editor) {
        return Utility.interleave(this.fields.stream().map(c -> c.makeDisplayClone(editor)), this.operators.stream().map(o -> o == null ? Stream.empty() : Stream.of(o.makeDisplayClone(editor)))).flatMap(x -> x);
    }

    private void updateBreaks() {
        for (int i = 1; i < this.fields.size(); ++i) {
            if (!(this.fields.get(i) instanceof BracketedStructured)) continue;
            ((BracketedStructured)this.fields.get(i)).notifyIsMethodParams(this.fields.get(i - 1) instanceof StructuredSlotField && !this.fields.get(i - 1).isFieldAndEmpty());
        }
    }

    static OpPrec calculatePrecedences(List<Operator> ops, List<Boolean> isUnary) {
        int lowestPrec = Integer.MAX_VALUE;
        int lowestIndex = -1;
        for (int i = 0; i < ops.size(); ++i) {
            if (ops.get(i) == null) continue;
            if (ops.get(i).get().equals(".")) {
                ops.get(i).setPrecedence(Operator.Precedence.DOT);
                continue;
            }
            if (ops.get(i).get().equals(",")) {
                ops.get(i).setPrecedence(Operator.Precedence.COMMA);
                continue;
            }
            if (ops.get(i).get().equals("new ")) {
                ops.get(i).setPrecedence(Operator.Precedence.NEW);
                continue;
            }
            int prec = Operator.getOperatorPrecedence(ops.get(i).get(), isUnary.get(i));
            if (prec >= lowestPrec) continue;
            lowestPrec = prec;
            lowestIndex = i;
        }
        if (lowestIndex != -1) {
            List<Operator> lhs = ops.subList(0, lowestIndex);
            List<Boolean> lhsUnary = isUnary.subList(0, lowestIndex);
            List<Operator> rhs = ops.subList(lowestIndex + 1, ops.size());
            List<Boolean> rhsUnary = isUnary.subList(lowestIndex + 1, ops.size());
            OpPrec lhsPrec = InfixStructured.calculatePrecedences(lhs, lhsUnary);
            OpPrec rhsPrec = InfixStructured.calculatePrecedences(rhs, rhsUnary);
            int ourLevel = lhsPrec.prec == lowestPrec || rhsPrec.prec == lowestPrec || lhsPrec.prec == -1 && rhsPrec.prec == -1 ? Math.max(lhsPrec.levels, rhsPrec.levels) : 1 + Math.max(lhsPrec.levels, rhsPrec.levels);
            ops.get(lowestIndex).setPrecedence(Operator.getPrecForLevel(ourLevel));
            return new OpPrec(lowestPrec, ourLevel);
        }
        return new OpPrec(-1, 0);
    }

    private static boolean precedesDotInFloatingPointLiteral(String before) {
        return before.matches("\\A\\s*[+-]?\\d([0-9_]*\\d)?\\z") || before.matches("\\A\\s*0x[0-9A-Fa-f]([0-9A-Fa-f_]*[0-9A-Fa-f])?\\z");
    }

    protected StructuredSlotField makeNewField(String content, boolean stringLiteral) {
        StructuredSlotField f = new StructuredSlotField(this, content, stringLiteral);
        if (this.editor != null) {
            this.editor.setupFocusableSlotComponent((EditableSlot)this.slot, (Node)f.getNodeForPos(null), true, () -> ((StructuredSlot)this.slot).getExtensions(), ((StructuredSlot)this.slot).getHints());
        }
        f.onKeyPressedProperty().set(event -> {
            if (event.isShiftDown() && event.isControlDown() && event.getText().length() > 0 && event.getCode() != KeyCode.CONTROL && event.getCode() != KeyCode.SHIFT) {
                ((StructuredSlot)this.slot).notifyModifiedPress(event.getCode());
                event.consume();
                return;
            }
            switch (event.getCode()) {
                case ENTER: {
                    ((StructuredSlot)this.slot).enter();
                    event.consume();
                    break;
                }
                case UP: {
                    ((StructuredSlot)this.slot).up();
                    event.consume();
                    break;
                }
                case DOWN: {
                    ((StructuredSlot)this.slot).down();
                    event.consume();
                    break;
                }
                case SPACE: {
                    if (!event.isControlDown()) break;
                    ((StructuredSlot)this.slot).showSuggestionDisplay(f, f.getCurrentPos().index, stringLiteral);
                    event.consume();
                    break;
                }
                default: {
                    if (!((StructuredSlot)this.slot).checkFilePreviewShortcut(event.getCode())) break;
                    event.consume();
                }
            }
        });
        f.addEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_MOVED, (EventHandler<? super MouseEvent>)((EventHandler)e -> {
            CaretPos relNearest = this.getNearest(e.getSceneX(), e.getSceneY(), false, OptionalInt.empty()).getPos();
            CaretPos absNearest = this.absolutePos(relNearest);
            f.setPseudoclass("bj-hyperlink", e.isShortcutDown() && ((StructuredSlot)this.slot).getOverlay().hoverAtPos(((StructuredSlot)this.slot).getTopLevel().caretPosToStringPos(absNearest, false)) != null);
        }));
        f.addEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED, (EventHandler<? super MouseEvent>)((EventHandler)e -> {
            if (e.getClickCount() > 1) {
                return;
            }
            if (!e.isShortcutDown() && e.getButton() != MouseButton.MIDDLE) {
                return;
            }
            CaretPos relNearest = this.getNearest(e.getSceneX(), e.getSceneY(), false, OptionalInt.empty()).getPos();
            CaretPos absNearest = this.absolutePos(relNearest);
            FXPlatformRunnable linkRunnable = ((StructuredSlot)this.slot).getOverlay().hoverAtPos(((StructuredSlot)this.slot).getTopLevel().caretPosToStringPos(absNearest, false));
            if (linkRunnable != null) {
                linkRunnable.run();
            } else {
                ((StructuredSlot)this.slot).withLinksAtPos(absNearest, optLink -> optLink.ifPresent(link -> {
                    FXPlatformRunnable onClick = link.getOnClick();
                    if (onClick != null) {
                        onClick.run();
                    }
                }));
            }
        }));
        return f;
    }

    Node positionCaret(CaretPos pos) {
        if (pos == null) {
            return null;
        }
        pos = pos.normalise();
        if (pos.index == -1) {
            return this.parent.positionParentPos(pos.subPos);
        }
        StructuredSlotComponent foc = this.fields.get(pos.index);
        return foc.focusAtPos(pos.subPos);
    }

    public void drawSelection(CaretPos cur) {
        if (this.anchorPos == null || this.anchorPos.equals(cur)) {
            ((StructuredSlot)this.slot).clearSelection(false);
        } else {
            CaretPos end;
            CaretPos start;
            if (this.anchorPos.before(cur)) {
                start = this.anchorPos;
                end = cur;
            } else {
                start = cur;
                end = this.anchorPos;
            }
            ((StructuredSlot)this.slot).drawSelection(this.getAllStartEndPositionsBetween(start, end).collect(Collectors.toList()));
        }
    }

    Stream<TextOverlayPosition> getAllStartEndPositionsBetween(CaretPos start, CaretPos end) {
        int endIndex;
        int startIndex;
        boolean useVeryEnd;
        if (start == null) {
            start = new CaretPos(0, this.getFirstField().getStartPos());
        }
        boolean bl = useVeryEnd = end == null;
        if (end == null) {
            end = new CaretPos(this.fields.size() - 1, this.getLastField().getEndPos());
        }
        if ((startIndex = start.index) == (endIndex = end.index)) {
            Stream<TextOverlayPosition> s = this.fields.get(startIndex).getAllStartEndPositionsBetween(start.subPos, end.subPos);
            if (useVeryEnd) {
                s = Stream.concat(s, Stream.of(((StructuredSlotField)this.fields.get(this.fields.size() - 1)).calculateOverlayEnd()));
            }
            return s;
        }
        Stream<TextOverlayPosition> s = this.fields.get(startIndex).getAllStartEndPositionsBetween(start.subPos, null);
        for (int i = startIndex + 1; i < endIndex; ++i) {
            if (this.operators.get(i - 1) != null) {
                s = Stream.concat(s, this.operators.get(i - 1).getStartEndPositions(this));
            }
            s = Stream.concat(s, this.fields.get(i).getAllStartEndPositionsBetween(null, null));
        }
        if (this.operators.get(endIndex - 1) != null) {
            s = Stream.concat(s, this.operators.get(endIndex - 1).getStartEndPositions(this));
        }
        s = Stream.concat(s, this.fields.get(endIndex).getAllStartEndPositionsBetween(null, end.subPos));
        if (useVeryEnd) {
            s = Stream.concat(s, Stream.of(((StructuredSlotField)this.fields.get(this.fields.size() - 1)).calculateOverlayEnd()));
        }
        return s;
    }

    public TextOverlayPosition calculateOverlayPos(CaretPos p) {
        StructuredSlotComponent f = this.fields.get(p.index);
        return f.calculateOverlayPos(p.subPos);
    }

    public double sceneToOverlayX(double sceneX) {
        return ((StructuredSlot)this.slot).sceneToOverlayX(sceneX);
    }

    public double sceneToOverlayY(double sceneY) {
        return ((StructuredSlot)this.slot).sceneToOverlayY(sceneY);
    }

    @Override
    public void deselect() {
        this.anchorPos = null;
        this.drawSelection(null);
    }

    @Override
    public void backwardAtStart(StructuredSlotField f) {
        this.backwardAtStart((StructuredSlotComponent)f);
    }

    @Override
    public void backwardAtStart(StructuredSlotComponent f) {
        int i = this.findField(f);
        if (i == -1) {
            throw new IllegalStateException();
        }
        if (i > 0) {
            this.fields.get(i - 1).focusAtEnd();
        } else if (this.parent != null) {
            this.parent.focusBefore();
        } else {
            ((StructuredSlot)this.slot).getSlotParent().focusLeft((HeaderItem)this.slot);
        }
    }

    @Override
    public void forwardAtEnd(StructuredSlotField f) {
        this.forwardAtEnd((StructuredSlotComponent)f);
    }

    @Override
    public void forwardAtEnd(StructuredSlotComponent f) {
        int i = this.findField(f);
        if (i == -1) {
            throw new IllegalStateException();
        }
        if (i < this.fields.size() - 1) {
            this.fields.get(i + 1).focusAtStart();
        } else if (this.parent != null) {
            this.parent.focusAfter();
        } else {
            ((StructuredSlot)this.slot).getSlotParent().focusRight((HeaderItem)this.slot);
        }
    }

    @Override
    public boolean home(StructuredSlotField f) {
        this.getFirstField().focusAtStart();
        return true;
    }

    @Override
    public boolean end(StructuredSlotField f, boolean asPartOfNextWordCommand) {
        if (asPartOfNextWordCommand) {
            f.focusAtEnd();
        } else {
            this.end();
        }
        return true;
    }

    @Override
    public boolean selectHome(StructuredSlotField id, int caretPos) {
        int i = this.findField(id);
        this.setAnchorIfUnset(new CaretPos(i, new CaretPos(caretPos, null)));
        int dest = this.fields.get(i) instanceof StringLiteralExpression ? i : 0;
        this.fields.get(dest).focusAtStart();
        this.drawSelection(new CaretPos(dest, new CaretPos(0, null)));
        return true;
    }

    @Override
    public boolean selectEnd(StructuredSlotField id, int caretPos) {
        int i = this.findField(id);
        this.setAnchorIfUnset(new CaretPos(i, new CaretPos(caretPos, null)));
        int dest = this.fields.get(i) instanceof StringLiteralExpression ? i : this.fields.size() - 1;
        this.fields.get(dest).focusAtEnd();
        this.drawSelection(new CaretPos(dest, this.fields.get(dest).getEndPos()));
        return true;
    }

    StructuredSlotField getFirstField() {
        return (StructuredSlotField)this.fields.get(0);
    }

    private StructuredSlotField getLastField() {
        return (StructuredSlotField)this.fields.get(this.fields.size() - 1);
    }

    @Override
    public boolean previousWord(StructuredSlotField f, boolean atStart) {
        if (atStart) {
            this.backwardAtStart(f);
            return true;
        }
        return false;
    }

    @Override
    public boolean nextWord(StructuredSlotField f, boolean atEnd) {
        if (atEnd) {
            this.forwardAtEnd(f);
            return true;
        }
        return false;
    }

    @Override
    public boolean endOfNextWord(StructuredSlotField f, boolean atEnd) {
        return this.nextWord(f, atEnd);
    }

    @Override
    public boolean selectAll(StructuredSlotField f) {
        this.home(null);
        this.selectEnd(this.getFirstField(), 0);
        return true;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean selectNextWord(StructuredSlotField f) {
        this.setAnchorIfUnset(this.getCurrentPos());
        if (Objects.equals(f.getCurrentPos(), f.getEndPos())) {
            int i = this.findField(f);
            if (this.fields.get(i) instanceof StringLiteralExpression) {
                return false;
            }
            this.selectForward(f, f.getCurrentPos().index, true);
        } else {
            CaretPos anch = this.anchorPos;
            f.nextWord();
            this.anchorPos = anch;
            this.drawSelection(new CaretPos(this.findField(f), f.getCurrentPos()));
        }
        return true;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean selectPreviousWord(StructuredSlotField f) {
        this.setAnchorIfUnset(this.getCurrentPos());
        if (Objects.equals(f.getCurrentPos(), f.getStartPos())) {
            int i = this.findField(f);
            if (this.fields.get(i) instanceof StringLiteralExpression) {
                return false;
            }
            this.selectBackward(f, 0);
        } else {
            f.previousWord();
            this.drawSelection(new CaretPos(this.findField(f), f.getCurrentPos()));
        }
        return true;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean cut() {
        this.copy();
        this.deleteSelection();
        return true;
    }

    @Override
    public void moveTo(double sceneX, double sceneY, boolean setAnchor) {
        CaretPos pos = this.getNearest(sceneX, sceneY, true, OptionalInt.empty()).getPos();
        this.positionCaret(pos);
        if (setAnchor) {
            this.anchorPos = pos;
        }
    }

    PosAndDist getNearest(double sceneX, double sceneY, boolean canDescend, OptionalInt restrictTo) {
        PosAndDist nearest = new PosAndDist();
        for (int i = 0; i < this.fields.size(); ++i) {
            int index = i;
            if (restrictTo.isPresent() && restrictTo.getAsInt() != i) continue;
            nearest = PosAndDist.nearest(nearest, this.fields.get(i).getNearest(sceneX, sceneY, canDescend, this.anchorPos != null && this.anchorPos.index == i).copyAdjustPos(p -> new CaretPos(index, (CaretPos)p)));
        }
        return nearest;
    }

    @Override
    public void selectTo(double sceneX, double sceneY) {
        CaretPos pos = this.getNearest(sceneX, sceneY, false, this.anchorPos != null && this.fields.get(this.anchorPos.index) instanceof StringLiteralExpression ? OptionalInt.of(this.anchorPos.index) : OptionalInt.empty()).getPos();
        this.positionCaret(pos);
        this.drawSelection(pos);
    }

    @Override
    public void selected() {
        if (this.anchorPos == null || this.anchorPos.equals(this.getCurrentPos())) {
            this.anchorPos = null;
            this.drawSelection(null);
        }
    }

    private void setAnchorIfUnset(CaretPos caretPos) {
        if (this.anchorPos == null) {
            this.anchorPos = caretPos;
        }
    }

    @Override
    public boolean selectBackward(StructuredSlotField f, int posInSlot) {
        int start = this.findField(f);
        if (posInSlot > 0) {
            this.setAnchorIfUnset(new CaretPos(start, new CaretPos(posInSlot, null)));
            CaretPos newPos = new CaretPos(start, new CaretPos(posInSlot - 1, null));
            this.drawSelection(newPos);
            this.positionCaret(newPos);
            return true;
        }
        if (this.fields.get(start) instanceof StringLiteralExpression) {
            return false;
        }
        for (int i = start - 1; i >= 0; --i) {
            CaretPos pos = this.fields.get(i).getSelectIntoPos(true);
            if (pos == null) continue;
            pos = new CaretPos(i, pos);
            this.setAnchorIfUnset(new CaretPos(start, new CaretPos(posInSlot, null)));
            this.positionCaret(pos);
            this.drawSelection(pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean selectForward(StructuredSlotField f, int posInSlot, boolean atEnd) {
        int start = this.findField(f);
        if (!atEnd) {
            this.setAnchorIfUnset(new CaretPos(start, new CaretPos(posInSlot, null)));
            CaretPos newPos = new CaretPos(start, new CaretPos(posInSlot + 1, null));
            this.drawSelection(newPos);
            this.positionCaret(newPos);
            return true;
        }
        if (this.fields.get(start) instanceof StringLiteralExpression) {
            return false;
        }
        for (int i = start + 1; i < this.fields.size(); ++i) {
            CaretPos pos = this.fields.get(i).getSelectIntoPos(false);
            if (pos == null) continue;
            pos = new CaretPos(i, pos);
            this.setAnchorIfUnset(new CaretPos(start, new CaretPos(posInSlot, null)));
            this.positionCaret(pos);
            this.drawSelection(pos);
            return true;
        }
        return false;
    }

    @Override
    public void delete(StructuredSlotField f, int start, int end) {
        this.modification(token -> f.setText(f.getText().substring(0, start) + f.getText().substring(end), (StructuredSlot.ModificationToken)token));
    }

    @Override
    public boolean copy() {
        CaretPos end;
        CaretPos start;
        if (this.anchorPos == null) {
            return true;
        }
        CaretPos cur = this.getCurrentPos();
        if (this.anchorPos.before(cur)) {
            start = this.anchorPos;
            end = cur;
        } else {
            start = cur;
            end = this.anchorPos;
        }
        String s = this.getCopyText(start, end);
        Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, s));
        return true;
    }

    public String getCopyText(CaretPos start, CaretPos end) {
        if (start == null) {
            start = new CaretPos(0, new CaretPos(0, null));
        }
        if (end == null) {
            end = new CaretPos(this.fields.size() - 1, this.getLastField().getEndPos());
        }
        if (start.index == end.index) {
            return this.fields.get(start.index).getCopyText(start.subPos, end.subPos);
        }
        StringBuilder b = new StringBuilder();
        b.append(this.fields.get(start.index).getCopyText(start.subPos, null));
        if (this.operators.get(start.index) != null) {
            b.append(this.operators.get(start.index).getCopyText());
        }
        for (int i = start.index + 1; i < end.index; ++i) {
            b.append(this.fields.get(i).getCopyText(null, null));
            if (this.operators.get(i) == null) continue;
            b.append(this.operators.get(i).getCopyText());
        }
        b.append(this.fields.get(end.index).getCopyText(null, end.subPos));
        return b.toString();
    }

    private String getJavaCodeForFields(int start, int end) {
        StringBuilder b = new StringBuilder();
        for (int i = start; i < end; ++i) {
            b.append(this.fields.get(i).getJavaCode());
            if (i >= this.operators.size() || this.operators.get(i) == null || i >= end - 1) continue;
            b.append(this.operators.get(i).getJavaCode());
        }
        return b.toString();
    }

    public String getJavaCode() {
        StringBuilder b = new StringBuilder();
        int closing = 0;
        int last = 0;
        for (int i = 0; i < this.operators.size(); ++i) {
            if (this.operators.get(i) == null) continue;
            String op = this.operators.get(i).get();
            if (op.equals("..")) {
                b.append(lang.stride.Utility.class.getName() + ".makeRange(");
                b.append(this.getJavaCodeForFields(last, i + 1));
                b.append(", ");
                last = i + 1;
                ++closing;
                continue;
            }
            if (!op.equals(",")) continue;
            b.append(this.getJavaCodeForFields(last, i + 1));
            while (closing > 0) {
                b.append(")");
                --closing;
            }
            b.append(", ");
            last = i + 1;
        }
        b.append(this.getJavaCodeForFields(last, this.fields.size()));
        while (closing > 0) {
            b.append(")");
            --closing;
        }
        return b.toString();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean deleteSelection() {
        return this.modificationReturnPlatform(token -> this.deleteSelectionImpl(this.getCurrentPos(), (StructuredSlot.ModificationToken)token) != null);
    }

    @OnThread(value=Tag.FXPlatform)
    private CaretPos deleteSelectionImpl(CaretPos cur, StructuredSlot.ModificationToken token) {
        CaretPos end;
        CaretPos start;
        if (this.anchorPos == null || this.anchorPos.equals(cur)) {
            this.anchorPos = null;
            return null;
        }
        if (this.anchorPos.before(cur)) {
            start = this.anchorPos;
            end = cur;
        } else {
            start = cur;
            end = this.anchorPos;
        }
        this.anchorPos = null;
        if (start.index == end.index) {
            if (this.fields.get(start.index) instanceof BracketedStructured) {
                Object nested = ((BracketedStructured)this.fields.get(start.index)).getContent();
                ((InfixStructured)nested).setAnchorIfUnset(start.subPos);
                return new CaretPos(start.index, ((InfixStructured)nested).deleteSelectionImpl(end.subPos, token));
            }
            if (this.fields.get(start.index) instanceof StringLiteralExpression) {
                StringLiteralExpression s = (StringLiteralExpression)this.fields.get(start.index);
                StructuredSlotField f = s.getField();
                f.setText(f.getText().substring(0, start.subPos.index) + f.getText().substring(end.subPos.index), token);
                return start;
            }
        }
        StructuredSlotField startField = (StructuredSlotField)this.fields.get(start.index);
        StructuredSlotField endField = (StructuredSlotField)this.fields.get(end.index);
        startField.setText(startField.getText().substring(0, start.subPos.index) + endField.getText().substring(end.subPos.index), token);
        for (int i = start.index + 1; i <= end.index; ++i) {
            this.operators.remove(start.index, token);
            this.fields.remove(start.index + 1, token);
        }
        CaretPos pos = this.checkFieldChange(start.index, start, token);
        this.positionCaret(pos);
        if (this.slot != null) {
            ((StructuredSlot)this.slot).clearSelection(true);
        }
        return pos;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean deletePrevious(StructuredSlotField f, int posInField, boolean atStart) {
        this.modificationPlatform(token -> this.positionCaret(this.deletePrevious_(f, posInField, atStart, (StructuredSlot.ModificationToken)token)));
        return true;
    }

    @OnThread(value=Tag.FXPlatform)
    public CaretPos deletePreviousAtPos(CaretPos p, StructuredSlot.ModificationToken token) {
        StructuredSlotComponent c = this.fields.get(p.index);
        if (c instanceof StructuredSlotField) {
            return this.deletePrevious_((StructuredSlotField)c, p.subPos.index, p.subPos.index == 0, token);
        }
        if (c instanceof StringLiteralExpression) {
            return this.deletePrevious_(((StringLiteralExpression)c).getField(), p.subPos.index, p.subPos.index == 0, token);
        }
        if (c instanceof BracketedStructured) {
            return new CaretPos(p.index, ((InfixStructured)((BracketedStructured)c).getContent()).deletePreviousAtPos(p.subPos, token));
        }
        throw new IllegalStateException();
    }

    @OnThread(value=Tag.FXPlatform)
    CaretPos deletePrevious_(StructuredSlotField f, int posInField, boolean atStart, StructuredSlot.ModificationToken token) {
        int index = this.findField(f);
        if (atStart) {
            if (index > 0) {
                Operator prev = this.operators.get(index - 1);
                if (prev == null) {
                    boolean inString = this.fields.get(index) instanceof StringLiteralExpression;
                    return this.flattenCompound(inString ? index : index - 1, !inString, token);
                }
                String op = prev.get();
                if (op.length() > 1 && !op.equals("new ")) {
                    prev.set(op.substring(0, op.length() - 1));
                    return this.checkFieldChange(index - 1, new CaretPos(index, new CaretPos(0, null)), token);
                }
                this.operators.remove(index - 1, token);
                StructuredSlotField prevField = (StructuredSlotField)this.fields.get(index - 1);
                String opRemaining = "";
                if (op.equals("new ")) {
                    opRemaining = "new";
                }
                int newPos = prevField.getText().length() + opRemaining.length();
                prevField.setText(prevField.getText() + opRemaining + f.getText(), token);
                this.fields.remove(index, token);
                return this.checkFieldChange(index - 1, new CaretPos(index - 1, new CaretPos(newPos, null)), token);
            }
            if (this.parent != null) {
                return new CaretPos(-1, this.parent.flatten(false, token));
            }
            if (this.slot != null) {
                if (((StructuredSlot)this.slot).backspaceAtStart()) {
                    return null;
                }
                return new CaretPos(0, new CaretPos(0, null));
            }
            if (this.editor != null) {
                throw new IllegalStateException("No parent nor slot");
            }
            return new CaretPos(0, new CaretPos(0, null));
        }
        String s = f.getText();
        f.setText(s.substring(0, posInField - 1) + s.substring(posInField), token);
        CaretPos p = this.checkFieldChange(index, new CaretPos(index, new CaretPos(posInField - 1, null)), token);
        return p;
    }

    @OnThread(value=Tag.FXPlatform)
    public CaretPos flattenCompound(StructuredSlotComponent item, boolean caretAtEnd, StructuredSlot.ModificationToken token) {
        return this.flattenCompound(this.fields.indexOf(item), caretAtEnd, token);
    }

    @OnThread(value=Tag.FXPlatform)
    private CaretPos flattenCompound(int index, boolean atEnd, StructuredSlot.ModificationToken token) {
        StructuredSlotField fieldBefore = (StructuredSlotField)this.fields.get(index - 1);
        String after = this.fields.get(index + 1).getCopyText(null, null);
        String content = this.fields.get(index).getCopyText(this.fields.get(index).getStartPos(), this.fields.get(index).getEndPos());
        this.fields.remove(index + 1, token);
        if (this.operators.remove(index, token) != null) {
            throw new IllegalStateException();
        }
        this.fields.remove(index, token);
        if (this.operators.remove(index - 1, token) != null) {
            throw new IllegalStateException();
        }
        int len = fieldBefore.getText().length();
        CaretPos mid = this.insertImpl(fieldBefore, len, content, false, token);
        this.testingInsert(mid, after);
        if (atEnd) {
            return mid;
        }
        return new CaretPos(index - 1, new CaretPos(len, null));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean deleteNext(StructuredSlotField f, int posInField, boolean atEnd) {
        this.modificationPlatform(token -> this.positionCaret(this.deleteNextImpl(f, posInField, atEnd, (StructuredSlot.ModificationToken)token)));
        return true;
    }

    @OnThread(value=Tag.FXPlatform)
    private CaretPos deleteNextImpl(StructuredSlotField f, int posInField, boolean atEnd, StructuredSlot.ModificationToken token) {
        int index = this.findField(f);
        if (atEnd) {
            if (index < this.fields.size() - 1) {
                Operator next = this.operators.get(index);
                if (next == null) {
                    boolean inString = this.fields.get(index) instanceof StringLiteralExpression;
                    return this.flattenCompound(inString ? index : index + 1, inString, token);
                }
                String op = next.get();
                if (op.length() > 1 && this.isOperator(op.substring(1))) {
                    next.set(op.substring(1));
                    return this.checkFieldChange(index, new CaretPos(index, new CaretPos(posInField, null)), token);
                }
                String opRemaining = "";
                if (op.equals("new ")) {
                    opRemaining = "ew";
                }
                this.operators.remove(index, token);
                int newPos = f.getText().length();
                f.setText(f.getText() + opRemaining + ((StructuredSlotField)this.fields.get(index + 1)).getText(), token);
                this.fields.remove(index + 1, token);
                return this.checkFieldChange(index, new CaretPos(index, new CaretPos(newPos, null)), token);
            }
            if (this.parent != null) {
                return new CaretPos(-1, this.parent.flatten(true, token));
            }
            if (this.slot != null && ((StructuredSlot)this.slot).deleteAtEnd()) {
                return null;
            }
            return new CaretPos(index, new CaretPos(posInField, null));
        }
        String s = f.getText();
        f.setText(s.substring(0, posInField) + s.substring(posInField + 1), token);
        return this.checkFieldChange(index, new CaretPos(index, new CaretPos(posInField, null)), token);
    }

    public CaretPos getCurrentPos() {
        for (int i = 0; i < this.fields.size(); ++i) {
            CaretPos pos = this.fields.get(i).getCurrentPos();
            if (pos == null) continue;
            return new CaretPos(i, pos);
        }
        return null;
    }

    private int findField(StructuredSlotComponent f) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i) == f) {
                return i;
            }
            if (!(this.fields.get(i) instanceof StringLiteralExpression) || f != ((StringLiteralExpression)this.fields.get(i)).getField()) continue;
            return i;
        }
        return -1;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void insert(StructuredSlotField f, int posInField, String text) {
        this.modificationPlatform(token -> this.insertImpl(f, posInField, text, true, (StructuredSlot.ModificationToken)token));
    }

    @OnThread(value=Tag.FXPlatform)
    public CaretPos insertImpl(StructuredSlotField f, int posInField, String text, boolean user, StructuredSlot.ModificationToken token) {
        CaretPos postDeletion;
        if (this.parent == null && !text.isEmpty() && text.length() > 0 && this.closingChars.contains(Character.valueOf(text.charAt(0)))) {
            ((StructuredSlot)this.slot).focusNext();
            return null;
        }
        int index = this.findField(f);
        if (index == -1) {
            return null;
        }
        CaretPos pos = new CaretPos(index, new CaretPos(posInField, null));
        if (text.length() > 0 && !this.isOpeningBracket(text.charAt(0)) && text.charAt(0) != '\"' && text.charAt(0) != '\'' && (postDeletion = this.deleteSelectionImpl(pos, token)) != null) {
            pos = postDeletion;
        }
        for (int i = 0; i < text.length(); ++i) {
            pos = this.insertChar(pos, text.charAt(i), user, token);
            this.anchorPos = null;
            if (pos.index != Integer.MAX_VALUE) continue;
            if (this.parent == null) {
                throw new IllegalStateException();
            }
            this.parent.insertAfter(text.substring(i + 1));
            return null;
        }
        this.positionCaret(pos);
        if (this.slot != null) {
            ((StructuredSlot)this.slot).clearSelection(true);
        }
        return pos;
    }

    @OnThread(value=Tag.FXPlatform)
    CaretPos insertAtPos(CaretPos p, String after, StructuredSlot.ModificationToken token) {
        StructuredSlotComponent f = this.fields.get(p.index);
        if (f instanceof StructuredSlotField) {
            return this.insertImpl((StructuredSlotField)this.fields.get(p.index), p.subPos.index, after, false, token);
        }
        if (f instanceof StringLiteralExpression) {
            return this.insertImpl(((StringLiteralExpression)this.fields.get(p.index)).getField(), p.subPos.index, after, false, token);
        }
        return new CaretPos(p.index, ((InfixStructured)((BracketedStructured)this.fields.get(p.index)).testingContent()).insertAtPos(p.subPos, after, token));
    }

    @OnThread(value=Tag.FXPlatform)
    protected CaretPos insertChar(CaretPos pos, char c, boolean user, StructuredSlot.ModificationToken token) {
        StructuredSlotComponent slot = this.fields.get(pos.index);
        if (slot instanceof StructuredSlotField) {
            StructuredSlotField f = (StructuredSlotField)slot;
            Operator prev = pos.index == 0 ? null : this.operators.get(pos.index - 1);
            Operator next = pos.index >= this.operators.size() ? null : this.operators.get(pos.index);
            int posInField = pos.subPos.index;
            if (this.isDisallowed(c)) {
                return pos;
            }
            if (Character.isWhitespace(c) && !f.getText().substring(0, posInField).equals("new")) {
                return pos;
            }
            if (posInField == 0 && prev != null && this.isOperator(prev.get() + c)) {
                prev.set(prev.get() + c);
                return pos;
            }
            if (posInField == f.getText().length() && next != null && this.isOperator(c + next.get())) {
                next.set(c + next.get());
                return pos;
            }
            if (c == ',' && posInField == f.getText().length() && next != null && next.get().equals(",") && pos.index + 1 < this.fields.size() && this.fields.get(pos.index + 1).getCopyText(null, null).isEmpty()) {
                return new CaretPos(pos.index + 1, new CaretPos(0, null));
            }
            if (this.beginsOperator(c) && c != '.' && c != '+' && c != '-') {
                String before = f.getText().substring(0, posInField);
                String following = f.getText().substring(posInField);
                f.setText(before, token);
                this.operators.add(pos.index, new Operator("" + c, this), token);
                this.fields.add(pos.index + 1, this.makeNewField(following, false), token);
                return new CaretPos(pos.index + 1, new CaretPos(0, null));
            }
            if (this.anchorPos != null && (this.isOpeningBracket(c) || c == '\"' || c == '\'')) {
                String content = this.anchorPos.before(pos) ? this.getCopyText(this.anchorPos, pos) : this.getCopyText(pos, this.anchorPos);
                pos = this.deleteSelectionImpl(pos, token);
                pos = this.insertChar(pos, c, false, token);
                this.insertAtPos(pos, content, token);
                return new CaretPos(pos.index + 1, new CaretPos(0, null));
            }
            if (this.isOpeningBracket(c)) {
                Object following;
                if (posInField == f.getText().length() && pos.index + 1 < this.fields.size() && this.fields.get(pos.index + 1) instanceof BracketedStructured && ((BracketedStructured)(following = (BracketedStructured)this.fields.get(pos.index + 1))).getOpening() == c) {
                    return new CaretPos(pos.index + 1, new CaretPos(0, new CaretPos(0, null)));
                }
                following = f.getText().substring(posInField);
                f.setText(f.getText().substring(0, posInField), token);
                this.operators.add(pos.index, null, token);
                this.fields.add(pos.index + 1, new BracketedStructured<InfixStructured, SLOT>(this.editor, this, this.slot, c, "", token), token);
                if (pos.index + 1 >= this.operators.size() || this.operators.get(pos.index + 1) != null || !(this.fields.get(pos.index + 2) instanceof StructuredSlotField)) {
                    this.operators.add(pos.index + 1, null, token);
                    this.fields.add(pos.index + 2, this.makeNewField((String)following, false), token);
                } else {
                    StructuredSlotField follow = (StructuredSlotField)this.fields.get(pos.index + 2);
                    follow.setText((String)following + follow.getText(), token);
                }
                return new CaretPos(pos.index + 1, new CaretPos(0, new CaretPos(0, null)));
            }
            if (this.isClosingBracket(c)) {
                if (this.closingChars.contains(Character.valueOf(c)) && posInField == f.getText().length()) {
                    return new CaretPos(Integer.MAX_VALUE, null);
                }
                return pos;
            }
            if (c == '\"' || c == '\'') {
                String following = f.getText().substring(posInField);
                f.setText(f.getText().substring(0, posInField), token);
                this.operators.add(pos.index, null, token);
                this.fields.add(pos.index + 1, new StringLiteralExpression(c, this.makeNewField("", true), this), token);
                if (pos.index + 1 >= this.operators.size() || this.operators.get(pos.index + 1) != null || this.fields.get(pos.index + 2) instanceof StringLiteralExpression || this.fields.get(pos.index + 2) instanceof BracketedStructured) {
                    this.operators.add(pos.index + 1, null, token);
                    this.fields.add(pos.index + 2, this.makeNewField(following, false), token);
                } else {
                    StructuredSlotField follow = (StructuredSlotField)this.fields.get(pos.index + 2);
                    follow.setText(following + follow.getText(), token);
                }
                return new CaretPos(pos.index + 1, new CaretPos(0, new CaretPos(0, null)));
            }
            if (f.getText().substring(0, posInField).equals("new") && Character.isWhitespace(c)) {
                String following = f.getText().substring(posInField);
                f.setText("", token);
                this.operators.add(pos.index, new Operator("new ", this), token);
                this.fields.add(pos.index + 1, this.makeNewField(following, false), token);
                return new CaretPos(pos.index + 1, new CaretPos(0, null));
            }
            f.setText(f.getText().substring(0, posInField) + c + f.getText().substring(posInField), token);
            CaretPos overridePos = this.checkFieldChange(pos.index, new CaretPos(pos.index, new CaretPos(posInField + 1, null)), c == '.', user, token);
            return overridePos;
        }
        if (slot instanceof BracketedStructured) {
            CaretPos newSubPos = ((InfixStructured)((BracketedStructured)slot).getContent()).insertChar(pos.subPos, c, false, token);
            if (newSubPos.index == Integer.MAX_VALUE) {
                return new CaretPos(pos.index + 1, new CaretPos(0, null));
            }
            return new CaretPos(pos.index, newSubPos);
        }
        if (slot instanceof StringLiteralExpression) {
            StringLiteralExpression lit = (StringLiteralExpression)slot;
            StructuredSlotField f = lit.getField();
            int posInField = pos.subPos.index;
            if ((c == '\"' || c == '\'') && ("" + c).equals(lit.getQuote()) && this.getEscapeStatus(f.getText().substring(0, posInField)) == EscapeStatus.NORMAL) {
                if (posInField == f.getText().length()) {
                    return new CaretPos(pos.index + 1, new CaretPos(0, null));
                }
                return pos;
            }
            f.setText(f.getText().substring(0, posInField) + c + f.getText().substring(posInField), token);
            return new CaretPos(pos.index, new CaretPos(posInField + 1, null));
        }
        return null;
    }

    protected abstract boolean isDisallowed(char var1);

    protected abstract boolean isOpeningBracket(char var1);

    protected abstract boolean isClosingBracket(char var1);

    public void setEditable(boolean editable) {
        this.fields.forEach(c -> c.setEditable(editable));
    }

    public boolean isNumericLiteral() {
        return this.fields.stream().allMatch(StructuredSlotComponent::isNumericLiteral);
    }

    private EscapeStatus getEscapeStatus(String text) {
        EscapeStatus status = EscapeStatus.NORMAL;
        for (char c : text.toCharArray()) {
            if (status == EscapeStatus.NORMAL) {
                if (c != '\\') continue;
                status = EscapeStatus.AFTER_BACKSLASH;
                continue;
            }
            if (status != EscapeStatus.AFTER_BACKSLASH) continue;
            status = EscapeStatus.NORMAL;
        }
        return status;
    }

    @OnThread(value=Tag.FXPlatform)
    private CaretPos checkFieldChange(int index, CaretPos pos, StructuredSlot.ModificationToken token) {
        return this.checkFieldChange(index, pos, false, false, token);
    }

    @OnThread(value=Tag.FXPlatform)
    private CaretPos checkFieldChange(int index, CaretPos pos, boolean addedDot, boolean user, StructuredSlot.ModificationToken token) {
        if (this.fields.get(index) instanceof StringLiteralExpression) {
            return pos;
        }
        StructuredSlotField f = (StructuredSlotField)this.fields.get(index);
        String prevOp = index > 0 && this.operators.get(index - 1) != null ? this.operators.get(index - 1).get() : "";
        String nextOp = index < this.operators.size() && this.operators.get(index) != null ? this.operators.get(index).get() : "";
        StructuredSlotField prevField = index > 0 && this.fields.get(index - 1) instanceof StructuredSlotField ? (StructuredSlotField)this.fields.get(index - 1) : null;
        boolean precedingBracket = index > 0 && this.operators.get(index - 1) == null;
        boolean bracketBeforePrevField = index > 1 && prevField != null && this.operators.get(index - 2) == null;
        int dotIndex = -1;
        while ((dotIndex = f.getText().indexOf(46, dotIndex + 1)) != -1) {
            boolean isDoubleDot;
            String beforeDot = f.getText().substring(0, dotIndex);
            String afterDot = f.getText().substring(dotIndex + 1);
            boolean bl = isDoubleDot = this.isOperator("..") && afterDot.startsWith(".");
            if (this.supportsFloatLiterals() && InfixStructured.precedesDotInFloatingPointLiteral(beforeDot) && !isDoubleDot) continue;
            f.setText(beforeDot, token);
            if (isDoubleDot) {
                this.operators.add(index, new Operator("..", this), token);
                this.fields.add(index + 1, this.makeNewField(afterDot.substring(1), false), token);
            } else {
                boolean wasShowingSuggestions = this.slot != null && ((StructuredSlot)this.slot).isShowingSuggestions();
                this.operators.add(index, new Operator(".", this), token);
                this.fields.add(index + 1, this.makeNewField(afterDot, false), token);
                if (wasShowingSuggestions && user && addedDot) {
                    JavaFXUtil.runPlatformLater(() -> ((StructuredSlot)this.slot).showSuggestionDisplay((StructuredSlotField)this.fields.get(index + 1), 0, false));
                }
            }
            if (pos.index > index) {
                pos = new CaretPos(pos.index + (isDoubleDot ? 2 : 1), pos.subPos);
            } else if (pos.index == index && pos.subPos.index > beforeDot.length()) {
                pos = new CaretPos(index + 1, new CaretPos(pos.subPos.index - (beforeDot.length() + (isDoubleDot ? 2 : 1)), null));
            }
            pos = this.checkFieldChange(index, pos, token);
            return this.checkFieldChange(index + 1, pos, token);
        }
        if (this.supportsFloatLiterals() && InfixStructured.precedesDotInFloatingPointLiteral(f.getText()) && nextOp.equals(".")) {
            int prevLen = f.getText().length();
            f.setText(f.getText() + nextOp + ((StructuredSlotField)this.fields.get(index + 1)).getText(), token);
            this.operators.remove(index, token);
            this.fields.remove(index + 1, token);
            if (pos.index > index + 1) {
                pos = new CaretPos(pos.index - 1, pos.subPos);
            } else if (pos.index == index + 1) {
                pos = new CaretPos(index, new CaretPos(pos.subPos.index + prevLen + 1, null));
            }
            nextOp = index < this.operators.size() && this.operators.get(index) != null ? this.operators.get(index).get() : "";
        }
        Function<Integer, Integer> findPlusMinus = prev -> {
            int plusIndex = f.getText().indexOf(43, prev + 1);
            int minusIndex = f.getText().indexOf(45, prev + 1);
            if (plusIndex == -1) {
                return minusIndex;
            }
            if (minusIndex == -1) {
                return plusIndex;
            }
            return Math.min(plusIndex, minusIndex);
        };
        int plusMinusIndex = -1;
        while ((plusMinusIndex = findPlusMinus.apply(plusMinusIndex).intValue()) != -1) {
            String before = f.getText().substring(0, plusMinusIndex);
            String after = f.getText().substring(plusMinusIndex + 1);
            boolean atBeginningAndUnary = before.equals("") && !precedingBracket && (!prevOp.equals("") || prevField == null || prevField.getText().equals("")) && this.succeedsOpeningPlusMinusInFloatingPointLiteral(after);
            boolean midwayAfterEorP = this.precedesPlusMinusInFloatingPointLiteral(before);
            if (atBeginningAndUnary || midwayAfterEorP) continue;
            this.operators.add(index, new Operator(f.getText().substring(plusMinusIndex, plusMinusIndex + 1), this), token);
            f.setText(before, token);
            this.fields.add(index + 1, this.makeNewField(after, false), token);
            if (pos.index > index) {
                return new CaretPos(pos.index + 1, pos.subPos);
            }
            if (pos.index == index) {
                if (pos.subPos.index <= before.length()) {
                    return pos;
                }
                return new CaretPos(index + 1, new CaretPos(pos.subPos.index - (before.length() + 1), null));
            }
            return pos;
        }
        if (this.precedesPlusMinusInFloatingPointLiteral(f.getText()) && (nextOp.equals("+") || nextOp.equals("-"))) {
            int prevLen = f.getText().length();
            f.setText(f.getText() + nextOp + ((StructuredSlotField)this.fields.get(index + 1)).getText(), token);
            this.operators.remove(index, token);
            this.fields.remove(index + 1, token);
            if (pos.index > index + 1) {
                pos = new CaretPos(pos.index - 1, pos.subPos);
            } else if (pos.index == index + 1) {
                pos = new CaretPos(index, new CaretPos(pos.subPos.index + prevLen + 1, null));
            }
        }
        if ((prevOp.equals("+") || prevOp.equals("-")) && this.succeedsOpeningPlusMinusInFloatingPointLiteral(f.getText()) && prevField != null && prevField.getText().equals("") && !bracketBeforePrevField) {
            this.operators.remove(index - 1, token);
            this.fields.remove(index - 1, token);
            f.setText(prevOp + f.getText(), token);
            pos = new CaretPos(pos.index - 1, new CaretPos(pos.subPos.index + 1, null));
        }
        return pos;
    }

    protected abstract boolean supportsFloatLiterals();

    private boolean precedesPlusMinusInFloatingPointLiteral(String before) {
        return before.matches("\\A\\s*0x[0-9A-Fa-f]([0-9A-Fa-f_]*[0-9A-Fa-f])?(\\.([0-9A-Fa-f]([0-9A-Fa-f_]*[0-9A-Fa-f])?)?)?[pP]\\z") || before.matches("\\A\\s*[+-]?\\d([0-9_]*\\d)?(\\.(\\d([0-9_]*\\d)?)?)?[eE]\\z");
    }

    private boolean succeedsOpeningPlusMinusInFloatingPointLiteral(String after) {
        return after.matches("\\A\\d.*");
    }

    public void focusAtStart() {
        this.getFirstField().focusAtStart();
    }

    public void focusAtEnd() {
        this.getLastField().focusAtEnd();
    }

    public CaretPos getStartPos() {
        return new CaretPos(0, this.getFirstField().getStartPos());
    }

    public CaretPos getEndPos() {
        return new CaretPos(this.fields.size() - 1, this.getLastField().getEndPos());
    }

    public void end() {
        this.getLastField().focusAtEnd();
    }

    public ObservableList<Node> getComponents() {
        return this.components;
    }

    public boolean isEmpty() {
        return this.fields.size() == 1 && this.getFirstField().isEmpty();
    }

    public void requestFocus() {
        this.getFirstField().requestFocus();
    }

    void withContent(BiConsumer<ProtectedList<StructuredSlotComponent>, ProtectedList<Operator>> setPrompts) {
        setPrompts.accept(this.fields, this.operators);
    }

    Region getNodeForPos(CaretPos pos) {
        StructuredSlotComponent f = this.fields.get(pos.index);
        return f.getNodeForPos(pos.subPos);
    }

    List<CaretPosMap> mapCaretPosStringPos(IntCounter cur, boolean javaString) {
        ArrayList<CaretPosMap> r = new ArrayList<CaretPosMap>();
        BiConsumer<Integer, Integer> addForRange = (startIncl, endExcl) -> {
            for (int i = startIncl.intValue(); i < endExcl; ++i) {
                Operator op;
                for (CaretPosMap cpm : this.fields.get(i).mapCaretPosStringPos(cur, javaString)) {
                    r.add(cpm.wrap(i));
                }
                if (i >= this.operators.size() || i >= endExcl - 1 || (op = this.operators.get(i)) == null) continue;
                cur.counter = cur.counter + (javaString ? op.getJavaCode().length() : op.get().length());
            }
        };
        if (!javaString) {
            addForRange.accept(0, this.fields.size());
        } else {
            int closing = 0;
            int last = 0;
            for (int i = 0; i < this.fields.size(); ++i) {
                if (i >= this.operators.size() || this.operators.get(i) == null) continue;
                String op = this.operators.get(i).get();
                int commaLength = ", ".length();
                if (op.equals("..")) {
                    cur.counter += (lang.stride.Utility.class.getName() + ".makeRange(").length();
                    addForRange.accept(last, i + 1);
                    cur.counter += commaLength;
                    last = i + 1;
                    ++closing;
                    continue;
                }
                if (!op.equals(",")) continue;
                addForRange.accept(last, i + 1);
                cur.counter += closing + commaLength;
                closing = 0;
                last = i + 1;
            }
            addForRange.accept(last, this.fields.size());
            cur.counter += closing;
        }
        return r;
    }

    CaretPos stringPosToCaretPos(int pos, boolean javaString) {
        List<CaretPosMap> mapping = this.mapCaretPosStringPos(new IntCounter(), javaString);
        for (CaretPosMap cpm : mapping) {
            if (pos > cpm.endIndex) continue;
            if (pos >= cpm.startIndex || javaString) {
                return cpm.posOuter.append(new CaretPos(Math.max(0, pos - cpm.startIndex), null));
            }
            return null;
        }
        Debug.message("Could not find position for: " + pos);
        return null;
    }

    int caretPosToStringPos(CaretPos pos, boolean javaString) {
        List<CaretPosMap> mapping = this.mapCaretPosStringPos(new IntCounter(), javaString);
        for (CaretPosMap cpm : mapping) {
            Optional<Integer> i = pos.getFollowing(cpm.posOuter);
            if (!i.isPresent()) continue;
            return i.get() + cpm.startIndex;
        }
        throw new IllegalStateException();
    }

    double getBaseline() {
        TextField field = (TextField)this.components.get(0);
        double height = field.getHeight() - 3.0 - field.getPadding().getBottom();
        if (field.getBorder() != null && field.getBorder().getInsets() != null) {
            height -= field.getBorder().getInsets().getBottom();
        }
        return height;
    }

    public void blank(StructuredSlot.ModificationToken token) {
        token.check();
        this.operators.clear(token);
        this.fields.clear(token);
        this.fields.add(this.makeNewField("", false), token);
        this.anchorPos = null;
    }

    public boolean isFocused() {
        return this.fields.stream().anyMatch(StructuredSlotComponent::isFocused);
    }

    public boolean isCollapsible(StructuredSlotField f) {
        boolean unaryAfter;
        int index = this.findField(f);
        if (index == -1) {
            return false;
        }
        boolean opBefore = index == 0 || this.operators.get(index - 1) != null;
        boolean opAfter = index == this.operators.size() || this.operators.get(index) != null;
        boolean bl = unaryAfter = index < this.operators.size() && this.canBeUnary(Utility.orNull(this.operators.get(index), Operator::get));
        if (this.fields.size() == 1 && this.parent == null) {
            return this.slot != null && ((StructuredSlot)this.slot).canCollapse();
        }
        if (this.fields.size() == 1 && this.parent != null) {
            return true;
        }
        if (opBefore && opAfter) {
            return unaryAfter;
        }
        return true;
    }

    @OnThread(value=Tag.FXPlatform)
    public void insertNext(BracketedStructured bracketedExpression, String text) {
        int index = this.fields.indexOf(bracketedExpression);
        this.insert((StructuredSlotField)this.fields.get(index + 1), 0, text);
    }

    String testingGetState(CaretPos caret) {
        caret = Utility.orNull(caret, CaretPos::normalise);
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < this.fields.size(); ++i) {
            r.append(this.fields.get(i).testingGetState(caret != null && i == caret.index ? caret.subPos : null));
            if (i >= this.operators.size()) continue;
            if (this.operators.get(i) == null) {
                r.append("_");
                continue;
            }
            r.append(this.operators.get(i).get());
        }
        return r.toString();
    }

    @OnThread(value=Tag.FXPlatform)
    public CaretPos testingInsert(String text, char rememberPos) {
        return this.modificationReturnPlatform(token -> {
            int index = text.indexOf(rememberPos);
            if (rememberPos != '\u0000' && index != -1) {
                String before = text.substring(0, index);
                String after = text.substring(index + 1);
                CaretPos p = this.insertImpl((StructuredSlotField)this.fields.get(0), 0, before, false, (StructuredSlot.ModificationToken)token);
                this.testingInsert(p, after);
                return p;
            }
            return this.insertImpl((StructuredSlotField)this.fields.get(0), 0, text, false, (StructuredSlot.ModificationToken)token);
        });
    }

    @OnThread(value=Tag.FXPlatform)
    CaretPos testingInsert(CaretPos p, String after) {
        return this.modificationReturnPlatform(token -> this.insertAtPos(p, after, (StructuredSlot.ModificationToken)token));
    }

    @OnThread(value=Tag.FXPlatform)
    CaretPos testingBackspace(CaretPos p) {
        return this.modificationReturnPlatform(token -> {
            StructuredSlotComponent f = this.fields.get(p.index);
            if (f instanceof StructuredSlotField) {
                return this.deletePrevious_((StructuredSlotField)this.fields.get(p.index), p.subPos.index, p.subPos.index == 0, (StructuredSlot.ModificationToken)token);
            }
            if (f instanceof StringLiteralExpression) {
                return this.deletePrevious_(((StringLiteralExpression)this.fields.get(p.index)).getField(), p.subPos.index, p.subPos.index == 0, (StructuredSlot.ModificationToken)token);
            }
            return new CaretPos(p.index, ((InfixStructured)((BracketedStructured)this.fields.get(p.index)).testingContent()).testingBackspace(p.subPos));
        });
    }

    @OnThread(value=Tag.FXPlatform)
    CaretPos testingDelete(CaretPos p) {
        StructuredSlotField f;
        StructuredSlotComponent s = this.fields.get(p.index);
        if (s instanceof StructuredSlotField) {
            f = (StructuredSlotField)this.fields.get(p.index);
        } else if (s instanceof StringLiteralExpression) {
            f = ((StringLiteralExpression)this.fields.get(p.index)).getField();
        } else {
            return new CaretPos(p.index, ((InfixStructured)((BracketedStructured)this.fields.get(p.index)).testingContent()).testingDelete(p.subPos));
        }
        return this.modificationReturnPlatform(token -> this.deleteNextImpl(f, p.subPos.index, p.subPos.index == f.getText().length(), (StructuredSlot.ModificationToken)token));
    }

    @OnThread(value=Tag.FXPlatform)
    CaretPos testingDeleteSelection(CaretPos start, CaretPos end) {
        this.anchorPos = start;
        return this.modificationReturnPlatform(token -> this.deleteSelectionImpl(end, (StructuredSlot.ModificationToken)token));
    }

    @OnThread(value=Tag.FXPlatform)
    CaretPos testingInsertWithSelection(CaretPos start, CaretPos end, char c) {
        this.anchorPos = start;
        return this.modificationReturnPlatform(token -> this.insertAtPos(end, "" + c, (StructuredSlot.ModificationToken)token));
    }

    @OnThread(value=Tag.FXPlatform)
    public void insertSuggestion(CaretPos p, String name, char opening, List<String> params, StructuredSlot.ModificationToken token) {
        StructuredSlotComponent f = this.fields.get(p.index);
        if (f instanceof StructuredSlotField) {
            ((StructuredSlotField)f).setText("", token);
            p = this.insertImpl((StructuredSlotField)f, 0, name, false, token);
            if (params != null) {
                StringBuilder commas = new StringBuilder();
                for (int i = 0; i < params.size() - 1; ++i) {
                    commas.append(',');
                }
                if (p.index + 1 < this.fields.size() && this.fields.get(p.index + 1) instanceof BracketedStructured && ((BracketedStructured)this.fields.get(p.index + 1)).getOpening() == opening) {
                    BracketedStructured b = (BracketedStructured)this.fields.get(p.index + 1);
                    if (((InfixStructured)b.getContent()).isEmpty()) {
                        ((InfixStructured)b.getContent()).insertAtPos(new CaretPos(0, new CaretPos(0, null)), commas.toString(), token);
                    }
                    JavaFXUtil.runAfterCurrent(() -> {
                        if (params.size() == 0) {
                            b.focusAfter();
                        } else {
                            b.focusAtStart();
                        }
                    });
                } else {
                    this.insertAtPos(new CaretPos(p.index, new CaretPos(p.subPos.index, null)), "(" + commas.toString() + ")", token);
                    StructuredSlotComponent focusField = this.fields.get(params.isEmpty() ? p.index + 2 : p.index + 1);
                    JavaFXUtil.runAfterCurrent(() -> focusField.focusAtStart());
                }
            }
        } else {
            f.insertSuggestion(p.subPos, name, opening, params, token);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public abstract void calculateTooltipFor(StructuredSlotField var1, FXConsumer<String> var2);

    protected CaretPos absolutePos(CaretPos p) {
        if (this.parent == null) {
            return p;
        }
        return this.parent.absolutePos(p);
    }

    public CaretPos absolutePos(BracketedStructured bracketedExpression, CaretPos p) {
        return this.absolutePos(new CaretPos(this.fields.indexOf(bracketedExpression), p));
    }

    InteractionManager getEditor() {
        return this.editor;
    }

    public List<StructuredSlotField> getSimpleParameters() {
        ArrayList<StructuredSlotField> r = new ArrayList<StructuredSlotField>();
        int lastComma = -1;
        for (int i = 0; i < this.fields.size(); ++i) {
            StructuredSlotField f;
            StructuredSlotField structuredSlotField = f = this.fields.get(i) instanceof StructuredSlotField ? (StructuredSlotField)this.fields.get(i) : null;
            if (i != this.fields.size() - 1 && (this.operators.get(i) == null || !this.operators.get(i).getCopyText().equals(","))) continue;
            if (lastComma == i - 1 && f != null) {
                r.add(f);
            } else {
                r.add(null);
            }
            lastComma = i;
        }
        return r;
    }

    @Override
    public void clicked() {
        ((StructuredSlot)this.slot).hideSuggestionDisplay();
    }

    @Override
    public void caretMoved() {
        if (this.slot != null) {
            JavaFXUtil.ifOnPlatform(() -> ((StructuredSlot)this.slot).caretMoved());
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void escape() {
        ((StructuredSlot)this.slot).escape();
    }

    public void addClosingChar(char closingChar) {
        this.closingChars.add(Character.valueOf(closingChar));
    }

    public Stream<InfixStructured<?, ?>> getAllExpressions() {
        return Stream.concat(Stream.of(this), this.fields.stream().flatMap(StructuredSlotComponent::getAllExpressions));
    }

    public StringExpression textProperty() {
        return this.textProperty;
    }

    public TextOverlayPosition calculateOverlayEnd() {
        return this.getLastField().calculateOverlayEnd();
    }

    List<StructuredSlot.PlainVarReference> findPlainVarUse(String name) {
        ArrayList<StructuredSlot.PlainVarReference> refs = new ArrayList<StructuredSlot.PlainVarReference>();
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i) instanceof StructuredSlotField) {
                StructuredSlotField f = (StructuredSlotField)this.fields.get(i);
                if (!f.getText().equals(name) || i != 0 && this.operators.get(i - 1) != null && this.operators.get(i - 1).get().equals(".") || i != this.fields.size() - 1 && this.fields.get(i) instanceof BracketedStructured && ((BracketedStructured)this.fields.get(i)).getOpening() == '(') continue;
                refs.add(new StructuredSlot.PlainVarReference(text -> this.modification(token -> f.setText((String)text, (StructuredSlot.ModificationToken)token)), f.getNodeForPos(null)));
                continue;
            }
            if (!(this.fields.get(i) instanceof BracketedStructured)) continue;
            refs.addAll(((InfixStructured)((BracketedStructured)this.fields.get(i)).getContent()).findPlainVarUse(name));
        }
        return refs;
    }

    public boolean isCurlyLiteral() {
        if (this.fields.size() != 3) {
            return false;
        }
        if (this.operators.get(0) != null || this.operators.get(1) != null) {
            return false;
        }
        if (!this.fields.get(0).isFieldAndEmpty() || !this.fields.get(2).isFieldAndEmpty()) {
            return false;
        }
        if (!(this.fields.get(1) instanceof BracketedStructured)) {
            return false;
        }
        BracketedStructured e = (BracketedStructured)this.fields.get(1);
        return e.getOpening() == '{';
    }

    void showHighlightedBrackets(BracketedStructured wrapper, CaretPos pos) {
        if (wrapper != null && pos != null && pos.index == 0 && this.fields.get(0).getStartPos().equals(pos.subPos)) {
            wrapper.highlightBrackets(true);
        } else if (wrapper != null && pos != null && pos.index == this.fields.size() - 1 && this.fields.get(this.fields.size() - 1).getEndPos().equals(pos.subPos)) {
            wrapper.highlightBrackets(true);
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            StructuredSlotComponent f = this.fields.get(i);
            if (!(f instanceof BracketedStructured)) continue;
            boolean cursorBefore = i > 0 && pos != null && pos.index == i - 1 && this.fields.get(i - 1) instanceof StructuredSlotField && this.fields.get(i - 1).getEndPos().equals(pos.subPos);
            boolean cursorAfter = i < this.fields.size() - 1 && pos != null && pos.index == i + 1 && this.fields.get(i + 1) instanceof StructuredSlotField && this.fields.get(i + 1).getStartPos().equals(pos.subPos);
            BracketedStructured e = (BracketedStructured)f;
            e.highlightBrackets(cursorBefore || cursorAfter);
            ((InfixStructured)e.getContent()).showHighlightedBrackets(e, pos != null && pos.index == i ? pos.subPos : null);
        }
    }

    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate, Optional<String> forLoopVarName) {
        this.fields.forEach(f -> f.setView(oldView, newView, animate));
        this.operators.forEach(o -> {
            if (o != null) {
                o.setView(newView, animate);
            }
        });
        if (newView == Frame.View.NORMAL) {
            this.previewingJavaRange.set(false);
        } else {
            switch (this.checkRangeExpression()) {
                case RANGE_CONSTANT: {
                    if (forLoopVarName.isPresent()) {
                        Operator rangeOp = this.operators.stream().filter(op -> op != null && op.get().equals("..")).findFirst().get();
                        this.previewingJavaRange.set(true);
                        this.startRangeText.set((Object)"");
                        this.endRangeText.set((Object)("; " + forLoopVarName.get() + "++"));
                        rangeOp.setJavaPreviewRangeOverride("; " + forLoopVarName.get() + " <=");
                        break;
                    }
                }
                case RANGE_NON_CONSTANT: {
                    this.previewingJavaRange.set(true);
                    this.startRangeText.set((Object)(lang.stride.Utility.class.getName() + "("));
                    this.endRangeText.set((Object)")");
                    break;
                }
                default: {
                    this.previewingJavaRange.set(false);
                }
            }
        }
    }

    RangeType checkRangeExpression() {
        if (this.operators.stream().anyMatch(op -> op != null && op.get().equals(","))) {
            return RangeType.NOT_RANGE;
        }
        Optional<Operator> rangeOp = this.operators.stream().filter(op -> op != null && op.get().equals("..")).findFirst();
        if (!rangeOp.isPresent()) {
            return RangeType.NOT_RANGE;
        }
        if (this.fields.stream().allMatch(StructuredSlotComponent::isNumericLiteral)) {
            return RangeType.RANGE_CONSTANT;
        }
        return RangeType.RANGE_NON_CONSTANT;
    }

    @OnThread(value=Tag.FXPlatform)
    public void paste() {
        StructuredSlotField focused = this.fields.stream().filter(f -> f instanceof StructuredSlotField && f.isFocused()).map(f -> (StructuredSlotField)f).findFirst().orElse(null);
        if (focused != null) {
            focused.paste();
        }
    }

    StructuredSlot<?, ?, ?> getSlot() {
        return this.slot;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean suggestingFor(StructuredSlotField f) {
        if (this.slot == null) {
            return false;
        }
        int index = this.findField(f);
        CaretPos fieldPos = this.absolutePos(new CaretPos(index, null));
        return ((StructuredSlot)this.slot).suggestingFor(fieldPos);
    }

    public StructuredSlot.SplitInfo trySplitOn(String target) {
        for (int i = 0; i < this.operators.size(); ++i) {
            Operator op = this.operators.get(i);
            if (op == null || !op.get().equals(target)) continue;
            return new StructuredSlot.SplitInfo(this.getCopyText(null, new CaretPos(i, this.fields.get(i).getEndPos())), this.getCopyText(new CaretPos(i + 1, this.fields.get(i + 1).getStartPos()), null));
        }
        return null;
    }

    public boolean isAlmostBlank() {
        return this.fields.stream().allMatch(StructuredSlotComponent::isAlmostBlank);
    }

    public void notifyLostFocus(StructuredSlotField except) {
        this.fields.forEach(f -> {
            if (f != except) {
                f.notifyLostFocus(except);
            }
        });
    }

    boolean isInSelection() {
        return this.anchorPos != null || this.parent != null && this.parent.isInSelection();
    }

    public int calculateEffort() {
        return this.fields.stream().filter(f -> f != null).mapToInt(StructuredSlotComponent::calculateEffort).sum() + this.operators.stream().filter(op -> op != null).mapToInt(op -> op.get().length()).sum();
    }

    abstract boolean isOperator(String var1);

    abstract boolean beginsOperator(char var1);

    abstract boolean canBeUnary(String var1);

    abstract INFIX newInfix(InteractionManager var1, SLOT var2, String var3, BracketedStructured<?, SLOT> var4, StructuredSlot.ModificationToken var5, Character ... var6);

    private <T> T modificationReturn(FXFunction<StructuredSlot.ModificationToken, T> modificationAction) {
        if (this.slot != null) {
            return ((StructuredSlot)this.slot).modificationReturn(modificationAction);
        }
        return StructuredSlot.testingModification(modificationAction);
    }

    protected <T> void modification(FXConsumer<StructuredSlot.ModificationToken> modificationAction) {
        if (this.slot != null) {
            ((StructuredSlot)this.slot).modificationReturn(t -> {
                modificationAction.accept((StructuredSlot.ModificationToken)t);
                return 0;
            });
        } else {
            StructuredSlot.testingModification(t -> {
                modificationAction.accept((StructuredSlot.ModificationToken)t);
                return 0;
            });
        }
    }

    @OnThread(value=Tag.FXPlatform)
    protected <T> void modificationPlatform(FXPlatformConsumer<StructuredSlot.ModificationToken> modificationAction) {
        this.modification(modificationAction::accept);
    }

    @OnThread(value=Tag.FXPlatform)
    private <T> T modificationReturnPlatform(FXPlatformFunction<StructuredSlot.ModificationToken, T> modificationAction) {
        return (T)this.modificationReturn(modificationAction::apply);
    }

    String calculateText() {
        return Utility.interleave(this.fields.stream().map(f -> f.getText()), this.operators.stream().map(o -> o == null ? null : o.get())).filter(x -> x != null).collect(Collectors.joining());
    }

    private static class OpPrec {
        final int prec;
        final int levels;

        OpPrec(int prec, int levels) {
            this.prec = prec;
            this.levels = levels;
        }
    }

    static class IntCounter {
        public int counter = 0;

        IntCounter() {
        }
    }

    static class CaretPosMap {
        private final CaretPos posOuter;
        private final int startIndex;
        private final int endIndex;

        CaretPosMap(CaretPos posOuter, int startIndex, int endIndex) {
            this.posOuter = posOuter;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public CaretPosMap wrap(int index) {
            return new CaretPosMap(new CaretPos(index, this.posOuter), this.startIndex, this.endIndex);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CaretPosMap other = (CaretPosMap)obj;
            if (this.endIndex != other.endIndex) {
                return false;
            }
            if (this.posOuter == null ? other.posOuter != null : !this.posOuter.equals(other.posOuter)) {
                return false;
            }
            return this.startIndex == other.startIndex;
        }

        public int hashCode() {
            return this.startIndex % 31;
        }

        public String toString() {
            return "CaretPosMap [posOuter=" + this.posOuter + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + "]";
        }
    }

    static enum RangeType {
        RANGE_CONSTANT,
        RANGE_NON_CONSTANT,
        NOT_RANGE;

    }

    private static enum EscapeStatus {
        NORMAL,
        AFTER_BACKSLASH;

    }
}

