/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.parser.AssistContent;
import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.ast.links.PossibleKnownMethodLink;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.frames.ClassFrame;
import bluej.stride.framedjava.frames.NormalMethodFrame;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.framedjava.slots.UnderlineContainer;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleLineFrame;
import bluej.stride.operations.CustomFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.LinkedIdentifier;
import bluej.stride.slots.WrappableSlotLabel;
import bluej.utility.Utility;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.ErrorUnderlineCanvas;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import threadchecker.OnThread;
import threadchecker.Tag;

public class InheritedMethodFrame
extends SingleLineFrame {
    private final InteractionManager editor;
    private final ClassFrame container;
    private final String originatingClass;
    private final AccessPermission access;
    private final String returnType;
    private final String methodName;
    private final List<AssistContent.ParamInfo> params;
    private final InheritedMethodSlot slot;
    private final WrappableSlotLabel overrideLabel = new WrappableSlotLabel("");
    private NormalMethodFrame override;

    public InheritedMethodFrame(InteractionManager editor, ClassFrame container, String originatingClass, AccessPermission access, String returnType, String methodName, List<AssistContent.ParamInfo> params) {
        super(editor, "", "inherited-method-");
        String preName = access + " \t" + returnType + " ";
        String postName = "(" + params.stream().map(p -> p.getUnqualifiedType() + (String)(p.getFormalName() == null ? "" : " " + p.getFormalName())).collect(Collectors.joining(", ")) + ")";
        this.editor = editor;
        this.container = container;
        this.originatingClass = originatingClass;
        this.access = access;
        this.returnType = returnType;
        this.methodName = methodName;
        this.params = params;
        this.slot = new InheritedMethodSlot(preName, methodName, postName);
        this.overrideLabel.addStyleClass("inherited-method-override-label");
        this.overrideLabel.setAlignment(HangingFlowPane.FlowAlignment.RIGHT);
        this.checkForOverride();
        this.setHeaderRow(this.slot, this.overrideLabel);
    }

    private void checkForOverride() {
        this.container.findMethod(this.methodName, this.params, override -> {
            this.override = override;
            if (override != null) {
                this.overrideLabel.setText("overridden in this class");
            }
        });
    }

    @Override
    public boolean canDrag() {
        return false;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<FrameOperation> getContextOperations() {
        ArrayList<FrameOperation> operations = new ArrayList<FrameOperation>();
        operations.add(new FrameOperation(this.getEditor(), "GO TO " + this.originatingClass + "." + this.methodName, AbstractOperation.Combine.ONE){
            private StringProperty text;
            {
                this.enabled = false;
                this.text = new SimpleStringProperty("Scanning...                   ");
            }

            @Override
            public List<AbstractOperation.ItemLabel> getLabels() {
                return Collections.singletonList(new AbstractOperation.ItemLabel((ObservableValue<String>)this.text, AbstractOperation.MenuItemOrder.GOTO_DEFINITION));
            }

            @Override
            protected void execute(List<Frame> frames) {
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void onMenuShowing(CustomMenuItem item) {
                InheritedMethodFrame.this.editor.searchLink(new PossibleKnownMethodLink(InheritedMethodFrame.this.originatingClass, InheritedMethodFrame.this.methodName, Utility.mapList(InheritedMethodFrame.this.params, pi -> pi.getQualifiedType()), 0, 1, InheritedMethodFrame.this.slot), optLink -> {
                    if (optLink.isPresent()) {
                        this.text.set((Object)"Show original");
                        item.setDisable(false);
                        item.onActionProperty().set(e -> ((LinkedIdentifier)optLink.get()).getOnClick().run());
                    }
                });
            }

            @Override
            public void onMenuHidden(CustomMenuItem item) {
                item.setDisable(true);
                this.text.set((Object)"Scanning...");
            }

            @Override
            public boolean onlyOnContextMenu() {
                return true;
            }
        });
        if (this.override == null) {
            operations.add(new CustomFrameOperation(this.editor, "OVERRIDE", Arrays.asList("Override"), AbstractOperation.MenuItemOrder.OVERRIDE, this, () -> {
                NormalMethodFrame methodFrame = new NormalMethodFrame(this.editor, new AccessPermissionFragment(this.access), false, false, this.returnType, this.methodName, "", true);
                this.params.forEach(p -> methodFrame.paramsPane.addFormal(new TypeSlotFragment(p.getUnqualifiedType(), p.getUnqualifiedType()), new NameDefSlotFragment(p.getFormalName() == null ? "" : p.getFormalName())));
                this.container.getLastInternalCursor().insertBlockAfter(methodFrame);
                methodFrame.getFirstInternalCursor().requestFocus();
                methodFrame.markFresh();
            }));
        } else {
            operations.add(new CustomFrameOperation(this.editor, "GO TO " + this.methodName, Arrays.asList("Show override"), AbstractOperation.MenuItemOrder.GOTO_OVERRIDE, this, () -> this.override.focusName()));
        }
        return operations;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void compiled() {
        super.compiled();
        this.checkForOverride();
    }

    private class InheritedMethodSlot
    implements HeaderItem,
    ErrorUnderlineCanvas.UnderlineInfo,
    UnderlineContainer {
        private final ObservableList<Label> labels = FXCollections.observableArrayList();
        private final int methodNameIndex;

        public InheritedMethodSlot(String preName, String methodName, String postName) {
            Arrays.stream(preName.split("\\s+")).forEach(s -> this.labels.add((Object)new Label(s + " ")));
            this.methodNameIndex = this.labels.size();
            Label methodNameLabel = new Label(methodName);
            JavaFXUtil.addStyleClass((Styleable)methodNameLabel, "inherited-method-name");
            this.labels.add((Object)methodNameLabel);
            Arrays.stream(postName.split("\\s+")).forEach(s -> this.labels.add((Object)new Label(s + " ")));
            for (Label label : this.labels) {
                JavaFXUtil.addStyleClass((Styleable)label, "inherited-method-slot");
                label.setOnMouseMoved(e -> JavaFXUtil.setPseudoclass("bj-hyperlink", InheritedMethodFrame.this.getHeaderRow().getOverlay().linkFromX(e.getSceneX()) != null, new Node[]{label}));
                label.setOnMouseClicked(e -> Utility.ifNotNull(InheritedMethodFrame.this.getHeaderRow().getOverlay().linkFromX(e.getSceneX()), FXPlatformRunnable::run));
            }
        }

        @Override
        public TextOverlayPosition getOverlayLocation(int caretPos, boolean javaPos) {
            Label label = (Label)this.labels.get(this.methodNameIndex);
            return TextOverlayPosition.nodeToOverlay((Node)label, JavaFXUtil.measureString((Labeled)label, label.getText().substring(0, caretPos)), 0.0, label.getBaselineOffset(), label.getHeight());
        }

        @Override
        public ObservableList<? extends Node> getComponents() {
            return this.labels;
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void addUnderline(UnderlineContainer.Underline u) {
            InheritedMethodFrame.this.getHeaderRow().getOverlay().addUnderline(this, 0, ((Label)this.labels.get(this.methodNameIndex)).getText().length(), u.getOnClick());
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void removeAllUnderlines() {
            InheritedMethodFrame.this.getHeaderRow().getOverlay().clearUnderlines();
        }

        @Override
        public List<? extends PossibleLink> findLinks() {
            return Collections.singletonList(new PossibleKnownMethodLink(InheritedMethodFrame.this.originatingClass, InheritedMethodFrame.this.methodName, Utility.mapList(InheritedMethodFrame.this.params, AssistContent.ParamInfo::getQualifiedType), 0, 1, this));
        }

        @Override
        public EditableSlot asEditable() {
            return null;
        }

        @Override
        public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        }

        @Override
        public String getXPathForElementAt(double sceneX, double sceneY, LocatableElement.LocationMap locationMap, String xpathParent, boolean includePseudoElements, boolean includeSubstringIndex) {
            return null;
        }
    }
}

