/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.IfElement;
import bluej.stride.framedjava.elements.SandwichCanvasesElement;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.FilledExpressionSlot;
import bluej.stride.framedjava.slots.StructuredSlot;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.generic.SandwichCanvasesFrame;
import bluej.stride.operations.PullUpContentsOperation;
import bluej.stride.slots.SlotLabel;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class IfFrame
extends SandwichCanvasesFrame {
    private static final String IF_STYLE_PREFIX = "if-";
    protected final ExpressionSlot<FilledExpressionSlotFragment> ifCondition;
    private final List<ExpressionSlot<FilledExpressionSlotFragment>> elseIfConditions = new ArrayList<ExpressionSlot<FilledExpressionSlotFragment>>();

    private IfFrame(InteractionManager editor) {
        super(editor, "if", "elseif", "else", IF_STYLE_PREFIX);
        this.ifCondition = new FilledExpressionSlot(editor, this, this, this.getHeaderRow(), IF_STYLE_PREFIX, FilledExpressionSlot.CONDITION_HINTS){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public boolean backspaceAtStart() {
                if (this.isAlmostBlank()) {
                    new PullUpContentsOperation(IfFrame.this.getEditor()).activate(IfFrame.this.getFrame(), (RecallableFocus)IfFrame.this.getCursorBefore());
                    return true;
                }
                return super.backspaceAtStart();
            }
        };
        this.ifCondition.setSimplePromptText("condition");
        this.ifCondition.setTargetType("boolean");
        this.ifCondition.onTextPropertyChange(this.updateSidebarCurried("if "));
        this.setHeaderRow(new SlotLabel(" (", "if-bracket-opening"), this.ifCondition, new SlotLabel(")", new String[0]));
    }

    public IfFrame(InteractionManager editor, List<Frame> contents) {
        this(editor);
        this.getFirstCanvas().getFirstCursor().insertFramesAfter(contents);
    }

    public IfFrame(InteractionManager editor, ExpressionSlotFragment condition, List<Frame> thenContents, List<FilledExpressionSlotFragment> elseIfConditions, List<List<Frame>> elseIfContents, List<Frame> elseContents, boolean enabled) {
        this(editor, thenContents);
        this.ifCondition.setText(condition);
        for (int i = 0; i < elseIfContents.size(); ++i) {
            this.addIntermediateCanvas(Arrays.asList(elseIfConditions.get(i)), elseIfContents.get(i));
        }
        if (elseContents != null) {
            this.addTailCanvas();
            elseContents.forEach(f -> this.getTailCanvas().insertBlockAfter((Frame)f, null));
        }
        this.frameEnabledProperty.set(enabled);
    }

    @Override
    protected FrameContentRow getFrameContentRow(List<SlotFragment> slots, final JavaCanvas canvas, int at) {
        FrameContentRow row = new FrameContentRow((Frame)this, "else-if-");
        FilledExpressionSlot elseIfCondition = new FilledExpressionSlot(this.editor, this, this, row, IF_STYLE_PREFIX, FilledExpressionSlot.CONDITION_HINTS){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public boolean backspaceAtStart() {
                if (this.isAlmostBlank()) {
                    IfFrame.this.pullUpCanvasContents(canvas.getFirstCursor().getUp(), canvas);
                    return true;
                }
                return super.backspaceAtStart();
            }
        };
        elseIfCondition.setSimplePromptText("condition");
        elseIfCondition.setTargetType("boolean");
        if (slots != null) {
            if (slots.size() != 1) {
                Debug.printCallStack("slots has to include only the condition slot, but the size is " + slots.size());
            }
            elseIfCondition.setText((ExpressionSlotFragment)slots.get(0));
        }
        row.setHeaderItems(Arrays.asList(new SlotLabel("else if", "caption", "else-if-caption"), new SlotLabel(" (", "if-bracket-opening"), elseIfCondition, new SlotLabel(")", new String[0])));
        this.elseIfConditions.add(at, elseIfCondition);
        return row;
    }

    @Override
    public boolean focusWhenJustAdded() {
        this.ifCondition.requestFocus();
        return true;
    }

    public static FrameFactory<IfFrame> getFactory() {
        return new FrameFactory<IfFrame>(){

            @Override
            public IfFrame createBlock(InteractionManager editor) {
                return new IfFrame(editor);
            }

            @Override
            public IfFrame createBlock(InteractionManager editor, List<Frame> contents) {
                return new IfFrame(editor, contents);
            }

            @Override
            public Class<IfFrame> getBlockClass() {
                return IfFrame.class;
            }
        };
    }

    @Override
    protected SandwichCanvasesElement regenerateCodeElement(List<CodeElement> firstCanvasContents, List<List<CodeElement>> intermediateCanvasesContents, List<CodeElement> tailCanvasContents, boolean enabled) {
        List<FilledExpressionSlotFragment> elseIfConditionsCode = Utility.mapList(this.elseIfConditions, StructuredSlot::getSlotElement);
        return new IfElement(this, (FilledExpressionSlotFragment)this.ifCondition.getSlotElement(), firstCanvasContents, elseIfConditionsCode, intermediateCanvasesContents, tailCanvasContents, enabled);
    }
}

