/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CaseElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.BlankFrame;
import bluej.stride.framedjava.frames.BreakFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableParentFrame;
import bluej.stride.framedjava.frames.SwitchFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.FilledExpressionSlot;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleCanvasFrame;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.SlotLabel;
import bluej.utility.Utility;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.collections.transformation.FilteredList;
import threadchecker.OnThread;
import threadchecker.Tag;

public class CaseFrame
extends SingleCanvasFrame
implements CodeFrame<CaseElement>,
DebuggableParentFrame {
    private final ExpressionSlot<FilledExpressionSlotFragment> paramCondition;
    private CaseElement element;
    private final SlotLabel opening;
    private final SlotLabel closing;

    private CaseFrame(InteractionManager editor) {
        super(editor, "case", "case-");
        this.paramCondition = new FilledExpressionSlot(editor, this, this, this.getHeaderRow(), "case-condition-");
        this.paramCondition.setSimplePromptText("value");
        this.opening = new SlotLabel("(", new String[0]);
        this.closing = new SlotLabel(")", new String[0]);
        this.setHeaderRow(this.opening, this.paramCondition, this.closing);
        this.paramCondition.onTextPropertyChange(this.updateSidebarCurried("case "));
    }

    public CaseFrame(InteractionManager editor, FilledExpressionSlotFragment condition, boolean enabled) {
        this(editor);
        this.paramCondition.setText(condition);
        this.frameEnabledProperty.set(enabled);
    }

    public static FrameFactory<CaseFrame> getFactory() {
        return new FrameFactory<CaseFrame>(){

            @Override
            public CaseFrame createBlock(InteractionManager editor) {
                CaseFrame caseFrame = new CaseFrame(editor);
                caseFrame.getFirstInternalCursor().insertBlockAfter(BreakFrame.getFactory().createBlock(editor));
                return caseFrame;
            }

            @Override
            public Class<CaseFrame> getBlockClass() {
                return CaseFrame.class;
            }
        };
    }

    @Override
    public FrameCanvas createCanvas(InteractionManager editor, String stylePrefix) {
        return new JavaCanvas(editor, this, stylePrefix, false);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
        return ((JavaCanvas)this.getCanvas()).showDebugBefore(null, debug);
    }

    @Override
    public void regenerateCode() {
        ArrayList<CodeElement> contents = new ArrayList<CodeElement>();
        for (CodeFrame f : this.canvas.getBlocksSubtype(CodeFrame.class)) {
            f.regenerateCode();
            contents.add((CodeElement)f.getCode());
        }
        this.element = new CaseElement(this, (FilledExpressionSlotFragment)this.paramCondition.getSlotElement(), contents, this.frameEnabledProperty.get());
    }

    @Override
    public CaseElement getCode() {
        return this.element;
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas canvas, FrameCursor cursorInCanvas) {
        return Utility.concat(super.getAvailableExtensions(canvas, cursorInCanvas), Arrays.asList(new ExtensionDescription('\b', "Delete case", () -> {
            SwitchFrame parent = (SwitchFrame)this.getCursorBefore().getParentCanvas().getParent();
            parent.pullUpInnerCaseContents(this);
        }, false, ExtensionDescription.ExtensionSource.INSIDE_FIRST, new ExtensionDescription.ExtensionSource[0])));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animateProgress) {
        super.setView(oldView, newView, animateProgress);
        this.opening.setText(newView == Frame.View.JAVA_PREVIEW ? "" : "(");
        this.closing.setText(newView == Frame.View.JAVA_PREVIEW ? ":" : ")");
    }

    public List<Frame> getValidPulledStatements() {
        FilteredList contents = this.canvas.getBlockContents().filtered(f -> !(f instanceof BreakFrame));
        return new ArrayList<Frame>((Collection<Frame>)contents);
    }

    @Override
    public boolean isAlmostBlank() {
        return this.getEditableSlotsDirect().allMatch(EditableSlot::isAlmostBlank) && this.canvas.getBlockContents().stream().allMatch(f -> f instanceof BlankFrame || f instanceof BreakFrame);
    }
}

