/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.Config;
import bluej.compiler.Diagnostic;
import bluej.editor.fixes.Correction;
import bluej.editor.fixes.EditorFixesManager;
import bluej.editor.fixes.FixSuggestion;
import bluej.stride.framedjava.ast.ASTUtility;
import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.StringSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.frames.AssignFrame;
import bluej.stride.framedjava.frames.ClassFrame;
import bluej.stride.framedjava.frames.VarFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javafx.collections.ObservableList;
import threadchecker.OnThread;
import threadchecker.Tag;

public class UndeclaredVariableLvalueError
extends DirectSlotError {
    private final AssignFrame assignFrame;
    private final List<Correction> corrections = new ArrayList<Correction>();
    private final String varName;

    @OnThread(value=Tag.FXPlatform)
    public UndeclaredVariableLvalueError(StringSlotFragment slotFragment, AssignFrame assignFrame, Set<String> possibleCorrections) {
        super(slotFragment, Diagnostic.DiagnosticOrigin.STRIDE_LATE);
        this.assignFrame = assignFrame;
        this.corrections.addAll(Correction.winnowAndCreateCorrections((String)assignFrame.getLHS().getText(), possibleCorrections.stream().map(Correction.SimpleCorrectionInfo::new), correctionElements -> assignFrame.getLHS().setText(correctionElements.getPrimaryElement())));
        this.varName = assignFrame.getLHS().getText();
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getMessage() {
        return Config.getString("editor.quickfix.undeclaredVar.errorMsg") + this.varName;
    }

    public List<FixSuggestion> getFixSuggestions() {
        ArrayList<FixSuggestion> fixes = new ArrayList<FixSuggestion>();
        if (this.corrections != null) {
            fixes.addAll(this.corrections);
        }
        fixes.add((FixSuggestion)new EditorFixesManager.FixSuggestionBase(Config.getString("editor.quickfix.undeclaredVar.fixMsg.local"), () -> this.assignFrame.getParentCanvas().replaceBlock(this.assignFrame, new VarFrame(this.assignFrame.getEditor(), null, false, false, new TypeSlotFragment("", ""), new NameDefSlotFragment(this.assignFrame.getLHS().getText()), new FilledExpressionSlotFragment((ExpressionSlotFragment)this.assignFrame.getRHS().getSlotElement()), true))));
        fixes.add((FixSuggestion)new EditorFixesManager.FixSuggestionBase(Config.getString("editor.quickfix.undeclaredVar.fixMsg.class"), () -> {
            FrameCursor cursorAfter;
            ClassFrame classFrame = (ClassFrame)ASTUtility.getTopLevelElement(this.assignFrame.getCode()).getFrame();
            ObservableList<Frame> members = classFrame.getfieldsCanvas().getBlockContents();
            Optional<Frame> firstNonField = members.stream().filter(f -> !(f instanceof VarFrame)).findFirst();
            cursorAfter = firstNonField.isPresent() ? (cursorAfter = classFrame.getfieldsCanvas().getCursorBefore(firstNonField.get())) : classFrame.getfieldsCanvas().getLastCursor();
            classFrame.getfieldsCanvas().insertBlockBefore(new VarFrame(this.assignFrame.getEditor(), null, false, false, new TypeSlotFragment("", ""), new NameDefSlotFragment(this.assignFrame.getLHS().getText()), null, true), cursorAfter);
        }));
        return fixes;
    }

    @Override
    public boolean isJavaPos() {
        return false;
    }
}

