/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.editor.fixes.FixDisplayManager;
import bluej.editor.stride.CodeOverlayPane;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import javafx.beans.binding.DoubleExpression;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ErrorAndFixDisplay
extends FixDisplayManager {
    private static final Duration SHOW_DELAY = Duration.millis((double)400.0);
    private static final double SPACING = 5.0;
    private final InteractionManager editor;
    private final CodeError error;
    private final ErrorFixListener slot;
    private final VBox vbox = new VBox();
    private FXPlatformRunnable cancelShow;
    private boolean showing = false;

    public boolean isShowing() {
        return this.showing;
    }

    public ErrorAndFixDisplay(InteractionManager editor, CodeError err, ErrorFixListener slot) {
        this(editor, "", err, slot);
    }

    public ErrorAndFixDisplay(InteractionManager editor, String prefix, CodeError err, ErrorFixListener slot) {
        this.editor = editor;
        this.error = err;
        this.slot = slot;
        this.vbox.setOnMousePressed(Event::consume);
        TextFlow errorLabel = null;
        if (!(err instanceof DirectSlotError) || err instanceof DirectSlotError && (((DirectSlotError)err).getItalicMessageStartIndex() == -1 || ((DirectSlotError)err).getItalicMessageEndIndex() == -1)) {
            errorLabel = new TextFlow(new Node[]{new Label(prefix + err.getMessage())});
        } else {
            DirectSlotError dsError = (DirectSlotError)err;
            Label beforeItalicText = dsError.getItalicMessageStartIndex() > 0 ? new Label(dsError.getMessage().substring(0, dsError.getItalicMessageStartIndex())) : new Label("");
            Label italicText = new Label(dsError.getMessage().substring(dsError.getItalicMessageStartIndex(), dsError.getItalicMessageEndIndex()));
            JavaFXUtil.withStyleClass(italicText, "error-fix-display-italic");
            Label afterItalicText = dsError.getItalicMessageEndIndex() < dsError.getMessage().length() - 1 ? new Label(dsError.getMessage().substring(dsError.getItalicMessageEndIndex())) : new Label("");
            errorLabel = new TextFlow(new Node[]{beforeItalicText, italicText, afterItalicText});
        }
        JavaFXUtil.addStyleClass((Styleable)errorLabel, "error-label");
        this.vbox.getChildren().add((Object)errorLabel);
        this.prepareFixDisplay(this.vbox, err.getFixSuggestions(), () -> editor.getFrameEditor().getWatcher(), err.getIdentifier());
        CodeOverlayPane.setDropShadow((Node)this.vbox);
    }

    public CodeError getError() {
        return this.error;
    }

    @OnThread(value=Tag.FXPlatform)
    public void showAbove(Region n, Duration delay) {
        if (this.cancelShow != null) {
            this.cancelShow.run();
            this.cancelShow = null;
        }
        this.cancelShow = JavaFXUtil.runAfter(delay, () -> {
            this.editor.getCodeOverlayPane().addOverlay((Node)this.vbox, (Node)n, null, (DoubleExpression)this.vbox.heightProperty().negate().subtract(5.0), CodeOverlayPane.WidthLimit.LIMIT_WIDTH_AND_SLIDE_LEFT);
            this.vbox.toBack();
            this.error.focusedProperty().set(true);
            this.showing = true;
            this.recordShow(() -> this.editor.getFrameEditor().getWatcher());
        });
    }

    @OnThread(value=Tag.FXPlatform)
    public void showAbove(Region n) {
        this.showAbove(n, SHOW_DELAY);
    }

    @OnThread(value=Tag.FXPlatform)
    public void showBelow(Region n) {
        this.showBelow(n, SHOW_DELAY);
    }

    @OnThread(value=Tag.FXPlatform)
    public void showBelow(Region n, Duration delay) {
        if (this.cancelShow != null) {
            this.cancelShow.run();
            this.cancelShow = null;
        }
        this.cancelShow = JavaFXUtil.runAfter(delay, () -> {
            this.editor.getCodeOverlayPane().addOverlay((Node)this.vbox, (Node)n, null, (DoubleExpression)n.heightProperty().add(5.0), CodeOverlayPane.WidthLimit.LIMIT_WIDTH_AND_SLIDE_LEFT);
            this.vbox.toBack();
            this.error.focusedProperty().set(true);
            this.showing = true;
            this.recordShow(() -> this.editor.getFrameEditor().getWatcher());
        });
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void hide() {
        if (this.cancelShow != null) {
            this.cancelShow.run();
            this.cancelShow = null;
        }
        this.editor.getCodeOverlayPane().removeOverlay((Node)this.vbox);
        this.error.focusedProperty().set(false);
        this.showing = false;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected void postFixError() {
        this.slot.fixedError(this.error);
    }

    @OnThread(value=Tag.FXPlatform)
    public void executeSelected() {
        if (this.highlighted != -1) {
            this.recordExecute(() -> this.editor.getFrameEditor().getWatcher(), this.highlighted);
            this.error.getFixSuggestions().get(this.highlighted).execute();
            this.hide();
            this.slot.fixedError(this.error);
        }
    }

    public static interface ErrorFixListener {
        @OnThread(value=Tag.FXPlatform)
        public void fixedError(CodeError var1);
    }
}

