/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.ErrorShower;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.Frame;
import bluej.stride.slots.EditableSlot;
import java.security.InvalidParameterException;
import java.util.stream.Stream;
import threadchecker.OnThread;
import threadchecker.Tag;

public class FrameFragment
extends JavaFragment {
    private Frame frame;
    private final String content;
    private final CodeElement element;

    public FrameFragment(Frame frame, CodeElement src, String content) {
        this.frame = frame;
        this.content = content;
        this.element = src;
        if (content == null) {
            throw new InvalidParameterException("FrameFragment content cannot be null");
        }
        if (content.contains("\n")) {
            throw new IllegalStateException("FrameFragment content contains newline");
        }
    }

    @Override
    protected String getJavaCode(JavaFragment.Destination dest, ExpressionSlot<?> completing, Parser.DummyNameGenerator dummyNameGenerator) {
        return this.content;
    }

    @Override
    public Stream<SyntaxCodeError> findEarlyErrors() {
        return Stream.empty();
    }

    @Override
    public void addError(CodeError codeError) {
        this.frame.addError(codeError);
    }

    @Override
    public JavaFragment.ErrorRelation checkCompileError(int startLine, int startColumn, int endLine, int endColumn) {
        if (this.frame == null) {
            return JavaFragment.ErrorRelation.CANNOT_SHOW;
        }
        JavaFragment.ErrorRelation errorRelation = super.checkCompileError(startLine, startColumn, endLine, endColumn);
        if (errorRelation == JavaFragment.ErrorRelation.OVERLAPS_FRAGMENT) {
            return JavaFragment.ErrorRelation.OVERLAPS_FRAGMENT_FALLBACK;
        }
        return errorRelation;
    }

    @Override
    @OnThread(value=Tag.FX)
    protected JavaFragment getCompileErrorRedirect() {
        EditableSlot slot = this.frame.getErrorShowRedirect();
        if (slot != null) {
            return slot.getSlotElement();
        }
        return this;
    }

    @Override
    @OnThread(value=Tag.FX)
    public ErrorShower getErrorShower() {
        EditableSlot slot = this.frame.getErrorShowRedirect();
        if (slot != null) {
            return slot;
        }
        return this.frame;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public CodeElement getElement() {
        return this.element;
    }
}

