/*
 * Decompiled with CFR 0.152.
 */
package bluej.runtime;

import bluej.Config;
import bluej.runtime.BJInputStream;
import bluej.runtime.BJMap;
import bluej.runtime.UnitTestExtension;
import bluej.utility.Utility;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.embed.swing.JFXPanel;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ExecServer {
    public static final String MAIN_THREAD_NAME = "mainThread";
    public static Thread mainThread = null;
    public static final String WORKER_THREAD_NAME = "workerThread";
    public static Thread workerThread = null;
    public static final int RUN_ON_DEFAULT_THREAD = 0;
    public static final int RUN_ON_FX_THREAD = 1;
    public static final int RUN_ON_SWING_THREAD = 2;
    public static final int RUN_ON_CUSTOM_THREAD = 3;
    public static int threadToRunOn = 0;
    private static Consumer<Runnable> customThreadRunner;
    public static String classToRun;
    public static String methodToRun;
    public static String[] parameterTypes;
    public static Object[] arguments;
    public static int execAction;
    public static Object methodReturn;
    public static Class<?> executedClass;
    public static Throwable exception;
    public static final String RUN_ON_THREAD_NAME = "threadToRunOn";
    public static final String CLASS_TO_RUN_NAME = "classToRun";
    public static final String METHOD_TO_RUN_NAME = "methodToRun";
    public static final String PARAMETER_TYPES_NAME = "parameterTypes";
    public static final String ARGUMENTS_NAME = "arguments";
    public static final String EXEC_ACTION_NAME = "execAction";
    public static final String METHOD_RETURN_NAME = "methodReturn";
    public static final String EXCEPTION_NAME = "exception";
    public static final String EXECUTED_CLASS_NAME = "executedClass";
    public static final int EXEC_SHELL = 0;
    public static final int TEST_SETUP = 1;
    public static final int TEST_RUN = 2;
    public static final int DISPOSE_WINDOWS = 3;
    public static final int EXIT_VM = 4;
    public static final int LOAD_INIT_CLASS = 5;
    public static final int INSTANTIATE_CLASS = 6;
    public static final int INSTANTIATE_CLASS_ARGS = 7;
    public static final int LAUNCH_FX_APP = 8;
    public static int workerAction;
    public static String objectName;
    public static Object object;
    public static String classPath;
    public static String className;
    public static String scopeId;
    public static ClassLoader classLoader;
    public static Object workerReturn;
    public static final String WORKER_ACTION_NAME = "workerAction";
    public static final String OBJECTNAME_NAME = "objectName";
    public static final String OBJECT_NAME = "object";
    public static final String CLASSPATH_NAME = "classPath";
    public static final String CLASSNAME_NAME = "className";
    public static final String WORKER_RETURN_NAME = "workerReturn";
    public static final String SCOPE_ID_NAME = "scopeId";
    public static final String CLASSLOADER_NAME = "classLoader";
    public static final int REMOVE_OBJECT = 0;
    public static final int ADD_OBJECT = 1;
    public static final int LOAD_CLASS = 2;
    public static final int NEW_LOADER = 3;
    public static final int LOAD_ALL = 5;
    private static ClassLoader currentLoader;
    private static Map<String, BJMap<String, Object>> objectMaps;
    private static List<java.awt.Window> openWindows;
    private static boolean disposingAllWindows;

    public static void main(String[] args) throws Throwable {
        System.setIn(new BJInputStream(System.in));
        if (args.length > 0 && !args[0].equals("")) {
            try {
                System.setOut(new PrintStream((OutputStream)System.out, true, args[0]));
                System.setErr(new PrintStream((OutputStream)System.err, true, args[0]));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        workerThread = new Thread("BlueJ worker thread"){

            @Override
            public void run() {
                while (true) {
                    ExecServer.vmSuspend();
                    switch (workerAction) {
                        case 1: {
                            ExecServer.addObject(scopeId, objectName, object);
                            object = null;
                            break;
                        }
                        case 0: {
                            ExecServer.removeObject(scopeId, objectName);
                            break;
                        }
                        case 2: {
                            try {
                                if (classLoader == null) {
                                    classLoader = currentLoader;
                                }
                                workerReturn = Class.forName(className, false, currentLoader);
                                ((Class)workerReturn).getFields();
                                classLoader = null;
                            }
                            catch (Throwable cnfe) {
                                workerReturn = null;
                            }
                            break;
                        }
                        case 3: {
                            workerReturn = ExecServer.newLoader(classPath);
                            break;
                        }
                        case 4: {
                            System.exit(0);
                        }
                        case 5: {
                            workerReturn = ExecServer.loadAllClasses(className);
                        }
                    }
                    workerAction = 4;
                }
            }
        };
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        AWTEventListener listener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                Object source = event.getSource();
                if (event.getID() == 200) {
                    if (source instanceof java.awt.Window) {
                        ExecServer.addWindow((java.awt.Window)source);
                        Utility.bringToFront((java.awt.Window)source);
                    }
                } else if (event.getID() == 202 && source instanceof java.awt.Window) {
                    ExecServer.removeWindow((java.awt.Window)source);
                }
            }
        };
        toolkit.addAWTEventListener(listener, 64L);
        ExecServer.newThread();
        workerThread.setPriority(10);
        workerThread.start();
    }

    public static void vmStarted() {
    }

    public static void vmSuspend() {
    }

    public static void showTerminalOnInput() {
    }

    private static void addWindow(java.awt.Window o) {
        openWindows.add(o);
    }

    private static void removeWindow(java.awt.Window o) {
        if (!disposingAllWindows) {
            openWindows.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BJMap<String, Object> getScope(String scopeId) {
        Map<String, BJMap<String, Object>> map = objectMaps;
        synchronized (map) {
            BJMap<String, Object> m = objectMaps.get(scopeId);
            if (m == null) {
                m = new BJMap();
                objectMaps.put(scopeId, m);
            }
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader newLoader(String urlListAsString) {
        String[] splits = urlListAsString.split("\n");
        URL[] urls = new URL[splits.length];
        for (int index = 0; index < splits.length; ++index) {
            try {
                urls[index] = new URL(splits[index]);
                continue;
            }
            catch (MalformedURLException mfue) {
                System.err.println("ExecServer.newLoader() Malformed URL=" + splits[index]);
            }
        }
        currentLoader = new URLClassLoader(urls);
        Map<String, BJMap<String, Object>> map = objectMaps;
        synchronized (map) {
            objectMaps.clear();
        }
        return currentLoader;
    }

    public static Class<?> loadAndInitClass(String className) {
        Class<?> cl;
        Throwable exception = null;
        try {
            cl = Class.forName(className, true, currentLoader);
        }
        catch (ClassNotFoundException cnfe) {
            cl = null;
        }
        catch (ExceptionInInitializerError eiie) {
            exception = eiie.getCause();
            try {
                cl = Class.forName(className, false, currentLoader);
            }
            catch (ClassNotFoundException cnfe) {
                cl = null;
            }
        }
        catch (Throwable err) {
            exception = err;
            try {
                cl = Class.forName(className, false, currentLoader);
            }
            catch (Throwable t) {
                cl = null;
            }
        }
        if (exception != null) {
            String stClassName;
            int i;
            StackTraceElement[] stackTrace = exception.getStackTrace();
            for (i = stackTrace.length - 1; i > 0 && ((stClassName = stackTrace[i].getClassName()).startsWith("bluej.runtime.ExecServer") || stClassName.startsWith("java.lang.Class")); --i) {
            }
            StackTraceElement[] newStackTrace = new StackTraceElement[i + 1];
            System.arraycopy(stackTrace, 0, newStackTrace, 0, i + 1);
            exception.setStackTrace(newStackTrace);
            ExecServer.recordException(exception);
        }
        return cl;
    }

    private static Class<?>[] loadAllClasses(String className) {
        ArrayList l = new ArrayList();
        try {
            Class<?> c = currentLoader.loadClass(className);
            c.getFields();
            l.add(c);
            ExecServer.getDeclaredInnerClasses(c, l);
            int i = 1;
            while (true) {
                c = currentLoader.loadClass(className + "$" + i);
                c.getFields();
                l.add(c);
                ++i;
            }
        }
        catch (Throwable throwable) {
            return l.toArray(new Class[l.size()]);
        }
    }

    private static void getDeclaredInnerClasses(Class<?> c, List<Class<?>> list) {
        try {
            Class<?>[] rlist = c.getDeclaredClasses();
            for (int i = 0; i < rlist.length; ++i) {
                c = rlist[i];
                c.getFields();
                list.add(rlist[i]);
                ExecServer.getDeclaredInnerClasses(rlist[i], list);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addObject(String scopeId, String instanceName, Object value) {
        BJMap<String, Object> scope;
        BJMap<String, Object> bJMap = scope = ExecServer.getScope(scopeId);
        synchronized (bJMap) {
            scope.put(instanceName, value);
            scope.notify();
        }
    }

    private static Object[] runTestSetUp(String className) {
        Class<?> cl = ExecServer.loadAndInitClass(className);
        try {
            Method setUpMethod;
            Object testCase = null;
            Class[] partypes = new Class[]{String.class};
            try {
                Constructor<?> ct = cl.getConstructor(partypes);
                Object[] arglist = new Object[]{"TestCase " + className};
                testCase = ct.newInstance(arglist);
            }
            catch (NoSuchMethodException nsme) {
                testCase = null;
            }
            if (testCase == null) {
                testCase = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if ((setUpMethod = ExecServer.findMethod(cl, "setUp", null)) != null) {
                setUpMethod.setAccessible(true);
                setUpMethod.invoke(testCase, (Object[])null);
            }
            Field[] fields = cl.getDeclaredFields();
            Object[] obs = new Object[fields.length * 2 + 1];
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                obs[i * 2] = fields[i].getName();
                obs[i * 2 + 1] = fields[i].get(testCase);
            }
            obs[obs.length - 1] = testCase;
            return obs;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new Object[0];
        }
    }

    private static Method findMethod(Class<?> cl, String name, Class<?>[] paramtypes) {
        while (cl != null) {
            try {
                return cl.getDeclaredMethod(name, paramtypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                cl = cl.getSuperclass();
            }
        }
        return null;
    }

    private static Object[] runTestMethod(String className, String methodName) {
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{methodName != null ? DiscoverySelectors.selectMethod((String)(className + "#" + methodName)) : DiscoverySelectors.selectClass((String)className)}).configurationParameter("junit.jupiter.extensions.autodetection.enabled", "true").build();
        ServiceLoader.load(InvocationInterceptor.class);
        Launcher launcher = LauncherFactory.create();
        TestRecorder recorder = new TestRecorder();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{recorder});
        launcher.execute(request, new TestExecutionListener[0]);
        return Stream.concat(Stream.of(String.valueOf(recorder.getExecutionRunTime())), recorder.testDetails.stream().flatMap(t -> Arrays.stream(t))).toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeObject(String scopeId, String instanceName) {
        BJMap<String, Object> scope;
        BJMap<String, Object> bJMap = scope = ExecServer.getScope(scopeId);
        synchronized (bJMap) {
            scope.remove(instanceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disposeWindows() {
        List<java.awt.Window> list = openWindows;
        synchronized (list) {
            disposingAllWindows = true;
            Iterator<java.awt.Window> it = openWindows.iterator();
            while (it.hasNext()) {
                it.next().dispose();
            }
            openWindows.clear();
            disposingAllWindows = false;
        }
    }

    private static void clearInputBuffer() {
        try {
            int n = System.in.available();
            while (n != 0) {
                System.in.skip(n);
                n = System.in.available();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void newThread() {
        final Thread oldThread = mainThread;
        mainThread = new Thread("main"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    if (oldThread != null) {
                        oldThread.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ExecServer.vmStarted();
                methodReturn = null;
                exception = null;
                Thread.currentThread().setContextClassLoader(currentLoader);
                try {
                    switch (execAction) {
                        case 0: {
                            methodReturn = null;
                            executedClass = null;
                            ExecServer.clearInputBuffer();
                            Class<?> c = currentLoader.loadClass(classToRun);
                            executedClass = c;
                            Method m = c.getMethod("run", new Class[0]);
                            ExecServer.runOnTargetThread(() -> {
                                try {
                                    methodReturn = m.invoke(null, new Object[0]);
                                }
                                catch (InvocationTargetException ite) {
                                    throw ite.getCause();
                                }
                            });
                            return;
                        }
                        case 6: {
                            ExecServer.clearInputBuffer();
                            Class<?> c = currentLoader.loadClass(classToRun);
                            Constructor<?> cons = c.getDeclaredConstructor(new Class[0]);
                            cons.setAccessible(true);
                            ExecServer.runOnTargetThread(() -> {
                                try {
                                    methodReturn = cons.newInstance(null);
                                }
                                catch (InvocationTargetException ite) {
                                    throw ite.getCause();
                                }
                            });
                            return;
                        }
                        case 7: {
                            ExecServer.clearInputBuffer();
                            Class<?> c = currentLoader.loadClass(classToRun);
                            Class[] paramClasses = new Class[parameterTypes.length];
                            int i = 0;
                            while (true) {
                                if (i >= parameterTypes.length) {
                                    Constructor<?> cons = c.getDeclaredConstructor(paramClasses);
                                    cons.setAccessible(true);
                                    ExecServer.runOnTargetThread(() -> {
                                        try {
                                            methodReturn = cons.newInstance(arguments);
                                        }
                                        catch (InvocationTargetException ite) {
                                            throw ite.getCause();
                                        }
                                    });
                                    return;
                                }
                                if (classLoader == null) {
                                    classLoader = currentLoader;
                                }
                                paramClasses[i] = Class.forName(parameterTypes[i], false, currentLoader);
                                ++i;
                            }
                        }
                        case 8: {
                            CompletableFuture theApp = new CompletableFuture();
                            new Thread(() -> {
                                FXPreloader.theApp = theApp;
                                System.setProperty("javafx.preloader", FXPreloader.class.getName());
                                Application.launch(ExecServer.loadAndInitClass(classToRun), (String[])new String[0]);
                            }, "JavaFX BlueJ Helper").start();
                            try {
                                methodReturn = theApp.get(3000L, TimeUnit.MILLISECONDS);
                                return;
                            }
                            catch (InterruptedException | ExecutionException | TimeoutException e) {
                                methodReturn = null;
                                return;
                            }
                        }
                        case 1: {
                            methodReturn = ExecServer.runTestSetUp(classToRun);
                            return;
                        }
                        case 2: {
                            methodReturn = ExecServer.runTestMethod(classToRun, methodToRun);
                            return;
                        }
                        case 3: {
                            ExecServer.disposeWindows();
                            return;
                        }
                        case 5: {
                            try {
                                methodReturn = ExecServer.loadAndInitClass(classToRun);
                                return;
                            }
                            catch (Throwable cnfe) {
                                methodReturn = null;
                                return;
                            }
                        }
                        case 4: {
                            System.exit(0);
                            return;
                        }
                    }
                    return;
                }
                catch (Throwable t) {
                    ExecServer.recordException(t);
                    return;
                }
                finally {
                    execAction = 4;
                    ExecServer.newThread();
                }
            }
        };
        mainThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runOnTargetThread(RunnableThrows runnable) throws Throwable {
        Class<ExecServer> clazz = ExecServer.class;
        synchronized (ExecServer.class) {
            int theThreadToRunOn = threadToRunOn;
            Consumer<Runnable> theCustomThreadRunner = customThreadRunner;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (theThreadToRunOn == 0) {
                runnable.run();
            } else {
                CompletableFuture f = new CompletableFuture();
                Runnable wrapped = () -> {
                    try {
                        runnable.run();
                        f.complete(Optional.empty());
                    }
                    catch (Throwable t) {
                        f.complete(Optional.of(t));
                    }
                };
                if (theThreadToRunOn == 1) {
                    SwingUtilities.invokeAndWait(() -> new JFXPanel());
                    Platform.runLater((Runnable)wrapped);
                } else if (theThreadToRunOn == 2) {
                    SwingUtilities.invokeLater(wrapped);
                } else if (theThreadToRunOn == 3 && theCustomThreadRunner != null) {
                    theCustomThreadRunner.accept(wrapped);
                }
                Optional t = (Optional)f.get();
                if (t.isPresent()) {
                    throw (Throwable)t.get();
                }
            }
            return;
        }
    }

    private static void recordException(Throwable t) {
        int i;
        exception = t;
        StackTraceElement[] stackTrace = t.getStackTrace();
        for (i = 0; i < stackTrace.length && !stackTrace[i].getClassName().startsWith("__SHELL"); ++i) {
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[i];
        System.arraycopy(stackTrace, 0, newStackTrace, 0, i);
        t.setStackTrace(newStackTrace);
        t.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObject(String instanceName) {
        BJMap<String, Object> m = ExecServer.getScope(scopeId);
        Object rval = null;
        try {
            BJMap<String, Object> bJMap = m;
            synchronized (bJMap) {
                rval = m.get(instanceName);
                if (rval == null) {
                    m.wait();
                    rval = m.get(instanceName);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return rval;
    }

    public static BJMap<String, Object> getObjectMap() {
        return ExecServer.getScope(scopeId);
    }

    public static synchronized void setCustomRunOnThread(Consumer<Runnable> customThreadRunner) {
        threadToRunOn = 3;
        ExecServer.customThreadRunner = customThreadRunner;
    }

    public static ClassLoader getCurrentClassLoader() {
        return currentLoader;
    }

    static {
        execAction = -1;
        workerAction = 4;
        classLoader = null;
        objectMaps = new HashMap<String, BJMap<String, Object>>();
        openWindows = Collections.synchronizedList(new LinkedList());
        disposingAllWindows = false;
    }

    public static class FXPreloader
    extends Preloader {
        public static CompletableFuture<Application> theApp;

        @OnThread(value=Tag.FXPlatform)
        public void start(Stage primaryStage) throws Exception {
            Window.getWindows().addListener(c -> {
                boolean anyAdded = false;
                while (c.next()) {
                    anyAdded |= c.wasAdded();
                }
                if (anyAdded && Config.isMacOS()) {
                    Utility.appToFront();
                }
            });
        }

        public void handleStateChangeNotification(Preloader.StateChangeNotification info) {
            super.handleStateChangeNotification(info);
            switch (info.getType()) {
                case BEFORE_START: {
                    theApp.complete(info.getApplication());
                }
            }
        }
    }

    private static interface RunnableThrows {
        public void run() throws Throwable;
    }

    private static class TestRecorder
    implements TestExecutionListener {
        private final List<Object[]> testDetails = new ArrayList<Object[]>();
        private long executionStartTime;
        private long executionRunTime = -1L;

        private TestRecorder() {
        }

        public void testPlanExecutionStarted(TestPlan testPlan) {
            this.executionStartTime = System.currentTimeMillis();
        }

        public void testPlanExecutionFinished(TestPlan testPlan) {
            this.executionRunTime = System.currentTimeMillis() - this.executionStartTime;
        }

        public long getExecutionRunTime() {
            return this.executionRunTime;
        }

        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            if (testIdentifier.isTest()) {
                Object[] r = new Object[9];
                r[0] = testIdentifier.getLegacyReportingName().contains("(") ? testIdentifier.getLegacyReportingName().substring(0, testIdentifier.getLegacyReportingName().lastIndexOf(40) + 1) + String.join((CharSequence)", ", UnitTestExtension.getArgsAsStrList()) + ")" : testIdentifier.getLegacyReportingName() + "()";
                Object object = r[1] = testIdentifier.getDisplayName() != null ? testIdentifier.getDisplayName() : "";
                if (testExecutionResult.getStatus() == TestExecutionResult.Status.SUCCESSFUL) {
                    r[7] = "";
                    r[6] = "";
                    r[5] = "";
                    r[4] = "";
                    r[3] = "";
                    r[2] = "";
                    r[8] = "success";
                } else {
                    r[8] = testExecutionResult.getThrowable().isPresent() && AssertionError.class.isAssignableFrom(((Throwable)testExecutionResult.getThrowable().get()).getClass()) ? "failure" : "error";
                    if (testExecutionResult.getThrowable().isPresent()) {
                        int k;
                        Throwable throwableRes = (Throwable)testExecutionResult.getThrowable().get();
                        r[2] = throwableRes.getMessage() != null ? throwableRes.getMessage() : "no exception message";
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        throwableRes.printStackTrace(pw);
                        r[3] = throwableRes.getStackTrace().length > 0 ? sw.toString() : "no trace";
                        StackTraceElement[] ste = throwableRes.getStackTrace();
                        for (k = 0; k < ste.length && ste[k].getClassName().startsWith("org.junit."); ++k) {
                        }
                        r[4] = ste[k].getClassName();
                        r[5] = ste[k].getFileName();
                        r[6] = ste[k].getMethodName();
                        r[7] = String.valueOf(ste[k].getLineNumber());
                    } else {
                        r[7] = "";
                        r[6] = "";
                        r[5] = "";
                        r[4] = "";
                        r[3] = "";
                        r[2] = "";
                    }
                }
                this.testDetails.add(r);
            }
        }
    }
}

