/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.target.Target;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Properties;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PackageTarget
extends Target {
    static final int MIN_WIDTH = 60;
    static final int MIN_HEIGHT = 40;
    private static final int TAB_HEIGHT = 12;
    static final String openStr = Config.getString("pkgmgr.packagemenu.open");
    static final String removeStr = Config.getString("pkgmgr.packagemenu.remove");

    public PackageTarget(Package pkg, String baseName) {
        super(pkg, baseName, "Package");
        JavaFXUtil.addStyleClass((Styleable)this.pane, "package-target");
        Label name = new Label(baseName);
        JavaFXUtil.addStyleClass((Styleable)name, "package-target-name");
        name.setMaxWidth(9999.0);
        this.pane.setTop((Node)name);
        this.setSize(PackageTarget.calculateWidth((Labeled)name, baseName, 120), 82);
        Pane center = new Pane();
        BorderPane centerWrapper = new BorderPane((Node)center);
        this.pane.setCenter((Node)centerWrapper);
        JavaFXUtil.addStyleClass((Styleable)centerWrapper, "package-target-preview-wrapper");
        JavaFXUtil.addStyleClass((Styleable)center, "package-target-preview");
        double[] pos = new double[]{0.25, 0.5, 0.75, 0.2, 0.6, 0.8};
        for (int i = 0; i < 3; ++i) {
            Pane r = new Pane();
            r.setMouseTransparent(true);
            r.prefWidthProperty().bind((ObservableValue)center.widthProperty().multiply(0.2));
            r.prefHeightProperty().bind((ObservableValue)center.heightProperty().multiply(0.2));
            r.layoutXProperty().bind((ObservableValue)center.widthProperty().multiply(pos[i * 2 + 0] - 0.1));
            r.layoutYProperty().bind((ObservableValue)center.heightProperty().multiply(pos[i * 2 + 1] - 0.1));
            JavaFXUtil.addStyleClass((Styleable)r, "package-target-preview-item");
            center.getChildren().add((Object)r);
        }
    }

    @OnThread(value=Tag.Any)
    public String getBaseName() {
        return this.getIdentifierName();
    }

    public String getQualifiedName() {
        return this.getOpenPkgName();
    }

    @Override
    public void load(Properties props, String prefix) throws NumberFormatException {
        super.load(props, prefix);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        props.put(prefix + ".type", "PackageTarget");
    }

    public void deleteFiles() {
        this.deleteDir(new File(this.getPackage().getPath(), this.getBaseName()));
    }

    private void deleteDir(File directory) {
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            try {
                directory.delete();
            }
            catch (SecurityException se) {
                Debug.message("Trouble deleting: " + directory + se);
            }
        } else if (this.getPackage().getProject().prepareDeleteDir(directory)) {
            for (int i = 0; i < Array.getLength(fileList); ++i) {
                this.deleteDir(fileList[i]);
            }
            directory.delete();
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void doubleClick(boolean openInNewWindow) {
        this.getPackage().getEditor().openPackage(this.getOpenPkgName());
    }

    @Override
    public List<? extends AbstractOperation<Target>> getContextOperations() {
        if (this.isRemovable()) {
            return List.of(new OpenPkgAction(), new RemovePkgAction());
        }
        return List.of(new OpenPkgAction());
    }

    @OnThread(value=Tag.Any)
    protected boolean isRemovable() {
        return true;
    }

    @OnThread(value=Tag.Any)
    protected String getOpenPkgName() {
        return this.getPackage().getQualifiedName(this.getBaseName());
    }

    @Override
    public void remove() {
        if (!this.isRemovable()) {
            return;
        }
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(this.getPackage());
        String name = this.getQualifiedName();
        PkgMgrFrame[] f = PkgMgrFrame.getAllProjectFrames(pmf.getProject(), name);
        if (f != null) {
            DialogManager.showErrorFX((Window)pmf.getWindow(), "remove-package-open");
        } else {
            int response = DialogManager.askQuestionFX((Window)pmf.getWindow(), "really-remove-package");
            if (response == 0) {
                this.deleteFiles();
                this.getPackage().getProject().removePackage(this.getQualifiedName());
                this.getPackage().removeTarget(this);
            }
        }
    }

    public void removeImmediate() {
        this.deleteFiles();
        this.getPackage().removeTarget(this);
        this.getPackage().getProject().removePackage(this.getQualifiedName());
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setSize(int width, int height) {
        super.setSize(Math.max(width, 60), Math.max(height, 40));
    }

    private static class RemovePkgAction
    extends AbstractOperation<Target> {
        public RemovePkgAction() {
            super("removePkg", AbstractOperation.Combine.ALL, null);
        }

        @Override
        public void activate(List<Target> targets) {
            for (Target target : targets) {
                if (!(target instanceof PackageTarget)) continue;
                ((PackageTarget)target).remove();
            }
        }

        @Override
        public List<AbstractOperation.ItemLabel> getLabels() {
            return List.of(new AbstractOperation.ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(removeStr), AbstractOperation.MenuItemOrder.REMOVE));
        }
    }

    private static class OpenPkgAction
    extends AbstractOperation<Target> {
        public OpenPkgAction() {
            super("openPkg", AbstractOperation.Combine.ALL, null);
        }

        @Override
        public void activate(List<Target> targets) {
            for (Target target : targets) {
                if (!(target instanceof PackageTarget)) continue;
                PackageTarget packageTarget = (PackageTarget)target;
                packageTarget.getPackage().getEditor().openPackage(packageTarget.getOpenPkgName());
            }
        }

        @Override
        public List<AbstractOperation.ItemLabel> getLabels() {
            return List.of(new AbstractOperation.ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(openStr), AbstractOperation.MenuItemOrder.EDIT));
        }
    }
}

