/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.collect.DiagnosticWithShown;
import bluej.collect.StrideEditReason;
import bluej.compiler.CompileInputFile;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.Diagnostic;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerResult;
import bluej.debugger.RunOnThread;
import bluej.debugger.gentype.Reflective;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.editor.Editor;
import bluej.editor.EditorWatcher;
import bluej.editor.TextEditor;
import bluej.editor.flow.FlowEditor;
import bluej.editor.stride.FrameCatalogue;
import bluej.editor.stride.FrameEditor;
import bluej.extensions2.BClass;
import bluej.extensions2.ExtensionBridge;
import bluej.extensions2.SourceType;
import bluej.extensions2.event.ClassEvent;
import bluej.extensions2.event.ExtensionEvent;
import bluej.extmgr.ExtensionsManager;
import bluej.parser.ParseFailure;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.PackageResolver;
import bluej.parser.entity.ParsedReflective;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.ParsedTypeNode;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.DuplicateClassDialog;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.ProjectUtils;
import bluej.pkgmgr.SourceInfo;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.actions.ClassTargetOperation;
import bluej.pkgmgr.target.actions.CompileAction;
import bluej.pkgmgr.target.actions.ConvertToJavaAction;
import bluej.pkgmgr.target.actions.ConvertToStrideAction;
import bluej.pkgmgr.target.actions.DuplicateClassAction;
import bluej.pkgmgr.target.actions.EditAction;
import bluej.pkgmgr.target.actions.EditableTargetOperation;
import bluej.pkgmgr.target.actions.InspectAction;
import bluej.pkgmgr.target.actions.RemoveClassAction;
import bluej.pkgmgr.target.role.AbstractClassRole;
import bluej.pkgmgr.target.role.ClassRole;
import bluej.pkgmgr.target.role.EnumClassRole;
import bluej.pkgmgr.target.role.InterfaceClassRole;
import bluej.pkgmgr.target.role.StdClassRole;
import bluej.pkgmgr.target.role.UnitTestClassRole;
import bluej.prefmgr.PrefMgr;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.convert.ConversionWarning;
import bluej.stride.framedjava.convert.ConvertResultDialog;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.TopLevelCodeElement;
import bluej.stride.generic.Frame;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileEditor;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import bluej.utility.Utility;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ResizableCanvas;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import junit.framework.TestCase;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ClassTarget
extends DependentTarget
implements InvokeListener {
    static final int MIN_WIDTH = 60;
    static final int MIN_HEIGHT = 30;
    public static final String compileStr = Config.getString("pkgmgr.classmenu.compile");
    public static final String inspectStr = Config.getString("pkgmgr.classmenu.inspect");
    public static final String convertToJavaStr = Config.getString("pkgmgr.classmenu.convertToJava");
    public static final String convertToStrideStr = Config.getString("pkgmgr.classmenu.convertToStride");
    public static final String duplicateClassStr = Config.getString("pkgmgr.classmenu.duplicate");
    public static final String createTestStr = Config.getString("pkgmgr.classmenu.createTest");
    private static final String launchFXStr = Config.getString("pkgmgr.classmenu.launchFX");
    private static final String STEREOTYPE_OPEN = "\u00ab";
    private static final String STEREOTYPE_CLOSE = "\u00bb";
    private static String TEMP_FILE_EXTENSION = "-temp";
    private ClassRole role = new StdClassRole();
    private boolean openWithInterface = false;
    private SourceInfo sourceInfo = new SourceInfo();
    private boolean isAbstract;
    private Optional<Boolean> isNaviviewExpanded = Optional.empty();
    private final List<Integer> cachedBreakpoints = new ArrayList<Integer>();
    private boolean analysing = false;
    private boolean compilationInvalid = false;
    private SourceType sourceAvailable;
    private boolean hasBeenOpened = false;
    private String typeParameters = "";
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean recordedAsOpen = false;
    private boolean visible = true;
    private static String[] pseudos;
    private Label stereotypeLabel;
    private boolean isFront = true;
    private static @OnThread(value=Tag.FX) Image greyStripeImage;
    private static @OnThread(value=Tag.FX) Image redStripeImage;
    private static final int GREY_STRIPE_SEPARATION = 12;
    private static final int RED_STRIPE_SEPARATION = 16;
    private static final int STRIPE_THICKNESS = 3;
    private static final @OnThread(value=Tag.FX) Color RED_STRIPE;
    private static final @OnThread(value=Tag.FX) Color GREY_STRIPE;
    private boolean showingInterface;
    private boolean drawingExtends = false;
    private Label nameLabel;
    private Label noSourceLabel;
    protected @OnThread(value=Tag.FX) ResizableCanvas canvas;
    private BClass singleBClass;

    public ClassTarget(Package pkg, String baseName) {
        this(pkg, baseName, null);
    }

    public ClassTarget(Package pkg, String baseName, String template) {
        super(pkg, baseName, "Class");
        if (pseudos == null) {
            pseudos = Utility.mapList(Arrays.asList(StdClassRole.class, UnitTestClassRole.class, AbstractClassRole.class, InterfaceClassRole.class, EnumClassRole.class), ClassTarget::pseudoFor).toArray(new String[0]);
        }
        JavaFXUtil.addStyleClass((Styleable)this.pane, "class-target");
        JavaFXUtil.addStyleClass((Styleable)this.pane, "class-target-id-" + baseName);
        this.nameLabel = new Label(baseName);
        JavaFXUtil.addStyleClass((Styleable)this.nameLabel, "class-target-name");
        this.nameLabel.setMaxWidth(9999.0);
        this.stereotypeLabel = new Label();
        this.stereotypeLabel.setMaxWidth(9999.0);
        this.stereotypeLabel.visibleProperty().bind((ObservableValue)this.stereotypeLabel.textProperty().isNotEmpty());
        this.stereotypeLabel.managedProperty().bind((ObservableValue)this.stereotypeLabel.textProperty().isNotEmpty());
        JavaFXUtil.addStyleClass((Styleable)this.stereotypeLabel, "class-target-extra");
        this.pane.setTop((Node)new VBox(new Node[]{this.stereotypeLabel, this.nameLabel}));
        this.canvas = new ResizableCanvas(){

            @Override
            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            public void resize(double width, double height) {
                super.resize(width, height);
                ClassTarget.this.redraw();
            }
        };
        this.pane.setCenter((Node)this.canvas);
        this.noSourceLabel = new Label("");
        StackPane stackPane = new StackPane(new Node[]{this.pane.getCenter(), this.noSourceLabel});
        StackPane.setAlignment((Node)this.noSourceLabel, (Pos)Pos.TOP_CENTER);
        StackPane.setAlignment((Node)this.canvas, (Pos)Pos.CENTER);
        this.pane.setCenter((Node)stackPane);
        this.calcSourceAvailable();
        if (template != null) {
            if (template.startsWith("unittest")) {
                this.setRole(new UnitTestClassRole(UnitTestClassRole.UnitTestFramework.JUnit5));
            } else if (template.startsWith("abstract")) {
                this.setRole(new AbstractClassRole());
            } else if (template.startsWith("interface")) {
                this.setRole(new InterfaceClassRole());
            } else if (template.startsWith("enum")) {
                this.setRole(new EnumClassRole());
            } else {
                this.setRole(new StdClassRole());
            }
        }
        JavaFXUtil.addChangeListener(this.canvas.sceneProperty(), scene -> JavaFXUtil.runNowOrLater(() -> {
            this.nameLabel.applyCss();
            this.updateSize();
        }));
    }

    private void calcSourceAvailable() {
        if (this.getFrameSourceFile().canRead()) {
            this.sourceAvailable = SourceType.Stride;
            this.noSourceLabel.setText("");
        } else if (this.getJavaSourceFile().canRead()) {
            this.sourceAvailable = SourceType.Java;
            this.noSourceLabel.setText("");
        } else {
            this.sourceAvailable = SourceType.NONE;
            this.setState(DependentTarget.State.COMPILED);
            this.noSourceLabel.setText("(" + Config.getString("classTarget.noSource") + ")");
        }
    }

    public final BClass getBClass() {
        if (this.singleBClass == null) {
            this.singleBClass = ExtensionBridge.newBClass((ClassTarget)this);
        }
        return this.singleBClass;
    }

    @OnThread(value=Tag.Any)
    public String getQualifiedName() {
        return this.getPackage().getQualifiedName(this.getBaseName());
    }

    @OnThread(value=Tag.Any)
    public String getBaseName() {
        return this.getIdentifierName();
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public Reflective getTypeReflective() {
        ParsedTypeNode ptn;
        TextEditor textEditor;
        if (this.isCompiled()) {
            Class<?> cl = this.getPackage().loadClass(this.getQualifiedName());
            if (cl != null) {
                return new JavaReflective(cl);
            }
            return null;
        }
        JavaParentNode node = null;
        if (this.getEditor() != null && (textEditor = this.editor.assumeText()) != null) {
            node = textEditor.getParsedNode();
        }
        if (node != null && (ptn = (ParsedTypeNode)node.getTypeNode(this.getBaseName())) != null) {
            return new ParsedReflective(ptn);
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.getBaseName() + this.getTypeParameters();
    }

    @Override
    @OnThread(value=Tag.Any)
    public Package getPackage() {
        return super.getPackage();
    }

    private String getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public void setState(DependentTarget.State newState) {
        if (this.getState() != newState) {
            String qualifiedName = this.getQualifiedName();
            Project proj = this.getPackage().getProject();
            proj.removeInspectorInstance(qualifiedName);
            super.setState(newState);
            if (newState == DependentTarget.State.COMPILED && this.editor != null) {
                this.editor.reInitBreakpoints();
            }
            ClassEvent event = new ClassEvent(this.getPackage(), this.getBClass(), newState == DependentTarget.State.COMPILED, newState == DependentTarget.State.HAS_ERROR);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
        }
    }

    public void markCompiling(int compilationSequence) {
        boolean bl = this.compilationInvalid = this.editor != null ? this.editor.isModified() : false;
        if (this.getState() == DependentTarget.State.HAS_ERROR) {
            this.setState(DependentTarget.State.NEEDS_COMPILE);
        }
        if (this.getSourceType() == SourceType.Stride) {
            this.getEditor();
        }
        if (this.editor != null && this.editor.compileStarted(compilationSequence)) {
            this.setState(DependentTarget.State.HAS_ERROR);
        }
    }

    public ClassRole getRole() {
        return this.role;
    }

    protected final void setRole(ClassRole newRole) {
        if (this.role == null || this.role.getRoleName() != newRole.getRoleName()) {
            boolean shouldBeFront;
            this.role = newRole;
            String select = ClassTarget.pseudoFor(this.role.getClass());
            String stereotype = this.role.getStereotypeLabel();
            this.isFront = shouldBeFront = this.role == null || !(this.role instanceof UnitTestClassRole);
            JavaFXUtil.selectPseudoClass((Node)this.pane, Arrays.asList(pseudos).indexOf(select), pseudos);
            if (stereotype != null) {
                this.stereotypeLabel.setText(STEREOTYPE_OPEN + stereotype + STEREOTYPE_CLOSE);
            } else {
                this.stereotypeLabel.setText("");
            }
        }
    }

    @OnThread(value=Tag.Any)
    private static String pseudoFor(Class<? extends ClassRole> aClass) {
        String name = aClass.getSimpleName();
        if (name.endsWith("ClassRole")) {
            name = name.substring(0, name.length() - "ClassRole".length());
        }
        return "bj-" + name.toLowerCase();
    }

    public static boolean isJunit4TestClass(Class<?> cl) {
        ClassLoader clLoader = cl.getClassLoader();
        try {
            Class<?> beforeClass = Class.forName("org.junit.Before", false, clLoader);
            Class<?> afterClass = Class.forName("org.junit.After", false, clLoader);
            Class<?> testClass = Class.forName("org.junit.Test", false, clLoader);
            Method[] methods = cl.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].getAnnotation(beforeClass) != null) {
                    return true;
                }
                if (methods[i].getAnnotation(afterClass) != null) {
                    return true;
                }
                if (methods[i].getAnnotation(testClass) == null) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return false;
    }

    public static boolean isJunit5TestClass(Class<?> cl) {
        ClassLoader clLoader = cl.getClassLoader();
        try {
            Class[] matchingMethodAnnotationsClassArray = new Class[]{Class.forName("org.junit.jupiter.api.BeforeEach", false, clLoader), Class.forName("org.junit.jupiter.api.BeforeAll", false, clLoader), Class.forName("org.junit.jupiter.api.AfterEach", false, clLoader), Class.forName("org.junit.jupiter.api.AfterAll", false, clLoader), Class.forName("org.junit.jupiter.api.Test", false, clLoader), Class.forName("org.junit.jupiter.api.RepeatedTest", false, clLoader), Class.forName("org.junit.jupiter.api.DisplayName", false, clLoader), Class.forName("org.junit.jupiter.api.Tag", false, clLoader), Class.forName("org.junit.jupiter.api.TestFactory", false, clLoader), Class.forName("org.junit.jupiter.api.Disabled", false, clLoader), Class.forName("org.junit.jupiter.params.ParameterizedTest", false, clLoader), Class.forName("org.junit.jupiter.api.Nested", false, clLoader), Class.forName("org.junit.jupiter.api.TestInstance", false, clLoader)};
            Class[] matchingClassAnnotationsClassArray = new Class[]{Class.forName("org.junit.platform.suite.api.SelectPackages", false, clLoader), Class.forName("org.junit.platform.suite.api.SelectClasses", false, clLoader)};
            Method[] methods = cl.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class[] classArray = matchingMethodAnnotationsClassArray;
                int n = classArray.length;
                for (int j = 0; j < n; ++j) {
                    Class matchingClass = classArray[j];
                    if (methods[i].getAnnotation(matchingClass) == null) continue;
                    return true;
                }
            }
            for (Class matchingClass : matchingClassAnnotationsClassArray) {
                if (cl.getAnnotation(matchingClass) == null) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return false;
    }

    public void determineRole(Class<?> cl) {
        if (cl != null) {
            this.isAbstract = Modifier.isAbstract(cl.getModifiers());
            ClassLoader clLoader = cl.getClassLoader();
            Class junitClass = null;
            if (clLoader != null) {
                try {
                    junitClass = clLoader.loadClass("junit.framework.TestCase");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
            }
            if (junitClass == null) {
                junitClass = TestCase.class;
            }
            if (junitClass.isAssignableFrom(cl)) {
                this.setRole(new UnitTestClassRole(UnitTestClassRole.UnitTestFramework.JUnit3));
            } else if (Modifier.isInterface(cl.getModifiers())) {
                this.setRole(new InterfaceClassRole());
            } else if (JavaUtils.getJavaUtils().isEnum(cl)) {
                this.setRole(new EnumClassRole());
            } else if (this.isAbstract) {
                this.setRole(new AbstractClassRole());
            } else if (ClassTarget.isJunit4TestClass(cl)) {
                this.setRole(new UnitTestClassRole(UnitTestClassRole.UnitTestFramework.JUnit4));
            } else if (ClassTarget.isJunit5TestClass(cl)) {
                this.setRole(new UnitTestClassRole(UnitTestClassRole.UnitTestFramework.JUnit5));
            } else {
                this.setRole(new StdClassRole());
            }
        } else {
            this.isAbstract = false;
            ClassInfo classInfo = this.sourceInfo.getInfoIfAvailable();
            if (classInfo != null) {
                if (classInfo.isUnitTest()) {
                    this.setRole(new UnitTestClassRole(UnitTestClassRole.UnitTestFramework.JUnit3));
                } else if (classInfo.isInterface()) {
                    this.setRole(new InterfaceClassRole());
                } else if (classInfo.isEnum()) {
                    this.setRole(new EnumClassRole());
                } else if (classInfo.isAbstract()) {
                    this.setRole(new AbstractClassRole());
                } else if (!(this.role instanceof UnitTestClassRole)) {
                    this.setRole(new StdClassRole());
                }
            }
        }
    }

    @Override
    public void load(Properties props, String prefix) {
        super.load(props, prefix);
        String type = props.getProperty(prefix + ".type");
        String intf = props.getProperty(prefix + ".showInterface");
        this.openWithInterface = Boolean.valueOf(intf);
        if ("UnitTestTarget".equals(type)) {
            this.setRole(new UnitTestClassRole(UnitTestClassRole.UnitTestFramework.JUnit3));
        } else if ("UnitTestTargetJunit4".equals(type)) {
            this.setRole(new UnitTestClassRole(UnitTestClassRole.UnitTestFramework.JUnit4));
        } else if ("UnitTestTargetJunit5".equals(type)) {
            this.setRole(new UnitTestClassRole(UnitTestClassRole.UnitTestFramework.JUnit5));
        } else if ("AbstractTarget".equals(type)) {
            this.setRole(new AbstractClassRole());
        } else if ("InterfaceTarget".equals(type)) {
            this.setRole(new InterfaceClassRole());
        } else if ("EnumTarget".equals(type)) {
            this.setRole(new EnumClassRole());
        }
        this.getRole().load(props, prefix);
        String value = props.getProperty(prefix + ".naviview.expanded");
        if (value != null) {
            this.setNaviviewExpanded(Boolean.parseBoolean(value));
            this.setProperty("naviviewExpandedProperty", String.valueOf(value));
        }
        this.typeParameters = "";
        this.cachedBreakpoints.clear();
        try {
            String s;
            int i = 0;
            while ((s = props.getProperty(prefix + ".breakpoint." + Integer.toString(i), "")) != null && !s.isEmpty()) {
                this.cachedBreakpoints.add(Integer.parseInt(s));
                ++i;
            }
        }
        catch (NumberFormatException e) {
            Debug.reportError("Error parsing breakpoint line number", e);
        }
    }

    @Override
    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        if (this.getRole().getRoleName() != null) {
            props.put(prefix + ".type", this.getRole().getRoleName());
        }
        boolean intf = this.openWithInterface = this.showingInterface;
        if (this.getProperty("naviviewExpandedProperty") != null) {
            props.put(prefix + ".naviview.expanded", String.valueOf(this.getProperty("naviviewExpandedProperty")));
        } else if (this.isNaviviewExpanded.isPresent()) {
            props.put(prefix + ".naviview.expanded", String.valueOf(this.isNaviviewExpanded()));
        }
        props.put(prefix + ".showInterface", Boolean.valueOf(intf).toString());
        List breakpoints = this.editor != null && this.editor instanceof FrameEditor ? ((FrameEditor)this.editor).getBreakpoints() : this.cachedBreakpoints;
        for (int i = 0; i < breakpoints.size(); ++i) {
            props.put(prefix + ".breakpoint." + i, ((Integer)breakpoints.get(i)).toString());
        }
        this.getRole().save(props, 0, prefix);
    }

    public void reload() {
        this.calcSourceAvailable();
        if (this.sourceAvailable != SourceType.NONE) {
            if (this.editor != null) {
                this.editor.reloadFile();
            } else {
                this.analyseSource();
            }
        }
    }

    public boolean upToDate() {
        File src = this.getSourceFile();
        File clss = this.getClassFile();
        if (this.sourceAvailable == SourceType.NONE) {
            return true;
        }
        return clss.exists() && (!src.exists() || src.lastModified() <= clss.lastModified());
    }

    public void fixSourceModificationDate() {
        if (this.sourceAvailable == SourceType.NONE) {
            return;
        }
        File src = this.getSourceFile();
        long now = Instant.now().toEpochMilli();
        if (src.exists() && src.lastModified() > now + 1000L) {
            src.setLastModified(now);
            if (this.editor != null) {
                this.editor.setLastModified(src.lastModified());
            }
        }
    }

    public void invalidate() {
        this.invalidateInclDependents(new ArrayList<ClassTarget>());
    }

    private void invalidateInclDependents(ArrayList<ClassTarget> alreadyInvalidated) {
        this.compilationInvalid = true;
        if (this.hasSourceCode()) {
            this.setState(DependentTarget.State.NEEDS_COMPILE);
            if (this.editor != null) {
                JavaFXUtil.runAfterCurrent(() -> this.editor.removeErrorHighlights());
            }
        }
        alreadyInvalidated.add(this);
        for (Dependency d : this.dependents()) {
            ClassTarget dependent = (ClassTarget)d.getFrom();
            if (!dependent.hasSourceCode() || alreadyInvalidated.contains(dependent)) continue;
            dependent.invalidateInclDependents(alreadyInvalidated);
        }
    }

    public boolean isInterface() {
        return this.getRole() instanceof InterfaceClassRole;
    }

    public boolean isUnitTest() {
        return this.getRole() instanceof UnitTestClassRole;
    }

    public boolean isEnum() {
        return this.getRole() instanceof EnumClassRole;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean hasSourceCode() {
        return this.sourceAvailable != SourceType.NONE;
    }

    public SourceType getSourceType() {
        return this.sourceAvailable;
    }

    public File getJavaSourceFile() {
        if (null == this.getPackage()) {
            return null;
        }
        return new File(this.getPackage().getPath(), this.getBaseName() + "." + SourceType.Java.toString().toLowerCase());
    }

    public File getFrameSourceFile() {
        if (null == this.getPackage()) {
            return null;
        }
        return new File(this.getPackage().getPath(), this.getBaseName() + "." + SourceType.Stride.toString().toLowerCase());
    }

    @Override
    public File getSourceFile() {
        switch (this.sourceAvailable) {
            case Java: {
                return this.getJavaSourceFile();
            }
            case Stride: {
                return this.getFrameSourceFile();
            }
        }
        return null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void markCompiled(boolean successful, CompileType compileType) {
        if (this.compilationInvalid) {
            if (this.editor != null) {
                this.editor.compileFinished(successful, false);
            }
            return;
        }
        if (successful && compileType.keepClasses()) {
            this.fixSourceModificationDate();
            boolean newCompiledState = this.upToDate();
            if (newCompiledState &= !this.hasKnownError()) {
                this.setState(DependentTarget.State.COMPILED);
            }
        }
        if (this.editor != null) {
            this.editor.compileFinished(successful, compileType.keepClasses());
            if (this.isCompiled()) {
                this.editor.setCompiled(true);
            }
        }
    }

    public Collection<SourceFileInfo> getAllSourceFilesJavaLast() {
        ArrayList<SourceFileInfo> list = new ArrayList<SourceFileInfo>();
        if (this.sourceAvailable.equals((Object)SourceType.Stride)) {
            list.add(new SourceFileInfo(this.getFrameSourceFile(), SourceType.Stride));
        }
        list.add(new SourceFileInfo(this.getJavaSourceFile(), SourceType.Java));
        return list;
    }

    public File getContextFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + ".ctxt");
    }

    public File getClassFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + ".class");
    }

    public File getDocumentationFile() {
        String filename = this.getJavaSourceFile().getPath();
        String docFilename = this.getPackage().getProject().getDocumentationFile(filename);
        return new File(docFilename);
    }

    public File[] getInnerClassFiles() {
        File[] files = this.getPackage().getPath().listFiles(new InnerClassFileFilter());
        return files;
    }

    @Override
    public Editor getEditor() {
        boolean withInterface = this.openWithInterface;
        return this.getEditor(withInterface);
    }

    public Editor getEditorIfOpen() {
        return this.editor;
    }

    private Editor getEditor(boolean showInterface) {
        if (this.editor == null) {
            String filename;
            String docFilename = this.getDocumentationFile().getPath();
            if (this.sourceAvailable == SourceType.NONE) {
                filename = null;
                showInterface = true;
                if (!new File(docFilename).exists()) {
                    return null;
                }
            } else {
                filename = this.getSourceFile().getPath();
            }
            Project project = this.getPackage().getProject();
            PackageResolver resolver = new PackageResolver(project.getEntityResolver(), this.getPackage().getQualifiedName());
            FXPlatformRunnable openCallback = () -> {
                this.recordEditorOpen();
                for (DependentTarget.TargetListener stateListener : this.stateListeners) {
                    stateListener.editorOpened();
                }
            };
            if (this.sourceAvailable == SourceType.Java || this.sourceAvailable == SourceType.NONE) {
                this.editor = new FlowEditor(newWindow -> {
                    if (newWindow) {
                        return project.createNewFXTabbedEditor();
                    }
                    return project.getDefaultFXTabbedEditor();
                }, this.getBaseName(), (EditorWatcher)this, (EntityResolver)resolver, project.getJavadocResolver(), openCallback, PrefMgr.flagProperty("bluej.editor.syntaxHilighting"), true);
                ((TextEditor)this.editor).showFile(filename, project.getProjectCharset(), this.isCompiled(), docFilename);
            } else if (this.sourceAvailable == SourceType.Stride) {
                File frameSourceFile = this.getFrameSourceFile();
                File javaSourceFile = this.getJavaSourceFile();
                JavadocResolver javadocResolver = project.getJavadocResolver();
                Package pkg = this.getPackage();
                this.editor = new FrameEditor(frameSourceFile, javaSourceFile, (EditorWatcher)this, (EntityResolver)resolver, javadocResolver, pkg, openCallback);
            }
            if (this.editor != null) {
                this.editor.showInterface(showInterface);
            }
        }
        return this.editor;
    }

    private void recordEditorOpen() {
        if (!this.hasBeenOpened) {
            this.hasBeenOpened = true;
            switch (this.sourceAvailable) {
                case Java: {
                    Config.recordEditorOpen(Config.SourceType.Java);
                    break;
                }
                case Stride: {
                    Config.recordEditorOpen(Config.SourceType.Stride);
                    break;
                }
            }
        }
    }

    @Override
    public void ensureSaved() throws IOException {
        if (this.editor == null && this.sourceAvailable == SourceType.Stride) {
            this.getEditor();
        }
        super.ensureSaved();
    }

    public void inspect(final Window parent, final Node animateFromCentre) {
        final Project proj = this.getPackage().getProject();
        new Thread("Load and inspect class"){

            @Override
            @OnThread(value=Tag.Worker)
            public void run() {
                try {
                    FXPlatformSupplier<DebuggerClass> clss = ClassTarget.this.getPackage().getDebugger().getClass(ClassTarget.this.getQualifiedName(), true);
                    Platform.runLater(() -> proj.getClassInspectorInstance((DebuggerClass)clss.get(), ClassTarget.this.getPackage(), parent, animateFromCentre));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }.start();
    }

    @Override
    public void modificationEvent(Editor editor) {
        this.invalidate();
        this.removeBreakpoints();
        if (this.getPackage().getProject().getDebugger() != null) {
            this.getPackage().getProject().getDebugger().removeBreakpointsForClass(this.getQualifiedName());
        }
        if (this.isCompiled()) {
            this.setState(DependentTarget.State.NEEDS_COMPILE);
        }
        this.sourceInfo.setSourceModified();
    }

    @Override
    public void saveEvent(Editor editor) {
        ClassInfo info = this.analyseSource();
        if (info != null) {
            this.updateTargetFile(info);
        }
        this.determineRole(null);
    }

    @Override
    public boolean breakpointToggleEvent(int lineNo, boolean set) {
        if (this.isCompiled()) {
            boolean nowSet = this.getPackage().getDebugger().toggleBreakpoint(this.getQualifiedName(), lineNo, set, null);
            if (nowSet == set && this.getPackage() != null) {
                DataCollector.debuggerBreakpointToggle(this.getPackage(), this.getSourceFile(), lineNo, set);
            }
            return nowSet;
        }
        return false;
    }

    @Override
    public void clearAllBreakpoints() {
        Package pkg = this.getPackage();
        if (pkg != null) {
            pkg.getDebugger().removeBreakpointsForClass(this.getQualifiedName());
        }
    }

    public void removeBreakpoints() {
        if (this.editor != null) {
            this.editor.removeBreakpoints();
        }
    }

    public void reInitBreakpoints() {
        if (this.editor != null && this.isCompiled()) {
            this.editor.reInitBreakpoints();
        } else if (this.isCompiled() && this.sourceAvailable == SourceType.Stride) {
            ArrayList<Integer> breakpoints = new ArrayList<Integer>(this.cachedBreakpoints);
            for (Integer line : breakpoints) {
                this.breakpointToggleEvent(line, true);
            }
        }
    }

    public void removeStepMark() {
        if (this.editor != null) {
            this.editor.removeStepMark();
        }
    }

    public boolean isCompiled() {
        return this.getState() == DependentTarget.State.COMPILED;
    }

    @OnThread(value=Tag.FXPlatform)
    public void scheduleCompilation(boolean immediate, CompileReason reason, CompileType type) {
        if (Config.isGreenfoot() && type == CompileType.EXPLICIT_USER_COMPILE) {
            this.markModified();
            this.getPackage().getProject().scheduleCompilation(immediate, reason, type, this.getPackage());
        } else {
            this.getPackage().getProject().scheduleCompilation(immediate, reason, type, this);
        }
    }

    public void analyseAfterCompile() {
        Class<?> cl = this.getPackage().loadClass(this.getQualifiedName());
        this.determineRole(cl);
        this.analyseDependencies(cl);
        this.analyseTypeParams(cl);
    }

    public boolean generateSkeleton(String template, SourceType sourceType) {
        boolean success;
        if (template == null) {
            Debug.reportError("generate class skeleton error");
            return false;
        }
        switch (sourceType) {
            case Java: {
                success = this.role.generateSkeleton(template, this.getPackage(), this.getBaseName(), this.getJavaSourceFile().getPath());
                break;
            }
            case Stride: {
                this.addStride(Loader.buildTopLevelElement(template, this.getPackage().getProject().getEntityResolver(), this.getBaseName(), this.getPackage().getBaseName()));
                success = true;
                break;
            }
            default: {
                success = false;
            }
        }
        if (success) {
            this.setState(DependentTarget.State.NEEDS_COMPILE);
            this.sourceAvailable = sourceType;
            this.noSourceLabel.setText("");
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enforcePackage(String packageName) throws IOException {
        if (this.getSourceType() != SourceType.Java) {
            return;
        }
        if (!JavaNames.isQualifiedIdentifier(packageName)) {
            throw new IllegalArgumentException();
        }
        ClassInfo info = this.sourceInfo.getInfo(this.getSourceFile(), this.getPackage());
        if (info == null) {
            return;
        }
        String semiReplacement = null;
        String nameReplacement = null;
        String pkgStatementReplacement = null;
        if (packageName.length() == 0) {
            if (!info.hasPackageStatement()) return;
            semiReplacement = "";
            nameReplacement = "";
            pkgStatementReplacement = "";
        } else if (info.hasPackageStatement()) {
            if (info.getPackage().equals(packageName)) {
                return;
            }
            nameReplacement = packageName;
        } else {
            semiReplacement = ";\n\n";
            nameReplacement = packageName;
            pkgStatementReplacement = "package ";
        }
        FileEditor fed = new FileEditor(this.getSourceFile());
        if (semiReplacement != null) {
            Selection selSemi = info.getPackageSemiSelection();
            fed.replaceSelection(selSemi, semiReplacement);
        }
        if (nameReplacement != null) {
            Selection selName = info.getPackageNameSelection();
            fed.replaceSelection(selName, nameReplacement);
        }
        if (pkgStatementReplacement != null) {
            Selection selStatement = info.getPackageStatementSelection();
            fed.replaceSelection(selStatement, pkgStatementReplacement);
        }
        fed.save();
    }

    public ClassInfo analyseSource() {
        if (this.analysing) {
            return null;
        }
        this.analysing = true;
        ClassInfo info = this.sourceInfo.getInfo(this.getJavaSourceFile(), this.getPackage());
        if (info != null) {
            this.determineRole(null);
            this.setTypeParameters(info);
            this.analyseDependencies(info);
        }
        this.analysing = false;
        return info;
    }

    private void updateTargetFile(ClassInfo info) {
        if (this.analyseClassName(info)) {
            if (this.nameEqualsIgnoreCase(info.getName())) {
                this.doClassNameChange(info.getName() + TEMP_FILE_EXTENSION);
            }
            this.doClassNameChange(info.getName());
        }
        if (this.analysePackageName(info)) {
            this.doPackageNameChange(info.getPackage());
        }
    }

    private void setTypeParameters(ClassInfo info) {
        Object newTypeParameters = "";
        if (info.hasTypeParameter()) {
            Iterator<String> i = info.getTypeParameterTexts().iterator();
            newTypeParameters = "<" + i.next();
            while (i.hasNext()) {
                newTypeParameters = (String)newTypeParameters + "," + i.next();
            }
            newTypeParameters = (String)newTypeParameters + ">";
        }
        if (!((String)newTypeParameters).equals(this.typeParameters)) {
            this.typeParameters = newTypeParameters;
            this.updateDisplayName();
        }
    }

    public boolean analyseClassName(ClassInfo info) {
        String newName = info.getName();
        if (newName == null || newName.length() == 0) {
            return false;
        }
        return !this.getBaseName().equals(newName);
    }

    private boolean analysePackageName(ClassInfo info) {
        String newName = info.getPackage();
        return !this.getPackage().getQualifiedName().equals(newName);
    }

    private void analyseDependencies(ClassInfo info) {
        this.removeAllOutDependencies();
        this.removeInheritDependencies();
        Object pkgPrefix = this.getPackage().getQualifiedName();
        Object object = pkgPrefix = ((String)pkgPrefix).length() == 0 ? pkgPrefix : (String)pkgPrefix + ".";
        if (info.getSuperclass() != null) {
            this.setSuperClass(info.getSuperclass());
        }
        List<String> vect = info.getImplements();
        for (String name : vect) {
            this.addInterface(name);
        }
        vect = info.getUsed();
        for (String name : vect) {
            DependentTarget used = this.getPackage().getDependentTarget(name);
            if (used == null) continue;
            UsesDependency dependency = new UsesDependency(this.getPackage(), this, used);
            this.getPackage().addDependency(dependency);
        }
    }

    public void analyseDependencies(Class<?> cl) {
        if (cl != null) {
            this.removeInheritDependencies();
            Class<?> superClass = cl.getSuperclass();
            if (superClass != null) {
                this.setSuperClass(superClass.getName());
            }
            Class<?>[] interfaces = cl.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.addInterface(interfaces[i].getName());
            }
        }
    }

    public <T> void analyseTypeParams(Class<T> cl) {
        if (cl != null) {
            String oldTypeParams = this.typeParameters;
            TypeVariable<Class<T>>[] tvars = cl.getTypeParameters();
            if (tvars.length == 0) {
                this.typeParameters = "";
            } else {
                boolean isFirst = true;
                this.typeParameters = "<";
                for (TypeVariable<Class<T>> tvar : tvars) {
                    if (!isFirst) {
                        this.typeParameters = this.typeParameters + ",";
                    }
                    isFirst = false;
                    this.typeParameters = this.typeParameters + tvar.getName();
                }
                this.typeParameters = this.typeParameters + ">";
            }
            if (!this.typeParameters.equals(oldTypeParams)) {
                this.updateDisplayName();
            }
        }
    }

    private void setSuperClass(String superName) {
        String pkgPrefix = this.getPackage().getQualifiedName();
        if (superName.startsWith(pkgPrefix)) {
            int prefixLen = pkgPrefix.length();
            prefixLen = prefixLen == 0 ? 0 : prefixLen + 1;
            superName = superName.substring(prefixLen);
            DependentTarget superclass = this.getPackage().getDependentTarget(superName);
            if (superclass != null) {
                this.getPackage().addDependency(new ExtendsDependency(this.getPackage(), this, superclass));
                if (superclass.getState() != DependentTarget.State.COMPILED) {
                    this.markModified();
                }
            }
        }
    }

    private void addInterface(String interfaceName) {
        String pkgPrefix = this.getPackage().getQualifiedName();
        if (interfaceName.startsWith(pkgPrefix)) {
            int dotlen = pkgPrefix.length();
            dotlen = dotlen == 0 ? 0 : dotlen + 1;
            interfaceName = interfaceName.substring(dotlen);
            DependentTarget interfce = this.getPackage().getDependentTarget(interfaceName);
            if (interfce != null) {
                this.getPackage().addDependency(new ImplementsDependency(this.getPackage(), this, interfce));
                if (interfce.getState() != DependentTarget.State.COMPILED) {
                    this.markModified();
                }
            }
        }
    }

    private boolean doClassNameChange(String newName) {
        if (this.getPackage().getTarget(newName) != null) {
            this.getEditor().writeMessage(Config.getString("editor.info.duplication"));
            return false;
        }
        File oldJavaSourceFile = this.getJavaSourceFile();
        File newJavaSourceFile = new File(this.getPackage().getPath(), newName + "." + SourceType.Java.toString().toLowerCase());
        try {
            String filename;
            File oldFrameSourceFile = null;
            File newFrameSourceFile = null;
            this.getPackage().updateTargetIdentifier(this, this.getIdentifierName(), newName);
            if (this.getSourceType().equals((Object)SourceType.Stride)) {
                newFrameSourceFile = new File(this.getPackage().getPath(), newName + "." + SourceType.Stride.toString().toLowerCase());
                oldFrameSourceFile = this.getFrameSourceFile();
                FileUtility.copyFile(oldFrameSourceFile, newFrameSourceFile);
                filename = newFrameSourceFile.getAbsolutePath();
            } else {
                filename = newJavaSourceFile.getAbsolutePath();
            }
            FileUtility.copyFile(oldJavaSourceFile, newJavaSourceFile);
            String javaFilename = newJavaSourceFile.getAbsolutePath();
            String docFilename = this.getPackage().getProject().getDocumentationFile(javaFilename);
            this.getEditor().changeName(newName, filename, javaFilename, docFilename);
            this.deleteSourceFiles();
            this.getClassFile().delete();
            for (File innerClassFile : this.getInnerClassFiles()) {
                innerClassFile.delete();
            }
            this.getContextFile().delete();
            this.getDocumentationFile().delete();
            String oldName = this.getIdentifierName();
            this.setIdentifierName(newName);
            this.updateDisplayName();
            BClass bClass = this.getBClass();
            ExtensionBridge.ChangeBClassName((BClass)bClass, (String)this.getQualifiedName());
            DataCollector.renamedClass(this.getPackage(), oldFrameSourceFile, newFrameSourceFile, oldJavaSourceFile, newJavaSourceFile);
            for (DependentTarget.TargetListener stateListener : new ArrayList(this.stateListeners)) {
                stateListener.renamed(newName);
            }
            ClassEvent event = new ClassEvent(this.getPackage(), this.getBClass(), oldName);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public void updateDisplayName() {
        String newDisplayName = this.getDisplayName();
        this.updateSize();
        this.nameLabel.setText(newDisplayName);
        this.setDisplayName(newDisplayName);
        this.updateAccessibleName();
    }

    private void deleteSourceFiles() {
        if (this.getSourceType().equals((Object)SourceType.Stride)) {
            this.getJavaSourceFile().delete();
        }
        this.getSourceFile().delete();
    }

    private boolean nameEqualsIgnoreCase(String newName) {
        return this.getBaseName().equalsIgnoreCase(newName);
    }

    private void doPackageNameChange(String newName) {
        boolean packageNameClash;
        Project proj = this.getPackage().getProject();
        Package dstPkg = proj.getPackage(newName);
        boolean packageInvalid = dstPkg == null;
        boolean bl = packageNameClash = dstPkg != null && dstPkg.getTarget(this.getBaseName()) != null;
        if (packageInvalid) {
            DialogManager.showErrorFX(null, "package-name-invalid");
        } else if (packageNameClash) {
            DialogManager.showErrorFX(null, "package-name-clash");
        } else if (DialogManager.askQuestionFX(null, "package-name-changed") == 0) {
            dstPkg.importFile(this.getSourceFile());
            this.prepareForRemoval();
            this.getPackage().removeTarget(this);
            this.close();
            return;
        }
        try {
            this.enforcePackage(this.getPackage().getQualifiedName());
            this.getEditor().reloadFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateSize() {
        String displayName = this.getDisplayName();
        int width = ClassTarget.calculateWidth((Labeled)this.nameLabel, displayName, (int)this.pane.getPrefWidth());
        this.setSize(width, this.getHeight());
        this.repaint();
    }

    @Override
    public List<? extends AbstractOperation<Target>> getContextOperations() {
        boolean sourceOrDocExists;
        Class<?> cl = null;
        if (this.getState() == DependentTarget.State.COMPILED && (cl = this.getPackage().loadClass(this.getQualifiedName())) == null && this.sourceAvailable != SourceType.NONE) {
            this.getClassFile().delete();
            this.invalidate();
        }
        if (this.getState() != DependentTarget.State.COMPILED) {
            cl = null;
        }
        ArrayList<EditableTargetOperation> ops = new ArrayList<EditableTargetOperation>();
        ops.addAll(this.role.getRoleOperationsBegin(this, cl, this.getState()));
        if (cl != null) {
            if (Application.class.isAssignableFrom(cl)) {
                ops.add(new RunFXApplication(cl));
            }
            ops.addAll(this.role.getClassConstructorOperations(this, cl));
            ops.addAll(this.role.getClassStaticOperations(this, cl));
        }
        ops.addAll(this.role.getRoleOperationsEnd(this, this.getState()));
        boolean bl = sourceOrDocExists = this.sourceAvailable != SourceType.NONE || this.getDocumentationFile().exists();
        if (sourceOrDocExists) {
            ops.add(new EditAction());
        }
        if (this.sourceAvailable != SourceType.NONE) {
            ops.add(new CompileAction());
        }
        if (cl != null) {
            ops.add(new InspectAction(null));
        }
        ops.add(new RemoveClassAction());
        if (this.sourceAvailable != SourceType.NONE) {
            ops.add(new DuplicateClassAction());
        }
        Window parentWindow = this.pane.getScene().getWindow();
        if (this.sourceAvailable == SourceType.Stride) {
            ops.add(new ConvertToJavaAction(parentWindow));
        } else if (this.sourceAvailable == SourceType.Java && this.role.canConvertToStride()) {
            ops.add(new ConvertToStrideAction(parentWindow));
        }
        return ops;
    }

    private void putFXLaunchResult(final PackageEditor ed, final Window fxWindow, CompletableFuture<FXPlatformSupplier<DebuggerResult>> result) {
        result.thenAccept((Consumer)new Consumer<FXPlatformSupplier<DebuggerResult>>(){

            @Override
            @OnThread(value=Tag.Worker)
            public void accept(FXPlatformSupplier<DebuggerResult> supplier) {
                Platform.runLater(() -> {
                    DebuggerResult r = (DebuggerResult)supplier.get();
                    switch (r.getExitStatus()) {
                        case 0: {
                            DebuggerObject obj = r.getResultObject();
                            ed.raisePutOnBenchEvent(fxWindow, obj, obj.getGenType(), null, false, Optional.empty());
                        }
                    }
                });
            }
        });
    }

    public void promptAndConvertJavaToStride(Window window) {
        File javaSourceFile = this.getJavaSourceFile();
        Charset projectCharset = this.getPackage().getProject().getProjectCharset();
        if (JavaFXUtil.confirmDialog("convert.to.stride.title", "convert.to.stride.message", window, true)) {
            try {
                List<CodeElement> elements;
                Parser.ConversionResult javaConvertResult = Parser.javaToStride(Files.readAllLines(javaSourceFile.toPath(), projectCharset).stream().collect(Collectors.joining("\n")), Parser.JavaContext.TOP_LEVEL, false);
                if (!javaConvertResult.getWarnings().isEmpty()) {
                    new ConvertResultDialog(javaConvertResult.getWarnings().stream().map(ConversionWarning::getMessage).collect(Collectors.toList())).showAndWait();
                }
                if ((elements = javaConvertResult.getElements()).size() != 1 || !(elements.get(0) instanceof TopLevelCodeElement)) {
                    JavaFXUtil.errorDialog("convert.to.stride.error.title", "convert.to.stride.error.message");
                    return;
                }
                this.addStride((TopLevelCodeElement)((Object)elements.get(0)));
                DataCollector.convertJavaToStride(this.getPackage(), javaSourceFile, this.getFrameSourceFile());
            }
            catch (ParseFailure | IOException pf) {
                Debug.reportError(pf);
                new ConvertResultDialog(pf.getMessage()).showAndWait();
            }
        }
    }

    @Override
    public void doubleClick(boolean openInNewWindow) {
        Editor editor = this.getEditor();
        if (editor == null) {
            this.getPackage().showError("error-open-source");
        }
        editor.setEditorVisible(true, openInNewWindow);
    }

    @Override
    public void setSize(int width, int height) {
        int w = Math.max(width, 60);
        int h = Math.max(height, 30);
        super.setSize(w, h);
        if (this.assoc != null) {
            this.assoc.setSize(w, h);
        }
    }

    public void setVisible(boolean vis) {
        if (vis != this.visible) {
            this.visible = vis;
            this.pane.setVisible(vis);
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    protected void redraw() {
        this.removeResizingLines();
        GraphicsContext g = this.canvas.getGraphicsContext2D();
        double width = this.canvas.getWidth();
        double height = this.canvas.getHeight();
        g.clearRect(0.0, 0.0, width, height);
        if (this.getState() != DependentTarget.State.COMPILED) {
            g.setFill((Paint)(this.hasKnownError() ? ClassTarget.getRedStripeFill() : ClassTarget.getGreyStripeFill()));
            g.fillRect(0.0, 0.0, width, height);
        }
        this.drawResizingLines();
    }

    @OnThread(value=Tag.FX)
    public static ImagePattern getGreyStripeFill() {
        int size = 120;
        if (greyStripeImage == null) {
            greyStripeImage = JavaFXUtil.createImage(size, size, gImage -> JavaFXUtil.stripeRect(gImage, 0, 0, size, size, 9, 3, false, GREY_STRIPE));
        }
        return new ImagePattern(greyStripeImage, 0.0, 0.0, (double)size, (double)size, false);
    }

    @OnThread(value=Tag.FX)
    public static ImagePattern getRedStripeFill() {
        int size = 160;
        if (redStripeImage == null) {
            redStripeImage = JavaFXUtil.createImage(size, size, gImage -> {
                JavaFXUtil.stripeRect(gImage, 0, 0, size, size, 13, 3, false, RED_STRIPE);
                JavaFXUtil.stripeRect(gImage, 0, 0, size, size, 13, 3, true, RED_STRIPE);
            });
        }
        return new ImagePattern(redStripeImage, 0.0, 0.0, (double)size, (double)size, false);
    }

    private void prepareForRemoval() {
        if (this.editor != null) {
            this.editor.close();
        }
        for (Target o : this.getPackage().getVertices()) {
            DependentTarget d;
            if (!(o instanceof DependentTarget) || !this.equals((d = (DependentTarget)o).getAssociation())) continue;
            d.setAssociation(null);
        }
        this.invalidate();
        this.removeAllInDependencies();
        this.removeAllOutDependencies();
        this.prepareFilesForRemoval();
    }

    public void prepareFilesForRemoval() {
        List<File> allFiles = this.getRole().getAllFiles(this);
        Iterator<File> i = allFiles.iterator();
        while (i.hasNext()) {
            i.next().delete();
        }
    }

    public void generateDoc() {
        this.getPackage().generateDocumentation(this);
    }

    @Override
    public void remove() {
        File frameSourceFile = this.getSourceType().equals((Object)SourceType.Stride) ? this.getFrameSourceFile() : null;
        File javaSourceFile = this.getJavaSourceFile();
        this.prepareForRemoval();
        Package pkg = this.getPackage();
        pkg.removeTarget(this);
        ClassEvent event = new ClassEvent(this.getPackage(), this.getBClass());
        ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
        DataCollector.removeClass(pkg, frameSourceFile, javaSourceFile);
        if (Config.isGreenfoot()) {
            pkg.rebuild();
        }
    }

    public void convertStrideToJava() {
        File srcFile;
        if (this.sourceAvailable != SourceType.Stride) {
            throw new IllegalStateException("Cannot convert non-Stride from Stride to Java");
        }
        if (this.editor != null) {
            this.editor.close();
            try {
                this.editor.saveJavaWithoutWarning();
            }
            catch (IOException e) {
                Debug.reportError(e);
            }
            this.editor = null;
        }
        if ((srcFile = this.getSourceFile()).exists()) {
            srcFile.delete();
        }
        this.sourceAvailable = SourceType.Java;
        DataCollector.convertStrideToJava(this.getPackage(), srcFile, this.getSourceFile());
    }

    public void duplicate() {
        String originalClassName = this.getBaseName();
        SourceType sourceType = this.getSourceType();
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(this.getPackage());
        DuplicateClassDialog dialog = new DuplicateClassDialog((Window)pmf.getWindow(), "CopyOf" + originalClassName, sourceType);
        Optional duplicateClassName = dialog.showAndWait();
        duplicateClassName.ifPresent(name -> pmf.duplicateClass(originalClassName, (String)name, this.getSourceFile(), sourceType));
    }

    private void addStride(TopLevelCodeElement element) {
        if (this.editor != null) {
            this.editor.close();
            this.editor = null;
        }
        File strideFile = this.getFrameSourceFile();
        try {
            Files.write(strideFile.toPath(), Arrays.asList(Utility.splitLines(Utility.serialiseCodeToString(element.toXML()))), Charset.forName("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            Debug.reportError(e);
            JavaFXUtil.errorDialog(Config.getString("convert.to.stride.title"), e.getMessage());
            return;
        }
        this.sourceAvailable = SourceType.Stride;
    }

    @Override
    public void executeMethod(MethodView mv) {
        this.getPackage().callStaticMethodOrConstructor(mv);
    }

    @Override
    public void callConstructor(ConstructorView cv) {
        this.getPackage().callStaticMethodOrConstructor(cv);
    }

    public boolean checkDebuggerState() {
        return ProjectUtils.checkDebuggerState(this.getPackage().getProject(), this.getPackage().getUI().getStage());
    }

    public boolean isNaviviewExpanded() {
        return this.isNaviviewExpanded.orElse(false);
    }

    public void setNaviviewExpanded(boolean isNaviviewExpanded) {
        this.isNaviviewExpanded = Optional.of(isNaviviewExpanded);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void recordJavaEdit(String latest, boolean includeOneLineEdits) {
        DataCollector.editJava(this.getPackage(), this.getJavaSourceFile(), latest, includeOneLineEdits);
    }

    public void recordStrideEdit(String latestJava, String latestStride, StrideEditReason reason) {
        DataCollector.editStride(this.getPackage(), this.getJavaSourceFile(), latestJava, this.getFrameSourceFile(), latestStride, reason);
    }

    public void recordClose() {
        if (this.hasSourceCode()) {
            DataCollector.closeClass(this.getPackage(), this.getSourceFile());
        }
        this.recordedAsOpen = false;
    }

    public void recordOpen() {
        if (!this.recordedAsOpen && this.hasSourceCode()) {
            DataCollector.openClass(this.getPackage(), this.getSourceFile());
            this.recordedAsOpen = true;
        }
    }

    public void recordSelected() {
        if (this.hasSourceCode()) {
            DataCollector.selectClass(this.getPackage(), this.getSourceFile());
        }
    }

    public CompileInputFile getCompileInputFile() {
        return new CompileInputFile(this.getJavaSourceFile(), this.getSourceFile());
    }

    public boolean showDiagnostic(Diagnostic diagnostic, int errorIndex, CompileType compileType) {
        if (this.compilationInvalid) {
            return false;
        }
        Editor ed = this.getEditor();
        if (ed == null) {
            return false;
        }
        this.setState(DependentTarget.State.HAS_ERROR);
        return ed.displayDiagnostic(diagnostic, errorIndex, compileType);
    }

    @OnThread(value=Tag.Any)
    public boolean hasKnownError() {
        return this.getState() == DependentTarget.State.HAS_ERROR;
    }

    public void recordShowErrorMessage(int identifier, List<String> quickFixes) {
        DataCollector.showErrorMessage(this.getPackage(), identifier, quickFixes);
    }

    public void recordShowErrorIndicators(Collection<Integer> identifiers) {
        DataCollector.showErrorIndicators(this.getPackage(), identifiers);
    }

    public void recordEarlyErrors(List<DiagnosticWithShown> diagnostics, int compilationIdentifier) {
        if (diagnostics.isEmpty()) {
            return;
        }
        DataCollector.compiled(this.getPackage().getProject(), this.getPackage(), new CompileInputFile[]{this.getCompileInputFile()}, diagnostics, false, CompileReason.EARLY, compilationIdentifier);
    }

    public void recordLateErrors(List<DiagnosticWithShown> diagnostics, int compilationIdentifier) {
        if (diagnostics.isEmpty()) {
            return;
        }
        DataCollector.compiled(this.getPackage().getProject(), this.getPackage(), new CompileInputFile[]{this.getCompileInputFile()}, diagnostics, false, CompileReason.LATE, compilationIdentifier);
    }

    public void recordFix(int errorIdentifier, int fixIndex) {
        DataCollector.fixExecuted(this.getPackage(), errorIdentifier, fixIndex);
    }

    public void recordCodeCompletionStarted(Integer lineNumber, Integer columnNumber, String xpath, Integer subIndex, String stem, int codeCompletionId) {
        DataCollector.codeCompletionStarted(this, lineNumber, columnNumber, xpath, subIndex, stem, codeCompletionId);
    }

    public void recordCodeCompletionEnded(Integer lineNumber, Integer columnNumber, String xpath, Integer elementOffset, String stem, String replacement, int codeCompletionId) {
        DataCollector.codeCompletionEnded(this, lineNumber, columnNumber, xpath, elementOffset, stem, replacement, codeCompletionId);
    }

    public void recordUnknownCommandKey(String enclosingFrameXpath, int cursorIndex, char key) {
        DataCollector.unknownFrameCommandKey(this, enclosingFrameXpath, cursorIndex, key);
    }

    public void recordShowHideFrameCatalogue(String enclosingFrameXpath, int cursorIndex, boolean show, FrameCatalogue.ShowReason reason) {
        DataCollector.showHideFrameCatalogue(this.getPackage().getProject(), this.getPackage(), enclosingFrameXpath, cursorIndex, show, reason);
    }

    public void recordViewModeChange(String enclosingFrameXpath, int cursorIndex, Frame.View oldView, Frame.View newView, Frame.ViewChangeReason reason) {
        DataCollector.viewModeChange(this.getPackage(), this.getSourceFile(), enclosingFrameXpath, cursorIndex, oldView, newView, reason);
    }

    @Override
    public boolean isFront() {
        return this.isFront;
    }

    public void showingInterface(boolean showing) {
        this.showingInterface = showing;
    }

    @Override
    public void setCreatingExtends(boolean drawingExtends) {
        this.drawingExtends = drawingExtends;
    }

    @Override
    public boolean cursorAtResizeCorner(MouseEvent e) {
        return super.cursorAtResizeCorner(e) && !this.drawingExtends;
    }

    static {
        RED_STRIPE = Color.rgb((int)170, (int)80, (int)60);
        GREY_STRIPE = Color.rgb((int)158, (int)139, (int)116);
    }

    private static class RunFXApplication
    extends ClassTargetOperation {
        private final Class<?> cl;

        public RunFXApplication(Class<?> cl) {
            super("runFX", AbstractOperation.Combine.ONE, null, launchFXStr, AbstractOperation.MenuItemOrder.RUN_FX, "class-action-inbuilt");
            this.cl = cl;
        }

        @Override
        protected void execute(ClassTarget target) {
            PackageEditor ed = target.getPackage().getEditor();
            Window fxWindow = ed.getFXWindow();
            if (target.getPackage().getProject().getRunOnThread() == null) {
                int result = DialogManager.askQuestionFX(fxWindow, "run-on-fx");
                if (result == 0) {
                    target.getPackage().getProject().setRunOnThread(RunOnThread.FX);
                } else {
                    target.getPackage().getProject().setRunOnThread(RunOnThread.DEFAULT);
                }
            }
            CompletableFuture<FXPlatformSupplier<DebuggerResult>> result = target.getPackage().getDebugger().launchFXApp(this.cl.getName());
            target.putFXLaunchResult(ed, fxWindow, result);
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    class InnerClassFileFilter
    implements FileFilter {
        InnerClassFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().startsWith(ClassTarget.this.getBaseName() + "$");
        }
    }

    public static class SourceFileInfo {
        public final File file;
        public final SourceType sourceType;

        public SourceFileInfo(File file, SourceType sourceType) {
            this.file = file;
            this.sourceType = sourceType;
        }
    }
}

