/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.debugger.Debugger;
import bluej.extensions2.SourceType;
import bluej.pkgmgr.Project;
import bluej.utility.BlueJFileReader;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.Dictionary;
import java.util.Hashtable;
import javafx.stage.Stage;
import javafx.stage.Window;

public class ProjectUtils {
    public static boolean checkDebuggerState(Project project, Stage msgWindow) {
        Debugger debugger = project.getDebugger();
        if (debugger.getStatus() == 4) {
            DialogManager.showErrorFX((Window)msgWindow, "stuck-at-breakpoint");
            return false;
        }
        if (debugger.getStatus() == 3) {
            DialogManager.showErrorFX((Window)msgWindow, "already-executing");
            return false;
        }
        return true;
    }

    public static boolean saveProjectCopy(Project project, File newName, Stage window) {
        Path existingPath;
        Path newPath = newName.toPath().toAbsolutePath();
        if (newPath.startsWith(existingPath = project.getProjectDir().toPath().toAbsolutePath())) {
            DialogManager.showErrorFX((Window)window, "cannot-save-inside-self");
            return false;
        }
        int result = FileUtility.copyDirectory(project.getProjectDir(), newName);
        switch (result) {
            case 0: {
                break;
            }
            case 4: {
                DialogManager.showErrorFX((Window)window, "directory-exists-file");
                return false;
            }
            case 5: {
                DialogManager.showErrorFX((Window)window, "directory-exists-non-empty");
                return false;
            }
            case 2: 
            case 3: {
                DialogManager.showErrorFX((Window)window, "cannot-save-project");
                return false;
            }
        }
        return true;
    }

    public static void createSkeleton(String className, String superClassName, File file, String templateFileName, String projCharsetName) throws IOException {
        Hashtable<String, String> translations = new Hashtable<String, String>();
        ((Dictionary)translations).put("CLASSNAME", className);
        if (superClassName != null) {
            ((Dictionary)translations).put("EXTENDSANDSUPERCLASSNAME", "extends " + superClassName);
            ((Dictionary)translations).put("EXTENDSSUPERCLASSNAME", "extends=\"" + superClassName + "\"");
        } else {
            ((Dictionary)translations).put("EXTENDSANDSUPERCLASSNAME", "");
            ((Dictionary)translations).put("EXTENDSSUPERCLASSNAME", "");
        }
        String baseName = "greenfoot/templates/" + templateFileName;
        File template = Config.getLanguageFile(baseName);
        if (!template.canRead()) {
            template = Config.getDefaultLanguageFile(baseName);
        }
        BlueJFileReader.translateFile(template, file, translations, StandardCharsets.UTF_8, ProjectUtils.selectCharset(projCharsetName));
    }

    public static void duplicate(String originalClassName, String destinationClassName, File originalFile, File destination, SourceType type) throws IOException {
        Hashtable<String, String> translations = new Hashtable<String, String>();
        ((Dictionary)translations).put(originalClassName, destinationClassName);
        BlueJFileReader.duplicateFile(originalFile, destination, translations);
    }

    private static Charset selectCharset(String projCharsetName) {
        Charset projCharset;
        try {
            projCharset = Charset.forName(projCharsetName);
        }
        catch (UnsupportedCharsetException uce) {
            projCharset = StandardCharsets.UTF_8;
        }
        catch (IllegalCharsetNameException icne) {
            projCharset = StandardCharsets.UTF_8;
        }
        return projCharset;
    }
}

