/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class MouseTrackingOverlayPane
extends Pane {
    private final DoubleProperty mouseX = new SimpleDoubleProperty(0.0);
    private final DoubleProperty mouseY = new SimpleDoubleProperty(0.0);
    private final BooleanProperty mouseInsideProperty = new SimpleBooleanProperty(false);
    private final List<MousePositionListener> listeners = new ArrayList<MousePositionListener>();

    public MouseTrackingOverlayPane() {
        this.setMouseTransparent(true);
        JavaFXUtil.onceNotNull(this.parentProperty(), parent -> {
            parent.addEventFilter(MouseEvent.MOUSE_MOVED, e -> {
                Point2D p = this.sceneToLocal(e.getSceneX(), e.getSceneY());
                this.mouseX.set(p.getX());
                this.mouseY.set(p.getY());
                for (MousePositionListener l : this.listeners) {
                    l.mouseMoved(e.getSceneX(), e.getSceneY());
                }
            });
            parent.addEventFilter(MouseEvent.MOUSE_ENTERED, e -> this.mouseInsideProperty.set(true));
            parent.addEventFilter(MouseEvent.MOUSE_EXITED, e -> this.mouseInsideProperty.set(false));
        });
    }

    public void addMouseTrackingOverlay(Node info, boolean showWhenMouseLeft, DoubleExpression xOffset, DoubleExpression yOffset) {
        this.getChildren().add((Object)info);
        info.layoutXProperty().bind((ObservableValue)this.mouseX.add((ObservableNumberValue)xOffset));
        info.layoutYProperty().bind((ObservableValue)this.mouseY.add((ObservableNumberValue)yOffset));
        if (!showWhenMouseLeft) {
            info.visibleProperty().bind((ObservableValue)this.mouseInsideProperty);
        }
    }

    public void addMouseListener(MousePositionListener mouseListener) {
        this.listeners.add(mouseListener);
    }

    public void remove(Node node) {
        this.getChildren().remove((Object)node);
    }

    public void removeMouseListener(MousePositionListener mousePositionListener) {
        this.listeners.add(mousePositionListener);
    }

    @FunctionalInterface
    @OnThread(value=Tag.FXPlatform)
    public static interface MousePositionListener {
        public void mouseMoved(double var1, double var3);
    }
}

