/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.entity;

import bluej.debugger.gentype.FieldReflective;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.TypeArgumentEntity;
import bluej.utility.JavaUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ValueEntity
extends JavaEntity {
    private String name;
    private JavaType type;

    public ValueEntity(JavaType type) {
        this.type = type;
    }

    public ValueEntity(String name, JavaType type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JavaEntity getSubentity(String name, Reflective accessor) {
        GenTypeSolid ubound = this.type.getUpperBound().asSolid();
        if (ubound == null) {
            return null;
        }
        GenTypeSolid[] ubounds = ubound.getIntersectionTypes();
        GenTypeClass ctype = ubounds[0].asClass();
        if (ctype != null) {
            Map<String, FieldReflective> fields;
            Reflective ctypeRef = ctype.getReflective();
            LinkedList<Reflective> stypes = new LinkedList<Reflective>();
            stypes.add(ctypeRef);
            FieldReflective field = null;
            while (!stypes.isEmpty() && (field = (fields = (ctypeRef = (Reflective)stypes.poll()).getDeclaredFields()).get(name)) == null) {
                stypes.addAll(ctypeRef.getSuperTypesR());
            }
            if (field != null && JavaUtils.checkMemberAccess((ctype = ctype.mapToSuper(ctypeRef.getName())).getReflective(), this.type.asSolid(), accessor, field.getModifiers(), false)) {
                JavaType fieldType = field.getType();
                HashMap<String, GenTypeParameter> tparMap = ctype.getMap();
                fieldType = fieldType.mapTparsToTypes(tparMap).asType();
                return new ValueEntity(this.name + "." + name, fieldType);
            }
        }
        return null;
    }

    @Override
    public JavaType getType() {
        return this.type;
    }

    @Override
    public ValueEntity resolveAsValue() {
        return this;
    }

    @Override
    public JavaEntity setTypeArgs(List<TypeArgumentEntity> tparams) {
        return null;
    }

    public boolean hasConstantIntValue() {
        return false;
    }

    public long getConstantIntValue() {
        throw new RuntimeException("Attempt to get constant value for entity without constant value");
    }

    public boolean hasConstantFloatValue() {
        return false;
    }

    public double getConstantFloatValue() {
        throw new RuntimeException("Attempt to get constant value for entity without constant value");
    }

    public boolean hasConstantBooleanValue() {
        return false;
    }

    public boolean getConstantBooleanValue() {
        throw new RuntimeException("Attempt to get constant value for entity without constant value");
    }

    public boolean isConstantString() {
        return false;
    }

    public String getConstantString() {
        throw new RuntimeException("Attempt to get constant string value for an entity without such a value");
    }

    public static boolean isConstant(ValueEntity ent) {
        return ent.hasConstantBooleanValue() || ent.hasConstantIntValue() || ent.hasConstantFloatValue() || ent.isConstantString();
    }
}

